/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.controller;

import com.biz.eisp.activiti.runtime.entity.TaAttachmentEntity;
import com.biz.eisp.activiti.runtime.service.TaAttachmentService;
import com.biz.eisp.activiti.runtime.vo.TaAttachmentVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/taAttachmentController"})
public class TaAttachmentController {
    @Autowired
    private TaAttachmentService taAttachmentService;

    @RequestMapping(value={"saveFiles"})
    @ResponseBody
    public AjaxJson saveFiles(@RequestParam String taskId, String fileName, String realPath, String urlPath, String extend) {
        AjaxJson j = new AjaxJson();
        try {
            TaAttachmentEntity attachmentEntity = this.taAttachmentService.saveAttachement(taskId, fileName, realPath, urlPath, extend);
            List<TaAttachmentVo> myAttachmentList = this.taAttachmentService.findAttachmentList(taskId);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("url", attachmentEntity.getRealPath());
            attributes.put("fileKey", attachmentEntity.getId());
            attributes.put("name", attachmentEntity.getAttachmentTitle());
            attributes.put("delurl", "taAttachmentController/delObjFile?fileKey=" + attachmentEntity.getId());
            attributes.put("myAttachmentList", myAttachmentList);
            j.setAttributes(attributes);
            j.setMsg("\u6587\u4ef6\u6dfb\u52a0\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"delObjFile"})
    @ResponseBody
    public AjaxJson delObjFile(String fileKey) {
        AjaxJson j = new AjaxJson();
        try {
            this.taAttachmentService.deleteAttachment(fileKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"viewFile"})
    public void viewFile(@RequestParam(value="fileId") String fileKey) {
        this.taAttachmentService.viewOrDownloadFile(fileKey);
    }

    @RequestMapping(value={"findAttachmentList"})
    @ResponseBody
    public DataGrid findAttachmentList(String taskId, HttpServletRequest request) {
        List<TaAttachmentVo> taskList = this.taAttachmentService.findAttachmentList(taskId);
        return new DataGrid(taskList, null);
    }
}

