/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.controller;

import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeAuthService;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeAuthVo;
import com.biz.eisp.activiti.runtime.entity.TaAgencyApprovalEntity;
import com.biz.eisp.activiti.runtime.entity.TaAgencyApprovalProcessEntity;
import com.biz.eisp.activiti.runtime.entity.TaAttachmentEntity;
import com.biz.eisp.activiti.runtime.entity.TaCommunicateContentEntity;
import com.biz.eisp.activiti.runtime.service.TaAgencyApprovalProcessService;
import com.biz.eisp.activiti.runtime.service.TaAgencyApprovalService;
import com.biz.eisp.activiti.runtime.service.TaAttachmentService;
import com.biz.eisp.activiti.runtime.service.TaCommunicateService;
import com.biz.eisp.activiti.runtime.service.TaProcessInstanceService;
import com.biz.eisp.activiti.runtime.service.TaRejectRecordService;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.vo.BusinessFormVo;
import com.biz.eisp.activiti.runtime.vo.CommentVo;
import com.biz.eisp.activiti.runtime.vo.HistoryTaskVo;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.activiti.runtime.vo.OperationVo;
import com.biz.eisp.activiti.runtime.vo.TaAgencyApprovalProcessVo;
import com.biz.eisp.activiti.runtime.vo.TaAgencyApprovalVo;
import com.biz.eisp.activiti.runtime.vo.TaRejectRecordVo;
import com.biz.eisp.activiti.util.ParamUtil;
import com.biz.eisp.api.feign.RoleActivitiFeign;
import com.biz.eisp.api.feign.TmPositionFeign;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.role.TmActRoleVo;
import com.biz.eisp.util.ResourceService;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/taTaskController"})
public class TaTaskController {
    @Autowired(required=false)
    private RepositoryService repositoryService;
    @Autowired
    private TaTaskService taTaskService;
    @Autowired
    private TaRejectRecordService taRejectRecordService;
    @Autowired
    private TaProcessNodeService taProcessNodeService;
    @Autowired
    private TmPositionFeign tmPositionFeign;
    @Autowired
    private ResourceService resource;
    @Autowired
    private TaProcessInstanceService taProcessInstanceService;
    @Autowired
    private TaAttachmentService taAttachmentService;
    @Autowired
    private TaCommunicateService taCommunicateService;
    @Autowired
    private TaProcessNodeAuthService taProcessNodeAuthService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RoleActivitiFeign roleActivitiFeign;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private TaAgencyApprovalService taAgencyApprovalService;
    @Autowired
    private TaAgencyApprovalProcessService taAgencyApprovalProcessService;

    @RequestMapping(value={"goMyTaskMain"})
    public ModelAndView goMyTaskMain() {
        return new ModelAndView("com/biz/eisp/activiti/task/myTaskMain");
    }

    @RequestMapping(value={"findMyTaskList"})
    @ResponseBody
    public DataGrid findMyTaskList(HttpServletRequest request) {
        EuPage page = new EuPage(request);
        PageInfo pageInfo = new PageInfo();
        MyTaskVo myTaskVo = new MyTaskVo();
        ParamUtil.packParams(myTaskVo, (Page)page);
        List tmPositions = this.tmPositionFeign.getUserPositons(null, UserUtils.getUser().getId()).getObjList();
        ArrayList<String> assigneeList = new ArrayList<String>();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)tmPositions)) {
            for (TmPositionVo tmPosition : tmPositions) {
                assigneeList.add(tmPosition.getPositionCode());
            }
        } else {
            String positionCode = UserUtils.getUser().getPosCode();
            assigneeList.add(positionCode);
        }
        if (!CollectionUtil.listNotEmptyNotSizeZero(assigneeList)) {
            return new DataGrid(pageInfo);
        }
        List roleVos = this.roleActivitiFeign.getTmActRoleByUserId(UserUtils.getUser().getId()).getObjList();
        List<String> roles = roleVos.stream().map(TmActRoleVo::getRoleCode).collect(Collectors.toList());
        roles.add("1");
        myTaskVo.setAssigneeList(assigneeList);
        myTaskVo.setRoleCodes(roles);
        pageInfo = this.taTaskService.findMyTaskList(myTaskVo, (Page)page).getPageInfo();
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"goMyHistoryTaskMain"})
    public ModelAndView goMyHistoryTaskMain() {
        return new ModelAndView("com/biz/eisp/activiti/task/myHistoryTaskMain");
    }

    @RequestMapping(value={"findMyHistoryTaskList"})
    @ResponseBody
    public DataGrid findMyHistoryTaskList(HttpServletRequest request) {
        EuPage page = new EuPage(request);
        HistoryTaskVo historyTaskVo = new HistoryTaskVo();
        ParamUtil.packParams(historyTaskVo, (Page)page);
        historyTaskVo.setAssignee(UserUtils.getUser().getPosCode());
        PageInfo pageInfo = this.taTaskService.findMyHistoryTaskList(historyTaskVo, (Page)page).getPageInfo();
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"findMyRejectTaskList"})
    @ResponseBody
    public DataGrid findMyRejectTaskList(HttpServletRequest request) {
        EuPage page = new EuPage(request);
        TaRejectRecordVo taRejectRecordVo = new TaRejectRecordVo();
        ParamUtil.packParams(taRejectRecordVo, (Page)page);
        List<TmPositionVo> tmPositions = this.resource.getCurrPositionAll();
        ArrayList<String> assigneeList = new ArrayList<String>();
        if (CollectionUtil.listNotEmptyNotSizeZero(tmPositions)) {
            for (TmPositionVo tmPosition : tmPositions) {
                assigneeList.add(tmPosition.getPositionCode());
            }
        } else {
            String positionCode = this.resource.getCurrPosition().getPositionCode();
            assigneeList.add(positionCode);
        }
        taRejectRecordVo.setAssigneeList(assigneeList);
        PageInfo pageInfo = this.taRejectRecordService.findMyRejectTaskList(taRejectRecordVo, (Page)page).getPageInfo();
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"goInstanceHandleTabForm"})
    public ModelAndView goInstanceHandleTabForm(MyTaskVo myTaskVo, @RequestParam(value="isView") boolean isView, @RequestParam(value="isReadFlag") boolean isReadFlag, String recordId, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        String processInstanceId = myTaskVo.getProcessInstanceId();
        String isCommunicate = myTaskVo.getIsCommunicate();
        String id = myTaskVo.getId();
        request.setAttribute("taskId", (Object)taskId);
        request.setAttribute("processInstanceId", (Object)processInstanceId);
        request.setAttribute("isView", (Object)isView);
        request.setAttribute("isReadFlag", (Object)isReadFlag);
        request.setAttribute("recordId", (Object)recordId);
        request.setAttribute("isCommunicate", (Object)isCommunicate);
        request.setAttribute("id", (Object)id);
        return new ModelAndView("com/biz/eisp/activiti/task/taskHandleTabForm");
    }

    @RequestMapping(value={"goTaskBusinessForm"})
    public ModelAndView goTaskBusinessForm(MyTaskVo myTaskVo, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        BusinessFormVo formVo = StringUtils.isBlank((CharSequence)taskId) ? this.taProcessInstanceService.getProcessInstanceBusinessForm(myTaskVo.getProcessInstanceId()) : this.taTaskService.getTaskBusinessForm(taskId);
        if (formVo != null) {
            String modelAndView = formVo.getModelandview() + "&id=" + formVo.getBusinessObjId();
            request.setAttribute("nodeStart", (Object)modelAndView);
        }
        return new ModelAndView("com/biz/eisp/activiti/task/taskBusinessForm");
    }

    @RequestMapping(value={"goTaskOperateForm"})
    public ModelAndView goTaskOperateForm(MyTaskVo myTaskVo, @RequestParam(value="isView") boolean isView, @RequestParam(value="isReadFlag") boolean isReadFlag, String recordId, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        String processInstanceId = myTaskVo.getProcessInstanceId();
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            throw new BusinessException("\u6d41\u7a0b\u5b9e\u4f8bID\u4e22\u5931");
        }
        List<CommentVo> list = this.taTaskService.findActHiCommentEntity(processInstanceId);
        if (!isView) {
            boolean hasRejectNodes = this.taTaskService.hasRejectNodes(taskId, processInstanceId);
            request.setAttribute("hasRejectNodes", (Object)hasRejectNodes);
            request.setAttribute("isView", (Object)isView);
        }
        request.setAttribute("taskId", (Object)taskId);
        request.setAttribute("processInstanceId", (Object)processInstanceId);
        request.setAttribute("voList", list);
        request.setAttribute("isReadFlag", (Object)isReadFlag);
        request.setAttribute("recordId", (Object)recordId);
        return new ModelAndView("com/biz/eisp/activiti/task/taskOperateForm");
    }

    @RequestMapping(value={"saveComplete"})
    @ResponseBody
    public AjaxJson saveComplete(OperationVo operationVo) {
        AjaxJson json = new AjaxJson();
        try {
            this.taTaskService.saveComplete(operationVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            json.setErrMsg("\u4efb\u52a1\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
            return json;
        }
        return json;
    }

    @RequestMapping(value={"saveReject"})
    @ResponseBody
    public AjaxJson saveReject(OperationVo operationVo) {
        AjaxJson json = new AjaxJson();
        try {
            this.taTaskService.saveReject(operationVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            json.setErrMsg("\u4efb\u52a1\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
            return json;
        }
        return json;
    }

    @RequestMapping(value={"saveRejectToApply"})
    @ResponseBody
    public AjaxJson saveRejectToApply(OperationVo operationVo) {
        try {
            this.taTaskService.saveRejectToApply(operationVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            AjaxJson json = new AjaxJson();
            json.setErrMsg("\u4efb\u52a1\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
            return json;
        }
        return new AjaxJson();
    }

    @RequestMapping(value={"saveReadRejectStatus"})
    @ResponseBody
    public AjaxJson saveReadRejectStatus(String recordId) {
        try {
            this.taRejectRecordService.updateTaRejectRecordStatus(recordId);
        }
        catch (Exception e) {
            e.printStackTrace();
            AjaxJson json = new AjaxJson();
            json.setErrMsg("\u4efb\u52a1\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
            return json;
        }
        return new AjaxJson();
    }

    @RequestMapping(value={"goReassignForm"})
    public ModelAndView goReassignForm(MyTaskVo myTaskVo, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        request.setAttribute("taskId", (Object)taskId);
        return new ModelAndView("com/biz/eisp/activiti/task/reassignForm");
    }

    @RequestMapping(value={"reassign"})
    @ResponseBody
    public AjaxJson reassign(MyTaskVo myTaskVo, String reassignComment, String id, HttpServletRequest request) {
        try {
            this.taTaskService.reassign(myTaskVo, reassignComment, id);
            return new AjaxJson();
        }
        catch (Exception e) {
            e.printStackTrace();
            AjaxJson json = new AjaxJson();
            json.setErrMsg("\u4efb\u52a1\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
            return json;
        }
    }

    @RequestMapping(value={"goPositionList"})
    public ModelAndView goPositionList(MyTaskVo myTaskVo, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        request.setAttribute("taskId", (Object)taskId);
        return new ModelAndView("com/biz/eisp/activiti/task/positionList");
    }

    @RequestMapping(value={"goTaskAbstractForm"})
    public ModelAndView goTaskAbstractForm(String processInstanceId) {
        ModelAndView mv = new ModelAndView("com/biz/eisp/activiti/task/taskAbstractForm");
        MyTaskVo processVo = this.taTaskService.findProcessBasicInfoByProcinstId(processInstanceId);
        List<TaAttachmentEntity> attachments = this.taAttachmentService.findAttachmentListByProcinstId(processInstanceId);
        mv.addObject("processVo", (Object)processVo);
        mv.addObject("attachment", attachments);
        return mv;
    }

    @RequestMapping(value={"goTaskDetailForm"})
    public ModelAndView goTaskDetailForm(MyTaskVo myTaskVo, HttpServletRequest request, Boolean booView) {
        String modelAndView;
        ModelAndView mv = new ModelAndView("com/biz/eisp/activiti/task/taskDetailForm");
        BusinessFormVo businessFormVo = this.taProcessInstanceService.getProcessInstanceBusinessForm(myTaskVo.getProcessInstanceId());
        mv.addObject("taskId", (Object)myTaskVo.getTaskId());
        mv.addObject("processInstanceId", (Object)myTaskVo.getProcessInstanceId());
        mv.addObject("businessKey", (Object)businessFormVo.getBusinessObjId());
        mv.addObject("currPositionCode", (Object)this.resource.getCurrPosition().getPositionCode());
        mv.addObject("isReadFlag", (Object)request.getParameter("isReadFlag"));
        if (ConstantEnum.YesNoEnum.Y.getValue().equals(myTaskVo.getIsCommunicate())) {
            booView = true;
            TaCommunicateContentEntity communicateEntity = this.taCommunicateService.getCommunicateContentById(myTaskVo.getId());
            mv.addObject("communicateContent", (Object)communicateEntity.getContent());
            mv.addObject("communicateId", (Object)communicateEntity.getId());
        }
        mv.addObject("booView", (Object)booView);
        mv.addObject("isCommunicate", (Object)myTaskVo.getIsCommunicate());
        if (!booView.booleanValue()) {
            boolean hasRejectNodes = this.taTaskService.hasRejectNodes(myTaskVo.getTaskId(), myTaskVo.getProcessInstanceId());
            mv.addObject("hasRejectNodes", (Object)hasRejectNodes);
            List historicTaskInstanceList = this.historyService.createHistoricTaskInstanceQuery().processInstanceId(myTaskVo.getProcessInstanceId()).taskDeleteReason("completed").list();
            ArrayList backTaskIdlist = new ArrayList();
            HashMap mapTemp = new HashMap();
            historicTaskInstanceList.forEach(item -> {
                if (!mapTemp.containsKey(item.getTaskDefinitionKey())) {
                    mapTemp.put(item.getTaskDefinitionKey(), item.getTaskDefinitionKey());
                } else {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", item.getTaskDefinitionKey());
                    map.put("name", item.getName());
                    backTaskIdlist.add(map);
                }
            });
            mv.addObject("processNode", backTaskIdlist);
        }
        if ((modelAndView = StringUtils.isBlank((CharSequence)myTaskVo.getTaskId()) ? businessFormVo.getModelandview() : this.taTaskService.getTaskBusinessForm(myTaskVo.getTaskId()).getModelandview()) != null) {
            modelAndView = modelAndView + "?isKeyIndicators=true&businessObjId=" + businessFormVo.getBusinessObjId();
        }
        mv.addObject("nodeStart", (Object)modelAndView);
        AjaxJson indicator = this.taTaskService.findKeyIndicators(myTaskVo);
        if (indicator.isSuccess()) {
            Map attrs = indicator.getAttributes();
            for (String attr : attrs.keySet()) {
                mv.addObject(attr, attrs.get(attr));
            }
        }
        List logs = this.taTaskService.findApprovalLogs(myTaskVo).getObjList();
        mv.addObject("log", (Object)logs);
        MyTaskVo processVo = this.taTaskService.findProcessBasicInfoByProcinstId(myTaskVo.getProcessInstanceId());
        List<TaAttachmentEntity> attachments = this.taAttachmentService.findAttachmentListByProcinstId(myTaskVo.getProcessInstanceId());
        mv.addObject("processVo", (Object)processVo);
        mv.addObject("attachment", attachments);
        TaProcessNodeAuthVo nodeAuthVo = this.taProcessNodeAuthService.getNodeAuthByTaskId(myTaskVo.getTaskId());
        mv.addObject("nodeAuth", (Object)nodeAuthVo);
        return mv;
    }

    @RequestMapping(value={"goAgencyApproval"})
    public ModelAndView goAgencyApproval(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/activiti/task/agencyApprovalMain");
    }

    @RequestMapping(value={"findAgencyApprovalPage"})
    @ResponseBody
    public DataGrid findAgencyApprovalPage(HttpServletRequest request, TaAgencyApprovalVo taAgencyApprovalVo) {
        EuPage page = new EuPage(request);
        PageInfo<TaAgencyApprovalEntity> pageInfo = this.taAgencyApprovalService.findTaAgencyApprovalPageList(taAgencyApprovalVo, (Page)page);
        if (pageInfo != null) {
            return new DataGrid(pageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"addAgencyApproval"})
    @ResponseBody
    public AjaxJson addAgencyApproval(String userIds, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            j = this.taAgencyApprovalService.addAgencyApproval(userIds);
        }
        catch (Exception e) {
            j.setMsg("\u6dfb\u52a0\u4ee3\u7406\u5ba1\u6279\u7528\u6237\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            j.setSuccess(false);
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(value={"deleteAgencyApproval"})
    @ResponseBody
    public AjaxJson deleteAgencyApproval(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            this.taAgencyApprovalService.deleteAgencyApproval(ids);
        }
        catch (Exception e) {
            j.setMsg("\u79fb\u9664\u4ee3\u7406\u5ba1\u6279\u7528\u6237\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            j.setSuccess(false);
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(value={"goAgencyApprovalProcess"})
    public ModelAndView goAgencyApprovalProcess(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/activiti/task/agencyApprovalProcessMain");
    }

    @RequestMapping(value={"findAgencyApprovalProcessPage"})
    @ResponseBody
    public DataGrid findAgencyApprovalProcessPage(HttpServletRequest request, TaAgencyApprovalProcessVo taAgencyApprovalProcessVo) {
        EuPage page = new EuPage(request);
        PageInfo<TaAgencyApprovalProcessEntity> pageInfo = this.taAgencyApprovalProcessService.findTaAgencyApprovalProcessPageList(taAgencyApprovalProcessVo, (Page)page);
        if (pageInfo != null) {
            return new DataGrid(pageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"deleteAgencyApprovalProcess"})
    @ResponseBody
    public AjaxJson deleteAgencyApprovalProcess(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            this.taAgencyApprovalProcessService.delete(ids);
        }
        catch (Exception e) {
            j.setMsg("\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            j.setSuccess(false);
            e.printStackTrace();
        }
        return j;
    }
}

