/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.activiti.designer.processconf.dao.ActTargetContentDao;
import com.biz.eisp.activiti.designer.processconf.entity.ActTargetConfigEntity;
import com.biz.eisp.activiti.designer.processconf.entity.ActTargetContentEntity;
import com.biz.eisp.activiti.designer.processconf.service.ActTargetConfigService;
import com.biz.eisp.activiti.designer.processconf.vo.ActTargetConfigHead;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import tk.mybatis.mapper.entity.Example;

@Controller
@RequestMapping(value={"actTargetConfigController"})
public class ActTargetConfigController {
    @Autowired
    private ActTargetConfigService actTargetConfigService;
    @Autowired
    private ActTargetContentDao actTargetContentDao;

    @RequestMapping(value={"goTargetMain"})
    public ModelAndView goTargetMain(String taProcessId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/bpmtarget/bpmTarget");
        view.addObject("taProcessId", (Object)taProcessId);
        return view;
    }

    @RequestMapping(value={"getTargetListPage"})
    @ResponseBody
    public DataGrid getTargetListPage(HttpServletRequest request, ActTargetConfigEntity entity) {
        EuPage page = new EuPage(request);
        PageInfo<ActTargetConfigEntity> pageInfo = this.actTargetConfigService.getMaiList(entity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"saveDate"})
    @ResponseBody
    public AjaxJson saveDate(@RequestBody ActTargetConfigHead head) {
        AjaxJson ajaxJson = this.actTargetConfigService.saveData(head.getItems(), head.getProcessId());
        return ajaxJson;
    }

    @RequestMapping(value={"getTargetConfigJson/{processInstanceId}"})
    @ResponseBody
    public AjaxJson getTargetConfigJson(@PathVariable(value="processInstanceId") String processInstanceId) {
        AjaxJson ajaxJson = new AjaxJson();
        Example example = new Example(ActTargetContentEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("processInstanceId", (Object)processInstanceId);
        List entities = this.actTargetContentDao.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)entities)) {
            ActTargetContentEntity entity = (ActTargetContentEntity)entities.get(0);
            String targetText = entity.getTargetText();
            JSONObject object = JSONObject.parseObject((String)targetText);
            ajaxJson.setObj((Object)object);
        } else {
            ajaxJson.setErrMsg("\u672a\u8bbe\u7f6e\u5173\u952e\u6307\u6807");
        }
        return ajaxJson;
    }
}

