/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.controller;

import com.biz.eisp.activiti.designer.processconf.entity.TaProcessOrgPageEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessOrgPageService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessOrgPageVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.tools.DictUtil;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"taProcessOrgPageController"})
public class TaProcessOrgPageController {
    @Autowired
    private TaProcessOrgPageService taProcessOrgPageService;

    @RequestMapping(value={"goTaProcessOrgPageMain"})
    public ModelAndView goTaProcessOrgPageMain(String taProcessId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/bpmrelation/taProcessOrgPageMain");
        view.addObject("taProcessId", (Object)taProcessId);
        return view;
    }

    @RequestMapping(value={"findProcessOrgPageList"})
    @ResponseBody
    public DataGrid findProcessOrgPageList(HttpServletRequest request) {
        EuPage page = new EuPage(request);
        PageInfo<TaProcessOrgPageEntity> pageInfo = this.taProcessOrgPageService.findTaProcessOrgPageList((Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"goTaProcessOrgPageForm"})
    public ModelAndView goTaProcessOrgPageForm(String id, String processId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/bpmrelation/taProcessOrgPageForm");
        TaProcessOrgPageVo vo = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            vo = this.taProcessOrgPageService.getProcessOrgPageById(id);
        } else {
            vo = new TaProcessOrgPageVo();
            vo.setProcessId(processId);
        }
        view.addObject("vo", (Object)vo);
        return view;
    }

    @RequestMapping(value={"goPageListMain"})
    public ModelAndView goPageListMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/activiti/designer/bpmrelation/taPageListMain");
    }

    @RequestMapping(value={"getTaPageList"})
    @ResponseBody
    public DataGrid getTaPageList() {
        List list = DictUtil.getDictList((String)"activiti_page_type");
        return new DataGrid(list, null);
    }

    @RequestMapping(value={"goOrgTypeListMain"})
    public ModelAndView goOrgTypeListMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/activiti/designer/bpmrelation/taOrgTypeListMain");
    }

    @RequestMapping(value={"getTaOrgTypeList"})
    @ResponseBody
    public DataGrid getTaOrgTypeList() {
        List list = DictUtil.getDictList((String)"org_type");
        return new DataGrid(list, null);
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(HttpServletRequest request, TaProcessOrgPageEntity entity) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = StringUtil.isEmpty((String)entity.getId()) ? this.taProcessOrgPageService.save(entity, ajaxJson) : this.taProcessOrgPageService.update(entity, ajaxJson);
        return ajaxJson;
    }

    @ResponseBody
    @RequestMapping(value={"delete"})
    public AjaxJson delete(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.taProcessOrgPageService.delete(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @GetMapping(value={"getProcessOrgPageById"})
    @ResponseBody
    public AjaxJson<TaProcessOrgPageVo> getProcessOrgPageById(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TaProcessOrgPageVo vo = this.taProcessOrgPageService.getProcessOrgPageById(id);
        ajaxJson.setObj((Object)vo);
        return ajaxJson;
    }

    @GetMapping(value={"getBpmKey"})
    @ResponseBody
    public AjaxJson<String> getBpmKey(@RequestParam(value="processPage") String processPage, @RequestParam(value="processOrgType") List<String> processOrgType) {
        AjaxJson ajaxJson = new AjaxJson();
        List<String> bpmKeys = this.taProcessOrgPageService.getBpmKey(processPage, processOrgType);
        ajaxJson.setList(bpmKeys);
        return ajaxJson;
    }
}

