/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.service.impl;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessDefinitionDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaRRoleProcDefDao;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaRRoleProcDefEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessDefinitionService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessDefinitionVo;
import com.biz.eisp.activiti.entity.activiti.ActHiProcinstEntity;
import com.biz.eisp.activiti.runtime.dao.ActHiProcinstDao;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="taProcessDefinitionService")
@Transactional
public class TaProcessDefinitionServiceImpl
implements TaProcessDefinitionService {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private TaProcessDao taProcessDao;
    @Autowired
    private ActHiProcinstDao actHiProcinstDao;
    @Autowired
    private TaRRoleProcDefDao taRRoleProcDefDao;
    @Autowired
    private TaProcessDefinitionDao taProcessDefinitionDao;

    @Override
    public PageInfo<TaProcessDefinitionVo> findProcessDefinitionList(TaProcessDefinitionVo taProcessDefinitionVo, Page page) {
        if (StringUtils.isBlank((CharSequence)taProcessDefinitionVo.getProcessDefinitionKey())) {
            throw new BusinessException("\u6ca1\u6709\u4f20\u9012\u6d41\u7a0b\u5b9a\u4e49key");
        }
        PageInfo voList = PageAutoHelperUtil.generatePage(() -> this.taProcessDefinitionDao.findProcessDefinitionList(taProcessDefinitionVo), (Page)page);
        return voList;
    }

    @Override
    public void deleteProcessDefinition(String deploymentId, String processDefinitionKey) {
        TaProcessEntity tt = new TaProcessEntity();
        tt.setProcessKey(processDefinitionKey);
        TaProcessEntity taProcessEntity = (TaProcessEntity)this.taProcessDao.selectOne(tt);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId).processDefinitionKey(processDefinitionKey).singleResult();
        ActHiProcinstEntity his = new ActHiProcinstEntity();
        his.setProcDefId(processDefinition.getId());
        List actHiProcinsts = this.actHiProcinstDao.select(his);
        if (actHiProcinsts.size() > 0) {
            throw new BusinessException("\u6d41\u7a0b\u8ddf\u4e1a\u52a1\u5df2\u5173\u8054\u65e0\u6cd5\u5220\u9664");
        }
        this.repositoryService.deleteDeployment(deploymentId, true);
        this.deleteTaRRoleDef(deploymentId);
        taProcessEntity.setProcessState(WorkFlowGlobals.PROCESS_DEPLOY_NO);
        this.taProcessDao.updateByPrimaryKeySelective(taProcessEntity);
    }

    @Override
    public String toggleProcessState(String currentState, String processDefinitionId) {
        String msg;
        if (currentState.equals("active")) {
            this.repositoryService.activateProcessDefinitionById(processDefinitionId, true, null);
            msg = "\u6d41\u7a0b\u5df2\u6fc0\u6d3b";
        } else {
            this.repositoryService.suspendProcessDefinitionById(processDefinitionId, true, null);
            msg = "\u6d41\u7a0b\u5df2\u6302\u8d77";
        }
        return msg;
    }

    @Override
    public byte[] getResourceAsByte(String diagramResourceName, String deploymentId) throws IOException {
        InputStream resourceAsStream = this.repositoryService.getResourceAsStream(deploymentId, diagramResourceName);
        byte[] bytes = new byte[1024];
        resourceAsStream.read(bytes);
        return bytes;
    }

    private void deleteTaRRoleDef(String deploymentId) {
        Example example = new Example(TaRRoleProcDefEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("deploymentId", (Object)deploymentId);
        this.taRRoleProcDefDao.deleteByExample(example);
    }
}

