/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.service.impl;

import com.biz.eisp.activiti.designer.processconf.dao.TaProcessDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessOrgDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessOrgPageDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessPageDao;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessOrgEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessOrgPageEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessPageEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessOrgPageService;
import com.biz.eisp.activiti.designer.processconf.transformer.TaProcessOrgPageEntityToTaProcessOrgPageVo;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessOrgPageVo;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessOrgVo;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessPageVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.tag.tags.FormTags;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.utils.JsonPropertyUtil;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="taProcessOrgPageService")
@Transactional
public class TaProcessOrgPageServiceImpl
implements TaProcessOrgPageService {
    @Autowired
    private TaProcessOrgPageDao taProcessOrgPageDao;
    @Autowired
    private TaProcessDao taProcessDao;
    @Autowired
    private TaProcessPageDao taProcessPageDao;
    @Autowired
    private TaProcessOrgDao taProcessOrgDao;

    @Override
    public PageInfo<TaProcessOrgPageEntity> findTaProcessOrgPageList(Page page) {
        Example example = new Example(TaProcessOrgPageEntity.class);
        Example.Criteria criteriarc = example.createCriteria();
        String processId = (String)page.get((Object)"processId");
        if (StringUtils.isNotBlank((CharSequence)processId)) {
            criteriarc.andEqualTo("processId", (Object)processId);
        }
        return PageAutoHelperUtil.generatePage(() -> this.taProcessOrgPageDao.selectByExample(example), (Page)page);
    }

    @Override
    public TaProcessOrgPageVo getProcessOrgPageById(String id) {
        TaProcessOrgPageEntity entity = (TaProcessOrgPageEntity)this.taProcessOrgPageDao.selectByPrimaryKey(id);
        TaProcessOrgPageVo vo = new TaProcessOrgPageEntityToTaProcessOrgPageVo().apply(entity);
        Example examplePage = new Example(TaProcessPageEntity.class);
        Example.Criteria criteriaDetail = examplePage.createCriteria();
        criteriaDetail.andEqualTo("processKey", (Object)entity.getProcessKey());
        List pageEntities = this.taProcessPageDao.selectByExample(examplePage);
        ArrayList pageTags = new ArrayList();
        pageEntities.forEach(item -> {
            FormTags formTags = new FormTags();
            formTags.setCode(item.getPageCode());
            formTags.setName(item.getPageName());
            pageTags.add(formTags);
        });
        vo.setPageFormTags(pageTags);
        Example exampleOrgType = new Example(TaProcessOrgEntity.class);
        Example.Criteria criteriaOrgType = exampleOrgType.createCriteria();
        criteriaOrgType.andEqualTo("processKey", (Object)entity.getProcessKey());
        List orgTypeEntities = this.taProcessOrgDao.selectByExample(exampleOrgType);
        ArrayList orgTypeTags = new ArrayList();
        orgTypeEntities.forEach(item -> {
            FormTags formTags = new FormTags();
            formTags.setCode(item.getOrgTypeCode());
            formTags.setName(item.getOrgTypeName());
            orgTypeTags.add(formTags);
        });
        vo.setOrgTypeFormTags(orgTypeTags);
        return vo;
    }

    @Override
    public AjaxJson save(TaProcessOrgPageEntity entity, AjaxJson ajaxJson) {
        List<TaProcessPageVo> listEntity;
        TaProcessPageVo[] entities;
        if (StringUtil.isBlank((CharSequence)entity.getPageJson())) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u8bf7\u9009\u62e9\u53ef\u9009\u9875\u9762");
            return ajaxJson;
        }
        Example example = new Example(TaProcessOrgPageEntity.class);
        Example.Criteria criteriaDetail = example.createCriteria();
        criteriaDetail.andEqualTo("processId", (Object)entity.getProcessId());
        List taProcessOrgPageEntities = this.taProcessOrgPageDao.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)taProcessOrgPageEntities)) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u8be5\u6d41\u7a0bKEY\u5df2\u5b58\u5728\u4e1a\u52a1\u5173\u7cfb\uff0c\u8bf7\u524d\u5f80\u4fee\u6539\uff01");
            return ajaxJson;
        }
        TaProcessEntity taProcessEntity = null;
        if (StringUtil.isNotEmpty((CharSequence)entity.getProcessId())) {
            taProcessEntity = (TaProcessEntity)this.taProcessDao.selectByPrimaryKey(entity.getProcessId());
        }
        entity.setProcessKey(taProcessEntity.getProcessKey());
        if (StringUtil.isNotEmpty((CharSequence)entity.getPageJson())) {
            StringBuffer processPage = new StringBuffer();
            entities = (TaProcessPageVo[])JsonPropertyUtil.toObject((String)entity.getPageJson(), TaProcessPageVo[].class);
            listEntity = Arrays.asList(entities);
            listEntity.forEach(detail -> {
                TaProcessPageEntity processPageEntity = new TaProcessPageEntity();
                processPageEntity.setProcessId(entity.getProcessId());
                processPageEntity.setProcessKey(entity.getProcessKey());
                processPageEntity.setPageName(detail.getName());
                processPageEntity.setPageCode(detail.getCode());
                this.taProcessPageDao.insertSelective(processPageEntity);
                processPage.append(detail.getName() + ",");
            });
            entity.setProcessPage(processPage.toString().substring(0, processPage.toString().length() - 1));
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getOrgTypeJson())) {
            StringBuffer processOrg = new StringBuffer();
            entities = (TaProcessOrgVo[])JsonPropertyUtil.toObject((String)entity.getOrgTypeJson(), TaProcessOrgVo[].class);
            listEntity = Arrays.asList(entities);
            if (CollectionUtil.listNotEmptyNotSizeZero(listEntity)) {
                listEntity.forEach(detail -> {
                    TaProcessOrgEntity processOrgEntity = new TaProcessOrgEntity();
                    processOrgEntity.setProcessId(entity.getProcessId());
                    processOrgEntity.setProcessKey(entity.getProcessKey());
                    processOrgEntity.setOrgTypeName(detail.getName());
                    processOrgEntity.setOrgTypeCode(detail.getCode());
                    this.taProcessOrgDao.insertSelective(processOrgEntity);
                    processOrg.append(detail.getName() + ",");
                });
                entity.setProcessOrgType(processOrg.toString().substring(0, processOrg.toString().length() - 1));
            }
        }
        this.taProcessOrgPageDao.insertSelective(entity);
        return ajaxJson;
    }

    @Override
    public AjaxJson update(TaProcessOrgPageEntity entity, AjaxJson ajaxJson) {
        List<TaProcessPageVo> listEntity;
        TaProcessPageVo[] entities;
        TaProcessEntity taProcessEntity = null;
        if (StringUtil.isNotEmpty((CharSequence)entity.getProcessId())) {
            taProcessEntity = (TaProcessEntity)this.taProcessDao.selectByPrimaryKey(entity.getProcessId());
        }
        entity.setProcessKey(taProcessEntity.getProcessKey());
        if (StringUtil.isNotEmpty((CharSequence)entity.getPageJson())) {
            Example examplePage = new Example(TaProcessPageEntity.class);
            Example.Criteria criteriaDetail = examplePage.createCriteria();
            criteriaDetail.andEqualTo("processId", (Object)entity.getProcessId());
            this.taProcessPageDao.deleteByExample(examplePage);
            StringBuffer processPage = new StringBuffer();
            entities = (TaProcessPageVo[])JsonPropertyUtil.toObject((String)entity.getPageJson(), TaProcessPageVo[].class);
            listEntity = Arrays.asList(entities);
            listEntity.forEach(detail -> {
                TaProcessPageEntity processPageEntity = new TaProcessPageEntity();
                processPageEntity.setProcessId(entity.getProcessId());
                processPageEntity.setProcessKey(entity.getProcessKey());
                processPageEntity.setPageName(detail.getName());
                processPageEntity.setPageCode(detail.getCode());
                this.taProcessPageDao.insertSelective(processPageEntity);
                processPage.append(detail.getName() + ",");
            });
            entity.setProcessPage(processPage.toString().substring(0, processPage.toString().length() - 1));
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getOrgTypeJson())) {
            Example exampleOrgType = new Example(TaProcessOrgEntity.class);
            Example.Criteria criteriaOrgType = exampleOrgType.createCriteria();
            criteriaOrgType.andEqualTo("processId", (Object)entity.getProcessId());
            this.taProcessOrgDao.deleteByExample(exampleOrgType);
            StringBuffer processOrg = new StringBuffer();
            entities = (TaProcessOrgVo[])JsonPropertyUtil.toObject((String)entity.getOrgTypeJson(), TaProcessOrgVo[].class);
            listEntity = Arrays.asList(entities);
            listEntity.forEach(detail -> {
                TaProcessOrgEntity processOrgEntity = new TaProcessOrgEntity();
                processOrgEntity.setProcessId(entity.getProcessId());
                processOrgEntity.setProcessKey(entity.getProcessKey());
                processOrgEntity.setOrgTypeName(detail.getName());
                processOrgEntity.setOrgTypeCode(detail.getCode());
                this.taProcessOrgDao.insertSelective(processOrgEntity);
                processOrg.append(detail.getName() + ",");
            });
            entity.setProcessOrgType(processOrg.toString().substring(0, processOrg.toString().length() - 1));
        }
        this.taProcessOrgPageDao.updateByPrimaryKeySelective(entity);
        return ajaxJson;
    }

    @Override
    public boolean delete(String id) {
        TaProcessOrgPageEntity entity = (TaProcessOrgPageEntity)this.taProcessOrgPageDao.selectByPrimaryKey(id);
        int i = this.taProcessOrgPageDao.deleteByPrimaryKey(id);
        if (i > 0) {
            Example examplePage = new Example(TaProcessPageEntity.class);
            Example.Criteria criteriaDetail = examplePage.createCriteria();
            criteriaDetail.andEqualTo("processId", (Object)entity.getProcessId());
            this.taProcessPageDao.deleteByExample(examplePage);
            Example exampleOrgType = new Example(TaProcessOrgEntity.class);
            Example.Criteria criteriaOrgType = exampleOrgType.createCriteria();
            criteriaOrgType.andEqualTo("processId", (Object)entity.getProcessId());
            this.taProcessOrgDao.deleteByExample(exampleOrgType);
            return true;
        }
        return false;
    }

    @Override
    public List<String> getBpmKey(String processPage, List<String> processOrgTypes) {
        List<String> bpmKey = new ArrayList<String>();
        if (CollectionUtil.listEmpty(processOrgTypes) || StringUtil.isBlank((CharSequence)processPage)) {
            return bpmKey;
        }
        Example example = new Example(TaProcessPageEntity.class);
        Example.Criteria criteriaPage = example.createCriteria();
        criteriaPage.andEqualTo("pageCode", (Object)processPage);
        List processPageEntities = this.taProcessPageDao.selectByExample(example);
        if (CollectionUtil.listEmpty((List)processPageEntities)) {
            return bpmKey;
        }
        bpmKey = processPageEntities.stream().map(TaProcessPageEntity::getProcessKey).collect(Collectors.toList());
        Example exampleOrg = new Example(TaProcessOrgEntity.class);
        Example.Criteria criteriaOrg = exampleOrg.createCriteria();
        criteriaOrg.andIn("processKey", bpmKey);
        criteriaOrg.andIn("orgTypeCode", processOrgTypes);
        List orgEntities = this.taProcessOrgDao.selectByExample(exampleOrg);
        if (CollectionUtil.listEmpty((List)orgEntities)) {
            return new ArrayList<String>();
        }
        bpmKey = orgEntities.stream().distinct().map(TaProcessOrgEntity::getProcessKey).collect(Collectors.toList());
        return bpmKey;
    }
}

