/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.entity.activiti.ActHiProcinstEntity;
import com.biz.eisp.activiti.runtime.dao.ActHiProcinstDao;
import com.biz.eisp.activiti.runtime.dao.TaAttachmentDao;
import com.biz.eisp.activiti.runtime.entity.TaAttachmentEntity;
import com.biz.eisp.activiti.runtime.service.TaAttachmentService;
import com.biz.eisp.activiti.runtime.transformer.TaAttachmentEntityToTaAttachmentVo;
import com.biz.eisp.activiti.runtime.vo.TaAttachmentVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.DateUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taAttachmentService")
@Transactional
public class TaAttachmentServiceImpl
implements TaAttachmentService {
    @Autowired
    private TaAttachmentDao taAttachmentDao;
    @Autowired
    private ActHiProcinstDao actHiProcinstDao;

    @Override
    public List<TaAttachmentVo> findAttachmentList(String taskId) {
        TaAttachmentEntity record = new TaAttachmentEntity();
        record.setTaskId(taskId);
        List entityList = this.taAttachmentDao.select(record);
        return Lists.transform((List)entityList, (Function)new TaAttachmentEntityToTaAttachmentVo());
    }

    @Override
    public TaAttachmentEntity saveAttachement(String taskId, String processInstanceId, String businessKey, String fileName, String realPath, String urlPath, String extend) {
        int index = fileName.lastIndexOf(".");
        String title = fileName.substring(0, index);
        TaAttachmentEntity attachment = new TaAttachmentEntity();
        attachment.setTaskId(taskId);
        attachment.setProcInstId(processInstanceId);
        attachment.setBusinessKey(businessKey);
        attachment.setAttachmentTitle(title);
        attachment.setUrlPath(urlPath);
        attachment.setExtend(extend);
        attachment.setRealPath(realPath);
        attachment.setCreateDate(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        this.taAttachmentDao.insertSelective(attachment);
        return attachment;
    }

    @Override
    public void deleteAttachment(String fileKey) {
        this.taAttachmentDao.deleteByPrimaryKey(fileKey);
    }

    @Override
    public AjaxJson<byte[]> viewOrDownloadFile(String fileKey) {
        TaAttachmentEntity attachment = (TaAttachmentEntity)this.taAttachmentDao.selectByPrimaryKey(fileKey);
        String fileName = attachment.getAttachmentTitle() + "." + attachment.getExtend();
        String realPath = attachment.getRealPath();
        String extend = attachment.getExtend();
        return null;
    }

    @Override
    public List<TaAttachmentEntity> findAttachmentListByProcinstId(String processInstanceId) {
        ActHiProcinstEntity actHiProcinstEntity = new ActHiProcinstEntity();
        actHiProcinstEntity.setProcInstId(processInstanceId);
        actHiProcinstEntity = (ActHiProcinstEntity)this.actHiProcinstDao.selectOne(actHiProcinstEntity);
        TaAttachmentEntity record = new TaAttachmentEntity();
        record.setBusinessKey(actHiProcinstEntity.getBusinessKey());
        return this.taAttachmentDao.select(record);
    }
}

