/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessNodeDao;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeAuthProEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeProEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeAuthVo;
import com.biz.eisp.activiti.entity.TaRejectReadEntity;
import com.biz.eisp.activiti.entity.activiti.ActHiProcinstEntity;
import com.biz.eisp.activiti.entity.activiti.ActReProcdefEntity;
import com.biz.eisp.activiti.entity.activiti.ActRuTaskEntity;
import com.biz.eisp.activiti.runtime.dao.ActHiProcinstDao;
import com.biz.eisp.activiti.runtime.dao.ActReProcdefDao;
import com.biz.eisp.activiti.runtime.dao.ActRuTaskDao;
import com.biz.eisp.activiti.runtime.dao.TaAttachmentDao;
import com.biz.eisp.activiti.runtime.dao.TaBaseBusinessObjDao;
import com.biz.eisp.activiti.runtime.dao.TaCommunicateContentDao;
import com.biz.eisp.activiti.runtime.dao.TaCommunicateDao;
import com.biz.eisp.activiti.runtime.dao.TaJumpNodeDao;
import com.biz.eisp.activiti.runtime.dao.TaKeyIndicatorsConfigDao;
import com.biz.eisp.activiti.runtime.dao.TaProcessApprovalLogDao;
import com.biz.eisp.activiti.runtime.dao.TaRejectReadDao;
import com.biz.eisp.activiti.runtime.dao.TaRuntimeStatusDao;
import com.biz.eisp.activiti.runtime.dao.TaTaskDao;
import com.biz.eisp.activiti.runtime.entity.TaAttachmentEntity;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjEntity;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjExtend;
import com.biz.eisp.activiti.runtime.entity.TaCommunicateContentEntity;
import com.biz.eisp.activiti.runtime.entity.TaJumpNodeEntity;
import com.biz.eisp.activiti.runtime.entity.TaKeyIndicatorsConfigEntity;
import com.biz.eisp.activiti.runtime.entity.TaProcessApprovalLogEntity;
import com.biz.eisp.activiti.runtime.entity.TaRuntimeStatusEntity;
import com.biz.eisp.activiti.runtime.service.TaApprovalLogExtendService;
import com.biz.eisp.activiti.runtime.service.TaAttachmentService;
import com.biz.eisp.activiti.runtime.service.TaBaseBusinessObjExtendService;
import com.biz.eisp.activiti.runtime.service.TaBaseBusinessObjService;
import com.biz.eisp.activiti.runtime.service.TaKeyIndicators;
import com.biz.eisp.activiti.runtime.service.TaProcessApprovalLogService;
import com.biz.eisp.activiti.runtime.service.TaRejectRecordService;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.transformer.HistoricTaskInstanceToHistoryTaskVo;
import com.biz.eisp.activiti.runtime.vo.BusinessFormVo;
import com.biz.eisp.activiti.runtime.vo.CommentVo;
import com.biz.eisp.activiti.runtime.vo.HistoryTaskVo;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.activiti.runtime.vo.OperationVo;
import com.biz.eisp.activiti.runtime.vo.TaAttachmentVo;
import com.biz.eisp.activiti.runtime.vo.TaKeyIndicatorsVo;
import com.biz.eisp.activiti.runtime.vo.TaProcessApprovalLogVo;
import com.biz.eisp.activiti.util.CommentUtil;
import com.biz.eisp.api.feign.TmOrgFeign;
import com.biz.eisp.api.feign.TmPositionFeign;
import com.biz.eisp.api.feign.TmUserFeign;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.config.SpringApplicationContextUtil;
import com.biz.eisp.org.TmOrgVo;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.user.TmUserVo;
import com.biz.eisp.util.ResourceService;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="taTaskService")
@Transactional
public class TaTaskServiceImpl
implements TaTaskService {
    @Autowired
    private TaApprovalLogExtendService taApprovalLogExtendService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private TaProcessNodeService taProcessNodeService;
    @Autowired
    private TaBaseBusinessObjService taBaseBusinessObjService;
    @Autowired
    private TaTaskDao taTaskDao;
    @Autowired
    private TaRejectRecordService taRejectRecordService;
    @Autowired
    private TaAttachmentService taAttachmentService;
    @Autowired
    private ResourceService resource;
    @Autowired
    private TaProcessApprovalLogDao taProcessApprovalLogDao;
    @Autowired
    private TaJumpNodeDao taJumpNodeDao;
    @Autowired
    private TaCommunicateContentDao taCommunicateContentDao;
    @Autowired
    private TaCommunicateDao taCommunicateDao;
    @Autowired
    private TaProcessNodeDao taProcessNodeDao;
    @Autowired
    private ActRuTaskDao actRuTaskDao;
    @Autowired
    private TaRejectReadDao taRejectReadDao;
    @Autowired
    private TaAttachmentDao taAttachmentDao;
    @Autowired
    private TaRuntimeStatusDao taRuntimeStatusDao;
    @Autowired
    private TaBaseBusinessObjDao taBaseBusinessObjDao;
    @Autowired
    private ActHiProcinstDao actHiProcinstDao;
    @Autowired
    private ActReProcdefDao actReProcdefDao;
    @Autowired
    private TaKeyIndicatorsConfigDao taKeyIndicatorsConfigDao;
    @Autowired
    private TmUserFeign tmUserFeign;
    @Autowired
    private TmOrgFeign tmOrgFeign;
    @Autowired
    private TmPositionFeign tmPositionFeign;
    @Autowired
    private TaProcessApprovalLogService taProcessApprovalLogService;
    @Autowired
    private TaBaseBusinessObjExtendService taBaseBusinessObjExtendService;

    @Override
    public AjaxJson<MyTaskVo> findMyTaskList(MyTaskVo myTaskVo, Page page) {
        PageInfo infoList = PageAutoHelperUtil.generatePage(() -> this.taTaskDao.findMyTaskList(myTaskVo), (Page)page);
        AjaxJson result = new AjaxJson();
        result.setPageInfo(infoList);
        return result;
    }

    @Override
    public String getBusinessObjIdByTask(Task task) {
        String businessKey = "";
        HistoricProcessInstance hiproins = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(this.getProcessInstanceId(task.getId())).singleResult();
        if (hiproins != null) {
            if (hiproins.getSuperProcessInstanceId() != null && hiproins.getBusinessKey() == null) {
                hiproins = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(hiproins.getSuperProcessInstanceId()).singleResult();
                businessKey = hiproins.getBusinessKey();
            } else {
                businessKey = hiproins.getBusinessKey();
            }
        }
        return businessKey;
    }

    public String getBusinessObjIdByTaskId(String taskId) {
        String businessKey = "";
        HistoricProcessInstance hiproins = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(this.getProcessInstanceId(taskId)).singleResult();
        if (hiproins != null) {
            if (hiproins.getSuperProcessInstanceId() != null && hiproins.getBusinessKey() == null) {
                hiproins = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(hiproins.getSuperProcessInstanceId()).singleResult();
                businessKey = hiproins.getBusinessKey();
            } else {
                businessKey = hiproins.getBusinessKey();
            }
        }
        return businessKey;
    }

    public ProcessDefinition getProcessDefinition(String processDefinitionId) {
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
    }

    @Override
    public Task getTask(String taskId) {
        return (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
    }

    public String getBusinessObjIdByTask(String taskId) {
        Task task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        return this.getBusinessObjIdByTask(task);
    }

    public List<String> highLight(String processInstanceId) {
        ArrayList<String> highLihth = new ArrayList<String>();
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).list();
        for (Execution execution : executions) {
            ExecutionEntity entity = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(execution.getId()).singleResult();
            highLihth.add(entity.getActivityId());
        }
        return highLihth;
    }

    @Override
    public void saveClaim(MyTaskVo myTaskVo) {
        this.taskService.claim(myTaskVo.getTaskId(), this.resource.getUserVo().getUsername());
    }

    @Override
    public void saveComplete(MyTaskVo myTaskVo) {
        this.taskService.complete(myTaskVo.getTaskId());
    }

    @Override
    public void saveComplete(OperationVo operationVo, UserRedis userRedis) {
        TaJumpNodeEntity jumpNodeEntity;
        String processInstanceId = operationVo.getProcessInstanceId();
        Task task = this.getTask(operationVo.getTaskId());
        if (task == null) {
            throw new BusinessException("\u4efb\u52a1\u5df2\u7ecf\u88ab\u5176\u4ed6\u4eba\u5ba1\u6279!");
        }
        String detailComment = CommentUtil.buildPassComment(task.getName(), userRedis.getRealname(), operationVo.getComment());
        this.taskService.addComment(operationVo.getTaskId(), processInstanceId, detailComment);
        this.validForceReply(processInstanceId);
        TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
        log.setCreateDate(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        log.setAccount(userRedis.getUsername());
        log.setContent(operationVo.getComment());
        log.setName(userRedis.getRealname());
        log.setProcessInstId(processInstanceId);
        log.setPositionCode(userRedis.getPosCode());
        log.setPositionName(userRedis.getPosName());
        try {
            log.setTaskDefKey(this.findTaskById(operationVo.getTaskId()).getTaskDefinitionKey());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.setType(Integer.valueOf(1));
        this.taProcessApprovalLogDao.insertSelective(log);
        this.taskService.setOwner(operationVo.getTaskId(), userRedis.getPosCode());
        HashMap<String, Object> variable = new HashMap<String, Object>();
        variable.put("approveOpt", "PASS");
        if (this.isSignNode(log.getTaskDefKey()) && this.taskService.getVariable(operationVo.getTaskId(), "persons" + log.getTaskDefKey()) == null) {
            this.taskService.setVariable(operationVo.getTaskId(), "persons" + log.getTaskDefKey(), this.taskService.getVariable(operationVo.getTaskId(), "persons"));
        }
        if ((jumpNodeEntity = this.findTaJumpNodeEntity(log.getTaskDefKey(), processInstanceId)) != null) {
            this.taskService.setVariable(operationVo.getTaskId(), "backTaskIds", this.taskService.getVariable(operationVo.getTaskId(), "backTaskIds_returnThisNode"));
            this.goProcessTaskNode(operationVo.getTaskId(), jumpNodeEntity.getSrcTaskKey(), variable);
            this.taJumpNodeDao.delete(jumpNodeEntity);
        } else {
            this.taskService.complete(operationVo.getTaskId(), variable);
        }
        if (this.isLastTask(processInstanceId)) {
            this.taBaseBusinessObjService.updateBaseBusinessObjRuntimeStatusByProcessInstanceId(processInstanceId, WorkFlowGlobals.RUNTIME_STATUS_COMPLETED);
        } else {
            this.jumUser(processInstanceId, operationVo);
        }
    }

    private void jumUser(String processInstanceId, OperationVo operationVo) {
        Map<String, String> map = this.getNowPosMap(processInstanceId);
        if (map != null && !map.isEmpty()) {
            Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult();
            List<HistoricTaskInstance> approvedList = this.getHiProcinstUser(processInstanceId);
            if (CollectionUtil.listNotEmptyNotSizeZero(approvedList)) {
                for (HistoricTaskInstance item : approvedList) {
                    if (!StringUtils.isNotBlank((CharSequence)item.getOwner()) || !map.containsKey(item.getOwner())) continue;
                    UserRedis userRedis = UserUtils.getUser();
                    operationVo.setTaskId(task.getId());
                    operationVo.setComment("\u91cd\u590d\u5ba1\u6279\u8df3\u8fc7:" + userRedis.getRealname());
                    this.saveComplete(operationVo, userRedis);
                    break;
                }
            }
        }
    }

    public List<HistoricTaskInstance> getHiProcinstUser(String processInstanceId) {
        ProcessEngine engine = ProcessEngines.getDefaultProcessEngine();
        HistoryService historyService = engine.getHistoryService();
        List list = historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId).list();
        return list;
    }

    private void validForceReply(String processInstanceId) {
        List<TaCommunicateContentEntity> entityList = this.taCommunicateContentDao.findContentByFlagAndProcessInstance("Y", processInstanceId);
        if (CollectionUtil.listNotEmptyNotSizeZero(entityList)) {
            String errMsg = entityList.get(0).getCirculationName() + ",\u672a\u7b54\u590d\u6c9f\u901a\u3002";
            throw new BusinessException(errMsg);
        }
    }

    private boolean isSignNode(String taskDefinitionKey) {
        TaProcessNodeEntity nodeEntity = new TaProcessNodeEntity();
        nodeEntity.setProcessNodeCode(taskDefinitionKey);
        nodeEntity = (TaProcessNodeEntity)this.taProcessNodeDao.selectOne(nodeEntity);
        return nodeEntity != null && nodeEntity.getSign() != null && nodeEntity.getSign() == 1;
    }

    @Override
    public boolean isLastTask(String processInstanceId) {
        List list = this.historyService.createHistoricProcessInstanceQuery().finished().processInstanceId(processInstanceId).list();
        return list != null && list.size() == 1;
    }

    @Override
    public boolean hasRejectNodes(String taskId, String processInstanceId) {
        ArrayList backTaskIdlist = new ArrayList();
        List historicTaskInstanceList = this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId).taskDeleteReason("completed").list();
        HashMap mapTemp = new HashMap();
        historicTaskInstanceList.forEach(item -> {
            if (!mapTemp.containsKey(item.getTaskDefinitionKey())) {
                mapTemp.put(item.getTaskDefinitionKey(), item.getTaskDefinitionKey());
            } else {
                HashMap<String, String> map2 = new HashMap<String, String>();
                map2.put("id", item.getTaskDefinitionKey());
                map2.put("name", item.getName());
                backTaskIdlist.add(map2);
            }
        });
        return CollectionUtil.listNotEmptyNotSizeZero(backTaskIdlist);
    }

    private List<Map<String, String>> cloneBackTaskIdlist(List<Map<String, String>> backTaskIdlist) {
        ArrayList<Map<String, String>> cloneBackTaskIdlist = new ArrayList<Map<String, String>>();
        if (CollectionUtil.listNotEmptyNotSizeZero(backTaskIdlist)) {
            for (Map<String, String> map : backTaskIdlist) {
                HashMap newMap = new HashMap();
                BeanUtils.copyProperties(map, newMap);
                cloneBackTaskIdlist.add(newMap);
            }
        }
        return cloneBackTaskIdlist;
    }

    @Override
    public void saveReject(OperationVo operationVo) {
        ArrayList backTaskIdlist = new ArrayList();
        List historicTaskInstanceList = this.historyService.createHistoricTaskInstanceQuery().processInstanceId(operationVo.getProcessInstanceId()).taskDeleteReason("completed").list();
        HashMap mapTemp = new HashMap();
        historicTaskInstanceList.forEach(item -> {
            if (!mapTemp.containsKey(item.getTaskDefinitionKey())) {
                mapTemp.put(item.getTaskDefinitionKey(), item.getTaskDefinitionKey());
            } else {
                HashMap<String, String> map2 = new HashMap<String, String>();
                map2.put("id", item.getTaskDefinitionKey());
                map2.put("name", item.getName());
                backTaskIdlist.add(map2);
            }
        });
        Task task = this.getTask(operationVo.getTaskId());
        if (backTaskIdlist == null || backTaskIdlist.size() == 0) {
            throw new BusinessException("\u524d\u4efb\u52a1\u8282\u70b9\uff0c\u6ca1\u6709\u914d\u7f6e\u9a73\u56de\uff0c\u4e0d\u80fd\u8fdb\u884c\u9a73\u56de\u4e0a\u4e00\u7ea7\u64cd\u4f5c");
        }
        String detailComment = CommentUtil.buildRejectPreComment(task.getName(), this.resource.getCreateName(), operationVo.getComment());
        this.taskService.addComment(operationVo.getTaskId(), operationVo.getProcessInstanceId(), detailComment);
        TmUserVo user = this.resource.getUserVo();
        TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
        log.setCreateDate(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        log.setAccount(user.getUsername());
        log.setContent(operationVo.getComment());
        log.setName(user.getFullname());
        log.setProcessInstId(operationVo.getProcessInstanceId());
        log.setPositionCode(this.resource.getCurrPosition().getPositionCode());
        log.setPositionName(this.resource.getCurrPosition().getPositionName());
        try {
            log.setTaskDefKey(this.findTaskById(operationVo.getTaskId()).getTaskDefinitionKey());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.setType(Integer.valueOf(2));
        this.taProcessApprovalLogDao.insertSelective(log);
        if (this.isSignNode(operationVo.getTaskDefKey())) {
            this.taskService.setVariable(operationVo.getTaskId(), "persons", this.taskService.getVariable(operationVo.getTaskId(), "persons" + operationVo.getTaskDefKey()));
        }
        this.taRejectRecordService.saveTaRejectRecord(operationVo.getProcessInstanceId());
        this.taskService.setOwner(operationVo.getTaskId(), this.resource.getCurrPosition().getPositionCode());
        String targetTaskKey = operationVo.getTaskDefKey();
        int count = 0;
        for (int i = 0; i < backTaskIdlist.size(); ++i) {
            Map node = (Map)backTaskIdlist.get(i);
            if (!((String)node.get("id")).equals(targetTaskKey)) continue;
            count = i;
            break;
        }
        ArrayList _backTaskIdlist = new ArrayList();
        for (int index = count; index < backTaskIdlist.size(); ++index) {
            _backTaskIdlist.add(backTaskIdlist.get(index));
        }
        backTaskIdlist.removeAll(_backTaskIdlist);
        if (StringUtils.isNotBlank((CharSequence)targetTaskKey) && StringUtil.isNotBlank((CharSequence)operationVo.getReturnThisNode()) && "Y".equals(operationVo.getReturnThisNode())) {
            this.taskService.setVariable(operationVo.getTaskId(), "backTaskIds_returnThisNode", this.taskService.getVariable(operationVo.getTaskId(), "backTaskIds"));
            this.saveTaJumpNodeEntity(log.getTaskDefKey(), targetTaskKey, operationVo.getProcessInstanceId());
        }
        this.taskService.setVariable(operationVo.getTaskId(), "backTaskIds", backTaskIdlist);
        HashMap<String, Object> variable = new HashMap<String, Object>();
        variable.put("approveOpt", "REJECT_PRE");
        this.goProcessTaskNode(operationVo.getTaskId(), targetTaskKey, variable);
    }

    private void saveTaJumpNodeEntity(String srcTaskKey, String targetTaskKey, String processInstanceId) {
        TaJumpNodeEntity entity = new TaJumpNodeEntity();
        entity.setProcessInstanceId(processInstanceId);
        entity.setSrcTaskKey(srcTaskKey);
        entity.setTargetTaskKey(targetTaskKey);
        this.taJumpNodeDao.insertSelective(entity);
    }

    private TaJumpNodeEntity findTaJumpNodeEntity(String targetTaskKey, String processInstanceId) {
        TaJumpNodeEntity record = new TaJumpNodeEntity();
        record.setTargetTaskKey(targetTaskKey);
        record.setProcessInstanceId(processInstanceId);
        List list = this.taJumpNodeDao.select(record);
        boolean isLastSignNode = this.isLastSignNode(targetTaskKey, processInstanceId);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list) && isLastSignNode) {
            return (TaJumpNodeEntity)list.get(0);
        }
        return null;
    }

    private boolean isLastSignNode(String targetTaskKey, String processInstanceId) {
        boolean isLastSignNode = true;
        if (this.isSignNode(targetTaskKey)) {
            ActRuTaskEntity record = new ActRuTaskEntity();
            record.setProcInstId(processInstanceId);
            int count = this.actRuTaskDao.selectCount(record);
            if (count > 1) {
                isLastSignNode = false;
            }
        }
        return isLastSignNode;
    }

    @Override
    public void saveRejectToApply(OperationVo operationVo) {
        Task task = this.getTask(operationVo.getTaskId());
        String detailComment = CommentUtil.buildRejectApplyComment(task.getName(), this.resource.getCreateName(), operationVo.getComment());
        this.taskService.addComment(operationVo.getTaskId(), operationVo.getProcessInstanceId(), detailComment);
        TmUserVo user = this.resource.getUserVo();
        TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
        log.setCreateDate(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        log.setAccount(user.getUsername());
        log.setContent(operationVo.getComment());
        log.setName(user.getFullname());
        log.setProcessInstId(operationVo.getProcessInstanceId());
        log.setPositionCode(this.resource.getCurrPosition().getPositionCode());
        log.setPositionName(this.resource.getCurrPosition().getPositionName());
        try {
            log.setTaskDefKey(this.findTaskById(operationVo.getTaskId()).getTaskDefinitionKey());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.setType(Integer.valueOf(2));
        this.taProcessApprovalLogDao.insertSelective(log);
        this.taskService.setOwner(operationVo.getTaskId(), this.resource.getCurrPosition().getPositionCode());
        this.taRejectRecordService.saveTaRejectRecord(operationVo.getProcessInstanceId());
        String USER_SELECT_TASK_NODE = "end";
        HashMap<String, Object> variable = new HashMap<String, Object>();
        variable.put("approveOpt", "ABORT");
        this.goProcessTaskNode(operationVo.getTaskId(), USER_SELECT_TASK_NODE, variable);
        this.taBaseBusinessObjService.updateBaseBusinessObjRuntimeStatusByProcessInstanceId(operationVo.getProcessInstanceId(), WorkFlowGlobals.RUNTIME_STATUS_REJECT);
    }

    @Override
    public void saveRejectToApply(OperationVo operationVo, String positionId) {
        Task task = this.getTask(operationVo.getTaskId());
        TmUserVo userVo = (TmUserVo)this.tmUserFeign.findPositionUser(positionId).getObj();
        String createName = StringUtil.isNotEmpty((Object)userVo) ? userVo.getFullname() + "(" + userVo.getPosName() + ")" : "";
        String detailComment = CommentUtil.buildRejectApplyComment(task.getName(), createName, operationVo.getComment());
        this.taskService.addComment(operationVo.getTaskId(), operationVo.getProcessInstanceId(), detailComment);
        TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
        log.setCreateDate(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        log.setAccount(userVo.getUsername());
        log.setContent(operationVo.getComment());
        log.setName(userVo.getFullname());
        log.setProcessInstId(operationVo.getProcessInstanceId());
        log.setPositionCode(this.resource.getCurrPosition().getPositionCode());
        log.setPositionName(this.resource.getCurrPosition().getPositionName());
        try {
            log.setTaskDefKey(this.findTaskById(operationVo.getTaskId()).getTaskDefinitionKey());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.setType(Integer.valueOf(2));
        this.taProcessApprovalLogDao.insertSelective(log);
        this.taskService.setOwner(operationVo.getTaskId(), userVo.getPosCode());
        this.taRejectRecordService.saveTaRejectRecord(operationVo.getProcessInstanceId(), positionId);
        String USER_SELECT_TASK_NODE = "end";
        HashMap<String, Object> variable = new HashMap<String, Object>();
        variable.put("approveOpt", "ABORT");
        this.goProcessTaskNode(operationVo.getTaskId(), USER_SELECT_TASK_NODE, variable);
        this.taBaseBusinessObjService.updateBaseBusinessObjRuntimeStatusByProcessInstanceId(operationVo.getProcessInstanceId(), WorkFlowGlobals.RUNTIME_STATUS_REJECT);
    }

    @Override
    public void saveRead(OperationVo operationVo) {
        TaRejectReadEntity entity = new TaRejectReadEntity();
        entity.setProcessInstanceId(operationVo.getProcessInstanceId());
        this.taRejectReadDao.insertSelective(entity);
    }

    @Override
    public AjaxJson<HistoryTaskVo> findMyHistoryTaskList(HistoryTaskVo historyTaskVo, Page page) {
        PageInfo infoList = PageAutoHelperUtil.generatePage(() -> this.taTaskDao.findMyHistoryTaskList(historyTaskVo), (Page)page);
        this.calSpendTimes(infoList.getList());
        AjaxJson result = new AjaxJson();
        result.setPageInfo(infoList);
        return result;
    }

    private void calSpendTimes(List<HistoryTaskVo> historyTaskVoList) {
        if (historyTaskVoList != null) {
            for (HistoryTaskVo vo : historyTaskVoList) {
                vo.setSpendTimes(DateUtils.calSpendTimes((String)vo.getStartTime(), (String)vo.getEndTime()));
            }
        }
    }

    @Override
    public String getProcessInstanceId(String taskId) {
        Task task = this.getTask(taskId);
        if (task == null) {
            List hiTaskList = this.historyService.createHistoricTaskInstanceQuery().taskId(taskId).list();
            if (hiTaskList != null && hiTaskList.size() > 0) {
                return ((HistoricTaskInstance)hiTaskList.get(0)).getProcessInstanceId();
            }
            throw new BusinessException("\u4efb\u52a1ID\uff08taskId\uff09:" + taskId + "\u4e0d\u5b58\u5728");
        }
        return task.getProcessInstanceId();
    }

    @Override
    public AjaxJson<HistoryTaskVo> findProcessInstanceTaskHistoryList(HistoryTaskVo historyTaskVo) {
        String processInstanceId = historyTaskVo.getProcessInstanceId();
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            throw new BusinessException("\u6d41\u7a0b\u5b9e\u4f8bID\uff08processInstanceId\uff09\u4e3a\u7a7a");
        }
        List historicTaskInstanceList = this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId).list();
        List voList = Lists.transform((List)historicTaskInstanceList, (Function)new HistoricTaskInstanceToHistoryTaskVo());
        AjaxJson result = new AjaxJson();
        result.setList(voList);
        return result;
    }

    @Override
    public BusinessFormVo getTaskBusinessForm(String taskId) {
        return this.taTaskDao.getBusinessForm(taskId);
    }

    @Override
    public List<CommentVo> findActHiCommentEntity(String processInstanceId) {
        List<CommentVo> voList = this.taTaskDao.findProcessInstanceCommentList(processInstanceId, null);
        for (CommentVo vo : voList) {
            List<TaAttachmentVo> list = this.taAttachmentService.findAttachmentList(vo.getTaskId());
            vo.setFullMsg(this.getFullMsg(vo.getBlobMsg()));
            vo.setAttachmentList(list);
        }
        return voList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFullMsg(Blob blob) {
        String result = "";
        InputStream in = null;
        BufferedReader br = null;
        try {
            in = blob.getBinaryStream();
            br = new BufferedReader(new InputStreamReader(in));
            String str = "";
            while ((str = br.readLine()) != null) {
                result = result + str;
            }
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
                in.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public List<CommentVo> findActHiCommentByBusinessKey(String businessKey) {
        List<CommentVo> result = this.taTaskDao.findProcessInstanceCommentByBusinessKey(businessKey);
        for (CommentVo vo : result) {
            List<TaAttachmentVo> list = this.taAttachmentService.findAttachmentList(vo.getTaskId());
            vo.setAttachmentList(list);
        }
        return result;
    }

    @Override
    public List<TaAttachmentEntity> findAttachmentList(String taskId) {
        TaAttachmentEntity record = new TaAttachmentEntity();
        record.setTaskId(taskId);
        return this.taAttachmentDao.select(record);
    }

    @Override
    public void reassign(MyTaskVo myTaskVo, String reassignComment, String reassignPositionCode) {
        if (StringUtil.isEmpty((String)reassignPositionCode)) {
            throw new BusinessException("\u804c\u4f4d\u4e0d\u80fd\u7a7a");
        }
        UserRedis userRedis = UserUtils.getUser();
        String taskId = myTaskVo.getTaskId();
        Task task = this.getTask(taskId);
        TmPositionVo positionVo = this.resource.getCurrPosition();
        this.taskService.addComment(taskId, task.getProcessInstanceId(), CommentUtil.buildReassignComment(task.getName(), this.resource.getCreateName(), reassignComment));
        this.taskService.setVariableLocal(taskId, "approveOpt", (Object)"REASSIGN");
        this.taskService.setOwner(taskId, positionVo.getPositionCode());
        this.taskService.setAssignee(taskId, reassignPositionCode);
        TaProcessApprovalLogEntity entity = new TaProcessApprovalLogEntity();
        entity.setAccount(userRedis.getUsername());
        entity.setName(userRedis.getRealname());
        entity.setType(Integer.valueOf(5));
        entity.setContent(reassignComment + "(\u8f6c\u529e\u5230:" + reassignPositionCode + ")");
        entity.setProcessInstId(task.getProcessInstanceId());
        entity.setPositionCode(userRedis.getPosCode());
        entity.setPositionCode(userRedis.getPosName());
        this.taProcessApprovalLogService.saveLog(entity);
    }

    @Override
    public void complete(String taskId, Map<String, Object> map) {
        try {
            String businessObjId = this.getBusinessObjIdByTask(taskId);
            String USER_SELECT_TASK_NODE = (String)map.get(WorkFlowGlobals.USER_SELECT_TASK_NODE);
            this.goProcessTaskNode(taskId, USER_SELECT_TASK_NODE, map);
            List list = this.historyService.createHistoricProcessInstanceQuery().finished().processInstanceBusinessKey(businessObjId).list();
            if (list != null && list.size() == 1) {
                TaRuntimeStatusEntity r = this.taRuntimeStatusDao.getOneByCode("completed");
                TaBaseBusinessObjEntity obj = (TaBaseBusinessObjEntity)this.taBaseBusinessObjDao.selectByPrimaryKey(businessObjId);
                obj.setRuntimeStatusId(r.getId());
                this.taBaseBusinessObjDao.updateByPrimaryKeySelective(obj);
            }
        }
        catch (ActivitiException e) {
            if (e.getMessage().indexOf("no processes deployed with key") != -1) {
                e.printStackTrace();
            } else {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void goProcessTaskNode(String taskId, String activityId, Map<String, Object> variables) {
        List<Task> taskList = this.findTaskListByKey(this.findProcessInstanceByTaskId(taskId).getId(), this.findTaskById(taskId).getTaskDefinitionKey());
        for (Task task : taskList) {
            this.commitProcess(task.getId(), variables, activityId);
        }
    }

    private void commitProcess(String taskId, Map<String, Object> variables, String taskDefinitionKey) {
        if (StringUtil.isEmpty((String)taskDefinitionKey)) {
            this.taskService.complete(taskId, variables);
        } else {
            this.turnTransition(taskId, taskDefinitionKey, variables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void turnTransition(String taskId, String taskDefinitionKey, Map<String, Object> variables) {
        ActivityImpl currActivity = this.findActivitiImpl(taskId, null);
        List<PvmTransition> oriPvmTransitionList = this.clearTransition(currActivity);
        TransitionImpl newTransition = currActivity.createOutgoingTransition();
        ActivityImpl pointActivity = this.findActivitiImpl(taskId, taskDefinitionKey);
        newTransition.setDestination(pointActivity);
        try {
            this.taskService.complete(taskId, variables);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            pointActivity.getIncomingTransitions().remove(newTransition);
            this.restoreTransition(currActivity, oriPvmTransitionList);
        }
    }

    private List<PvmTransition> clearTransition(ActivityImpl activityImpl) {
        ArrayList<PvmTransition> oriPvmTransitionList = new ArrayList<PvmTransition>();
        List pvmTransitionList = activityImpl.getOutgoingTransitions();
        for (PvmTransition pvmTransition : pvmTransitionList) {
            oriPvmTransitionList.add(pvmTransition);
        }
        pvmTransitionList.clear();
        return oriPvmTransitionList;
    }

    private void restoreTransition(ActivityImpl activityImpl, List<PvmTransition> oriPvmTransitionList) {
        List pvmTransitionList = activityImpl.getOutgoingTransitions();
        pvmTransitionList.clear();
        for (PvmTransition pvmTransition : oriPvmTransitionList) {
            pvmTransitionList.add(pvmTransition);
        }
    }

    private ProcessDefinitionEntity findProcessDefinitionEntityByTaskId(String taskId) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(this.findTaskById(taskId).getProcessDefinitionId());
        if (processDefinition == null) {
            throw new BusinessException("\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230!");
        }
        return processDefinition;
    }

    private ActivityImpl findActivitiImpl(String taskId, String activityId) {
        ProcessDefinitionEntity processDefinition = this.findProcessDefinitionEntityByTaskId(taskId);
        if (StringUtils.isEmpty((CharSequence)activityId)) {
            activityId = this.findTaskById(taskId).getTaskDefinitionKey();
        }
        if (activityId.toUpperCase().equals("END")) {
            for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                List pvmTransitionList = activityImpl.getOutgoingTransitions();
                if (!pvmTransitionList.isEmpty()) continue;
                return activityImpl;
            }
        }
        ActivityImpl activityImpl = processDefinition.findActivity(activityId);
        return activityImpl;
    }

    private List<Task> findTaskListByKey(String processInstanceId, String key) {
        return this.taskService.createTaskQuery().processInstanceId(processInstanceId).taskDefinitionKey(key).list();
    }

    private ProcessInstance findProcessInstanceByTaskId(String taskId) {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(this.findTaskById(taskId).getProcessInstanceId()).singleResult();
        if (processInstance == null) {
            throw new BusinessException("\u6d41\u7a0b\u5b9e\u4f8b\u672a\u627e\u5230!");
        }
        return processInstance;
    }

    private TaskEntity findTaskById(String taskId) {
        TaskEntity task = (TaskEntity)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        if (task == null) {
            throw new BusinessException("\u4efb\u52a1\u5b9e\u4f8b\u672a\u627e\u5230!");
        }
        return task;
    }

    @Override
    public MyTaskVo findProcessBasicInfoByProcinstId(String processInstanceId) {
        TmUserVo userVo;
        MyTaskVo taskVo = this.taTaskDao.findProcessBasicInfoByProcinstId(processInstanceId);
        String posId = taskVo.getAssignee();
        TmOrgVo orgEntity = (TmOrgVo)this.tmOrgFeign.getOrgByPos(posId, null).getObj();
        if (orgEntity != null) {
            taskVo.setOrgName(orgEntity.getOrgName());
        }
        if ((userVo = (TmUserVo)this.tmUserFeign.findPositionUser(posId).getObj()) != null) {
            taskVo.setCreateUserName(userVo.getFullname());
        }
        Example example = new Example(TaBaseBusinessObjExtend.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("processInstanceId", (Object)processInstanceId);
        List list = this.taBaseBusinessObjExtendService.selectExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            taskVo.setProcessTitle(((TaBaseBusinessObjExtend)list.get(0)).getProcessTitle());
            taskVo.setProcessDetail(((TaBaseBusinessObjExtend)list.get(0)).getProcessDetail());
        }
        return taskVo;
    }

    @Override
    public AjaxJson findKeyIndicators(MyTaskVo myTaskVo) {
        AjaxJson result = new AjaxJson();
        ActHiProcinstEntity actHiProcinstEntity = new ActHiProcinstEntity();
        actHiProcinstEntity.setProcInstId(myTaskVo.getProcessInstanceId());
        actHiProcinstEntity = (ActHiProcinstEntity)this.actHiProcinstDao.selectOne(actHiProcinstEntity);
        ActReProcdefEntity actReProcdefEntity = (ActReProcdefEntity)this.actReProcdefDao.selectByPrimaryKey(actHiProcinstEntity.getProcDefId());
        String processKey = actReProcdefEntity.getKey();
        String businessKey = actHiProcinstEntity.getBusinessKey();
        Object tki = new TaKeyIndicatorsConfigEntity();
        tki.setProcessKey(processKey);
        Example example = new Example(TaKeyIndicatorsConfigEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("processKey", (Object)processKey);
        List tkis = this.taKeyIndicatorsConfigDao.selectByExample(example);
        tki = CollectionUtil.listNotEmptyNotSizeZero((List)tkis) ? (TaKeyIndicatorsConfigEntity)tkis.get(0) : null;
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        if (tki == null) {
            attributes.put("noKey", Boolean.valueOf(true));
        } else {
            attributes.put("noKey", Boolean.valueOf(false));
            String[] title = tki.getTitle().split(",");
            ArrayList<String> head = new ArrayList<String>(Arrays.asList(title));
            attributes.put("head", head);
            TaKeyIndicators service = (TaKeyIndicators)SpringApplicationContextUtil.getApplicationContext().getBean(tki.getServiceName());
            List<Map<String, Object>> data = service.findKeyIndicators(businessKey);
            ArrayList returnList = new ArrayList();
            String[] field = tki.getField().split(",");
            for (Map<String, Object> map : data) {
                ArrayList<TaKeyIndicatorsVo> middleList = new ArrayList<TaKeyIndicatorsVo>();
                for (String key : field) {
                    TaKeyIndicatorsVo value = new TaKeyIndicatorsVo();
                    value.setValue(String.valueOf(map.get(key)));
                    middleList.add(value);
                }
                returnList.add(middleList);
            }
            attributes.put("returnList", returnList);
        }
        result.setAttributes(attributes);
        return result;
    }

    @Override
    public AjaxJson<Map<String, String>> findRejectNode(String taskId, String processInstanceId) {
        List backTaskIdlist = (List)this.taskService.getVariable(taskId, "backTaskIds");
        AjaxJson result = new AjaxJson();
        result.setList(backTaskIdlist);
        return result;
    }

    public List<TaProcessApprovalLogVo> findApprovalLogs2(MyTaskVo myTaskVo) {
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(myTaskVo.getProcessInstanceId()).singleResult();
        List<TaProcessApprovalLogVo> approvedList = this.taTaskDao.findLog(myTaskVo.getProcessInstanceId());
        List<TaProcessApprovalLogVo> runtimeApprovalList = this.findRuntimeApprovalList(processInstance);
        List<TaProcessApprovalLogVo> pendingApproveList = this.findPendingApprovalList(processInstance, runtimeApprovalList);
        ArrayList<TaProcessApprovalLogVo> resultList = new ArrayList<TaProcessApprovalLogVo>();
        if (CollectionUtil.listNotEmptyNotSizeZero(approvedList)) {
            resultList.addAll(approvedList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(runtimeApprovalList)) {
            resultList.addAll(runtimeApprovalList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(pendingApproveList)) {
            resultList.addAll(pendingApproveList);
            this.setApprovalLogType(pendingApproveList, processInstance);
        }
        return resultList;
    }

    private void setApprovalLogType(List<TaProcessApprovalLogVo> resultList, HistoricProcessInstance processInstance) {
        BpmnModel model = this.repositoryService.getBpmnModel(processInstance.getProcessDefinitionId());
        if (model != null) {
            Collection flowElements = model.getMainProcess().getFlowElements();
            HashMap<String, String> typeMap = new HashMap<String, String>();
            for (FlowElement e : flowElements) {
                if (!(e instanceof UserTask)) continue;
                UserTask userTask = (UserTask)e;
                MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = userTask.getLoopCharacteristics();
                if (multiInstanceLoopCharacteristics != null) {
                    typeMap.put(e.getId(), "\u4f1a\u7b7e");
                    continue;
                }
                typeMap.put(e.getId(), "\u5f85\u5ba1\u6279");
            }
            for (TaProcessApprovalLogVo result : resultList) {
                if (!typeMap.containsKey(result.getTaskDefKey())) continue;
                result.setType((String)typeMap.get(result.getTaskDefKey()));
            }
        }
    }

    private String getJumpToNodeTaskDefKey(String taskDefKey, String processInstanceId) {
        TaJumpNodeEntity record = new TaJumpNodeEntity();
        record.setTargetTaskKey(taskDefKey);
        record.setProcessInstanceId(processInstanceId);
        List list = this.taJumpNodeDao.select(record);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            return ((TaJumpNodeEntity)list.get(0)).getSrcTaskKey();
        }
        return null;
    }

    @Override
    public Map<String, String> getNowPosMap(String processInstanceId) {
        ProcessEngine engine = ProcessEngines.getDefaultProcessEngine();
        TaskService taskService = engine.getTaskService();
        IdentityService identityService = engine.getIdentityService();
        HashMap<String, String> posCodesMap = new HashMap<String, String>();
        Task task = (Task)taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult();
        if (task == null) {
            return posCodesMap;
        }
        posCodesMap.put("taskDefinitionKey", task.getTaskDefinitionKey());
        List identityLinks = taskService.getIdentityLinksForTask(task.getId());
        ArrayList roles = new ArrayList();
        identityLinks.forEach(item -> {
            if (StringUtils.isNotBlank((CharSequence)item.getGroupId())) {
                roles.add(item.getGroupId());
            }
            if (StringUtils.isNotBlank((CharSequence)item.getUserId())) {
                posCodesMap.put(item.getUserId(), item.getUserId());
            }
        });
        roles.forEach(item -> {
            List users = identityService.createUserQuery().memberOfGroup(item).list();
            users.forEach(itemTemp -> posCodesMap.put(itemTemp.getId(), itemTemp.getId()));
        });
        return posCodesMap;
    }

    private List<TaProcessApprovalLogVo> findRuntimeApprovalList(HistoricProcessInstance processInstance) {
        List<TaProcessApprovalLogVo> voList = this.taTaskDao.findRuntimeApprovalList(processInstance.getId());
        Map<Object, Object> posCodesMap = new HashMap();
        String taskDefKey = "";
        if (CollectionUtil.listNotEmptyNotSizeZero(voList)) {
            for (TaProcessApprovalLogVo item2 : voList) {
                posCodesMap.put(item2.getAssignees(), item2.getAssignees());
            }
            taskDefKey = voList.get(0).getTaskDefKey();
        } else {
            posCodesMap = this.getNowPosMap(processInstance.getId());
            taskDefKey = (String)posCodesMap.get("taskDefinitionKey");
        }
        voList = new ArrayList<TaProcessApprovalLogVo>();
        StringBuffer stringBuffer = new StringBuffer();
        posCodesMap.forEach((k, v) -> {
            if (stringBuffer.length() == 0) {
                stringBuffer.append((String)k);
            } else {
                stringBuffer.append(",").append((String)k);
            }
        });
        if (stringBuffer.length() > 0) {
            List positionVos = this.tmPositionFeign.getUserAndPositionInfoByPosCodesList(stringBuffer.toString()).getObjList();
            TaProcessApprovalLogVo taProcessApprovalLogVo = new TaProcessApprovalLogVo();
            StringBuffer username_ = new StringBuffer();
            StringBuffer realname_ = new StringBuffer();
            StringBuffer pos_ = new StringBuffer();
            positionVos.forEach(item -> {
                if (username_.length() == 0) {
                    username_.append(item.getUserName());
                    realname_.append(item.getFullname());
                    pos_.append(item.getPositionName());
                } else {
                    username_.append(",").append(item.getUserName());
                    realname_.append(",").append(item.getFullname());
                    pos_.append(",").append(item.getPositionName());
                }
            });
            taProcessApprovalLogVo.setAccount(username_.toString());
            taProcessApprovalLogVo.setType("\u5f85\u5ba1\u6279");
            taProcessApprovalLogVo.setRoleName(pos_.toString());
            taProcessApprovalLogVo.setName(realname_.toString());
            taProcessApprovalLogVo.setTaskDefKey(taskDefKey);
            voList.add(taProcessApprovalLogVo);
        }
        return voList;
    }

    private List<TaProcessApprovalLogVo> findPendingApprovalList(HistoricProcessInstance processInstance, List<TaProcessApprovalLogVo> runtimeApprovalList) {
        if (CollectionUtil.listEmpty(runtimeApprovalList)) {
            return Collections.emptyList();
        }
        ProcessDefinitionEntity def = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processInstance.getProcessDefinitionId());
        String taskDefKey = runtimeApprovalList.get(0).getTaskDefKey();
        String jumpTaskDefKey = this.getJumpToNodeTaskDefKey(taskDefKey, processInstance.getId());
        ArrayList<TaProcessApprovalLogVo> approvalLogVoList = new ArrayList<TaProcessApprovalLogVo>();
        if (StringUtils.isNotBlank((CharSequence)jumpTaskDefKey)) {
            ActivityImpl activityImpl = def.findActivity(jumpTaskDefKey);
            TaProcessApprovalLogVo approvalLogVo = new TaProcessApprovalLogVo();
            approvalLogVo.setRoleName((String)activityImpl.getProperties().get("name"));
            approvalLogVo.setType("\u5f85\u5ba1\u6279");
            approvalLogVo.setTaskDefKey(activityImpl.getId());
            approvalLogVoList.add(approvalLogVo);
        }
        String currentTaskDefKey = StringUtils.isNotBlank((CharSequence)jumpTaskDefKey) ? jumpTaskDefKey : taskDefKey;
        int count = 0;
        while (StringUtils.isNotBlank((CharSequence)currentTaskDefKey) && !StringUtils.equals((CharSequence)currentTaskDefKey, (CharSequence)"end")) {
            ActivityImpl activityImpl = def.findActivity(currentTaskDefKey);
            List outTransitions = activityImpl.getOutgoingTransitions();
            for (PvmTransition tr : outTransitions) {
                PvmActivity ac = tr.getDestination();
                if (!"end".equals(ac.getId()) && !"exclusiveGateway".equals(ac.getProperty("type"))) {
                    TaProcessApprovalLogVo approvalLogVo = new TaProcessApprovalLogVo();
                    approvalLogVo.setRoleName((String)ac.getProperty("name"));
                    approvalLogVo.setType("\u5f85\u5ba1\u6279");
                    approvalLogVo.setTaskDefKey(ac.getId());
                    approvalLogVoList.add(approvalLogVo);
                }
                currentTaskDefKey = ac.getId();
            }
            if (++count <= 30) continue;
            break;
        }
        return approvalLogVoList;
    }

    @Override
    public AjaxJson<TaProcessApprovalLogVo> findApprovalLogs(MyTaskVo myTaskVo) {
        List<TaProcessApprovalLogVo> approvalLogs2 = this.findApprovalLogs2(myTaskVo);
        if (this.taApprovalLogExtendService != null) {
            approvalLogs2 = this.taApprovalLogExtendService.filterApproveContent(approvalLogs2, myTaskVo);
        }
        AjaxJson result = new AjaxJson();
        result.setList(approvalLogs2);
        return result;
    }

    private String handleNode(String processInstanceId, String taskKey) {
        ActRuTaskEntity record = new ActRuTaskEntity();
        record.setProcInstId(processInstanceId);
        List tasks = this.actRuTaskDao.select(record);
        if (CollectionUtil.listEmpty((List)tasks)) {
            return "''";
        }
        List<TaProcessNodeEntity> nodes = this.taProcessNodeDao.findAllNodeByInst(processInstanceId);
        int count = 0;
        String nowTaskKey = ((ActRuTaskEntity)tasks.get(0)).getTaskDefKey();
        for (int i = 0; i < nodes.size(); ++i) {
            if (!nowTaskKey.equals(nodes.get(i).getProcessNodeCode())) continue;
            ActRuTaskEntity record2 = new ActRuTaskEntity();
            record2.setProcInstId(processInstanceId);
            record2.setTaskDefKey(taskKey);
            List result = this.actRuTaskDao.select(record2);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)result)) {
                count = i + 1;
                break;
            }
            count = i;
            break;
        }
        StringBuilder sb = new StringBuilder();
        for (int n = count; n < nodes.size(); ++n) {
            sb.append("'").append(nodes.get(n).getProcessNodeCode()).append("',");
        }
        if (sb.length() == 0) {
            return "''";
        }
        return sb.substring(0, sb.length() - 1);
    }

    @Override
    public void setNodeAuth(MyTaskVo myTaskVo, HttpServletRequest request) {
        if (StringUtils.isNotBlank((CharSequence)myTaskVo.getTaskId())) {
            Task task = this.getTask(myTaskVo.getTaskId());
            if (task != null) {
                String taskDefinitionKey = task.getTaskDefinitionKey();
                String versionkey = task.getProcessDefinitionId();
                TaProcessNodeProEntity processNodeEntity = this.taProcessNodeService.getTaProcessNodeByVersionKey(versionkey, taskDefinitionKey);
                TaProcessNodeAuthProEntity taProcessNodeAuthEntity = this.taProcessNodeService.getTaProcessNodeAuthEntity(versionkey, processNodeEntity.getId());
                request.setAttribute("nodeAuth", (Object)new TaProcessNodeAuthVo(taProcessNodeAuthEntity.getBtn1(), taProcessNodeAuthEntity.getBtn2(), taProcessNodeAuthEntity.getBtn3(), taProcessNodeAuthEntity.getBtn4(), taProcessNodeAuthEntity.getBtn5(), taProcessNodeAuthEntity.getBtn6(), taProcessNodeAuthEntity.getBtn7(), taProcessNodeAuthEntity.getBtn8(), taProcessNodeAuthEntity.getBtn9(), taProcessNodeAuthEntity.getBtn10()));
            } else {
                request.setAttribute("nodeAuth", (Object)new TaProcessNodeAuthVo("Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y"));
            }
        } else {
            request.setAttribute("nodeAuth", (Object)new TaProcessNodeAuthVo("Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y"));
        }
    }

    @Override
    public String getProcessInstanceBusinessForm(String processInstanceId) {
        BusinessFormVo vo = this.taTaskDao.getBusinessFormByProcessInstanceId(processInstanceId);
        if (vo.getModelandview() == null) {
            return null;
        }
        return vo.getModelandview() + "&businessObjId=" + vo.getBusinessObjId();
    }

    @Override
    public AjaxJson<TaProcessApprovalLogVo> findBaseBusinessObjIdByApprovalLogs(String baseBusinessObjId) {
        AjaxJson ajaxJson = new AjaxJson();
        List<MyTaskVo> myTaskVos = this.taTaskDao.findBaseBusinessObjIdByProcessInstanceId(baseBusinessObjId);
        if (CollectionUtil.listNotEmptyNotSizeZero(myTaskVos)) {
            MyTaskVo myTaskVo = myTaskVos.get(0);
            List logs = this.findApprovalLogs(myTaskVo).getObjList();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)logs)) {
                for (TaProcessApprovalLogVo log : logs) {
                    log.setProcessInstanceId(myTaskVo.getProcessInstanceId());
                }
            }
            ajaxJson.setObjList(logs);
        }
        return ajaxJson;
    }
}

