/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.service.impl;

import com.biz.eisp.activiti.service.ActivitiRoleService;
import com.biz.eisp.api.feign.RoleActivitiFeign;
import com.biz.eisp.api.feign.TmPositionFeign;
import com.biz.eisp.page.Page;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.role.TmActRoleVo;
import com.github.pagehelper.PageInfo;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivitiRoleServiceImpl
implements ActivitiRoleService {
    @Autowired
    private RoleActivitiFeign roleActivitiFeign;
    @Autowired
    private TmPositionFeign tmPositionFeign;

    @Override
    public PageInfo<TmActRoleVo> findRoleByPositionId(String posId, Page page) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("posId", posId);
        map.put("page", page.getPage());
        map.put("rows", page.getRows());
        return this.roleActivitiFeign.findRoleByPositionId(map).getPageInfo();
    }

    @Override
    public PageInfo<TmActRoleVo> findRoleByCondition(String roleCode, String roleName, Page page) {
        HashMap<String, String> param = new HashMap<String, String>();
        roleCode = roleCode == null ? "" : roleCode;
        roleName = roleName == null ? "" : roleName;
        param.put("roleCode", roleCode);
        param.put("roleCode", roleName);
        param.put("page", page.getPage());
        param.put("rows", page.getRows());
        return this.roleActivitiFeign.findRoleByCondition(param).getPageInfo();
    }

    @Override
    public TmActRoleVo getRoleById(String id) {
        TmActRoleVo vo = (TmActRoleVo)this.roleActivitiFeign.getTmActRoleById(id).getObj();
        return vo;
    }

    @Override
    public PageInfo<TmPositionVo> findPositionByActRoleCode(String roleCode, Page page) {
        HashMap<String, String> param = new HashMap<String, String>();
        roleCode = roleCode == null ? "" : roleCode;
        param.put("roleCode", roleCode);
        param.put("page", page.getPage());
        param.put("rows", page.getRows());
        return this.tmPositionFeign.findPosByActRole(param).getPageInfo();
    }

    @Override
    public TmPositionVo getPositionByRoleCodeAndPositionId(String roleCode, String positionId) {
        return (TmPositionVo)this.tmPositionFeign.getPositionByRoleCodeAndPositionId(roleCode, positionId).getObj();
    }

    @Override
    public List<TmPositionVo> findParentPositionByRoleCodeAndPositionId(String actRoleCode, String id) {
        return this.tmPositionFeign.findParentPositionByRoleCodeAndPositionId(actRoleCode, id).getObjList();
    }

    @Override
    public List<TmPositionVo> findPositionByRoleCodeAndOrgId(String roleCode, String orgId, Integer queryType) {
        return this.tmPositionFeign.findPositionByRoleCodeAndOrgId(roleCode, orgId, queryType).getObjList();
    }
}

