/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.designer.processconf.dao.TaProcessDao;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.runtime.dao.TaBaseBusinessObjQueryDao;
import com.biz.eisp.activiti.runtime.dao.TaCarbonCopyDao;
import com.biz.eisp.activiti.runtime.dao.TaCirculationContentDao;
import com.biz.eisp.activiti.runtime.dao.TaCirculationDao;
import com.biz.eisp.activiti.runtime.dao.TaCopyDao;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjQueryEntity;
import com.biz.eisp.activiti.runtime.entity.TaCarbonCopyEntity;
import com.biz.eisp.activiti.runtime.entity.TaCirculationContentEntity;
import com.biz.eisp.activiti.runtime.entity.TaCirculationEntity;
import com.biz.eisp.activiti.runtime.entity.TaCopyEntity;
import com.biz.eisp.activiti.runtime.service.TaCarbonCopyService;
import com.biz.eisp.activiti.runtime.transformer.TaCarbonCopyEntityToTaCarbonCopyVo;
import com.biz.eisp.activiti.runtime.vo.TaCarbonCopyVo;
import com.biz.eisp.activiti.runtime.vo.TaCopyCirculationVo;
import com.biz.eisp.activiti.runtime.vo.TaCopyPersonInfoVo;
import com.biz.eisp.api.feign.TmPositionFeign;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ListChangeUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.util.ResourceService;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="taCarbonCopyService")
@Transactional
public class TaCarbonCopyServiceImpl
implements TaCarbonCopyService {
    @Autowired
    private TaCarbonCopyDao taCarbonCopyDao;
    @Autowired
    private TaProcessDao taProcessDao;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private TaBaseBusinessObjQueryDao taBaseBusinessObjQueryDao;
    @Autowired
    private TaCirculationDao taCirculationDao;
    @Autowired
    private TaCirculationContentDao taCirculationContentDao;
    @Autowired
    private TaCopyDao taCopyDao;
    @Autowired
    private ResourceService resource;
    @Autowired
    private TmPositionFeign tmPositionFeign;

    @Override
    public AjaxJson<TaCarbonCopyVo> getAllByProcessKey(String taProcessKey) {
        TaCarbonCopyEntity record = new TaCarbonCopyEntity();
        record.setTaProcessKey(taProcessKey);
        List list = this.taCarbonCopyDao.select(record);
        List voList = Lists.transform((List)list, (Function)new TaCarbonCopyEntityToTaCarbonCopyVo());
        AjaxJson result = new AjaxJson();
        result.setList(voList);
        return result;
    }

    @Override
    public AjaxJson<TaCopyCirculationVo> getCarbonCopyByConditions(TaCopyCirculationVo vo, Page page) {
        TmPositionVo loginPosition = this.resource.getCurrPosition();
        vo.setQueryCode(loginPosition.getPositionCode());
        String processInstanceId = vo.getProcessInstanceId();
        if (StringUtils.isNotBlank((CharSequence)processInstanceId)) {
            vo.setProcessInstanceIdQuery(processInstanceId);
            vo.setProcessInstanceId(null);
        }
        PageInfo infoList = PageAutoHelperUtil.generatePage(() -> this.taCarbonCopyDao.findCarbonCopyAndCirculation(vo), (Page)page);
        AjaxJson result = new AjaxJson();
        result.setPageInfo(infoList);
        return result;
    }

    @Override
    public void saveCirculation(String processInstanceId, String codes, String names, String fullNames, String content) {
        boolean flag = this.validateValues(processInstanceId, codes, names);
        if (flag) {
            String[] code = codes.split(",");
            String[] name = names.split(",");
            String[] fullName = fullNames.split(",");
            HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            String businessKey = processInstance.getBusinessKey();
            ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
            TaBaseBusinessObjQueryEntity businessObjEntity = (TaBaseBusinessObjQueryEntity)this.taBaseBusinessObjQueryDao.selectByPrimaryKey(businessKey);
            String positionCode = businessObjEntity.getPositionCode();
            String positionName = businessObjEntity.getPositionName();
            TaCirculationEntity circulation = new TaCirculationEntity();
            circulation.setBusinessKey(businessKey);
            circulation.setProcessInstanceId(processInstanceId);
            circulation.setProcessName(processDefinition.getName());
            circulation.setProcessKey(processDefinition.getKey());
            circulation.setProcessTitle(businessObjEntity.getProcessTitle());
            circulation.setLaunchCode(this.resource.getCurrPosition().getPositionCode());
            circulation.setLaunchName(this.resource.getCreateName());
            circulation.setCreateProcessPositionCode(positionCode);
            circulation.setCreateProcessPositionName(positionName);
            this.taCirculationDao.insertSelective(circulation);
            for (int i = 0; i < code.length; ++i) {
                TaCirculationContentEntity cirContent = new TaCirculationContentEntity();
                cirContent.setTaCirculationId(circulation.getId());
                cirContent.setContent(content == null ? "\u4f20\u9605" : content);
                cirContent.setCirculationCode(code[i]);
                cirContent.setCirculationName(fullName[i] + "(" + name[i] + ")");
                cirContent.setViewStatus("0");
                cirContent.setReadStatus("0");
                cirContent.setIsReply("0");
                this.taCirculationContentDao.insertSelective(cirContent);
            }
        }
    }

    @Override
    public void delCarbonCopyById(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            String[] strs;
            for (String str : strs = ids.split(",")) {
                this.taCarbonCopyDao.deleteByPrimaryKey(str);
            }
        }
    }

    @Override
    public void saveCarbonCopy(TaCarbonCopyVo vo) {
        String taProcessId = vo.getTaProcessId();
        String code = vo.getCode();
        String name = vo.getName();
        String state = vo.getState();
        String chooseCondition = vo.getChooseCondition();
        if (StringUtils.isNotEmpty((CharSequence)taProcessId) && StringUtils.isNotEmpty((CharSequence)state)) {
            String[] codes = code.split(",");
            String[] names = name.split(",");
            for (int i = 0; i < codes.length; ++i) {
                String c = codes[i];
                String n = names[i];
                boolean flag = this.validateData(c, taProcessId);
                if (!flag) {
                    throw new BusinessException("\u5df2\u7ecf\u6709\u91cd\u590d\u7684\u6570\u636e\uff0c\u4e0d\u80fd\u518d\u6dfb\u52a0");
                }
                TaProcessEntity processEntity = (TaProcessEntity)this.taProcessDao.selectByPrimaryKey(taProcessId);
                TaCarbonCopyEntity copyEntity = new TaCarbonCopyEntity();
                copyEntity.setTaProcessId(taProcessId);
                copyEntity.setTaProcessKey(processEntity.getProcessKey());
                copyEntity.setCode(c);
                copyEntity.setName(n);
                copyEntity.setState(state);
                if (state.equals("0")) {
                    copyEntity.setChooseCondition(chooseCondition);
                } else if (state.equals("1")) {
                    copyEntity.setChooseCondition("0");
                }
                this.taCarbonCopyDao.insertSelective(copyEntity);
            }
        }
    }

    @Override
    public AjaxJson<TaCopyCirculationVo> findCopyAndCirculation(TaCopyCirculationVo vo, Page page) {
        TmPositionVo loginPosition = this.resource.getCurrPosition();
        AjaxJson result = new AjaxJson();
        if (StringUtils.isBlank((CharSequence)loginPosition.getPositionCode())) {
            TaCopyEntity record = new TaCopyEntity();
            record.setId("-1");
            PageInfo infoList = PageAutoHelperUtil.generatePage(() -> this.taCopyDao.select(record), (Page)page);
            List entityList = infoList.getList();
            ArrayList<TaCopyCirculationVo> list = new ArrayList<TaCopyCirculationVo>();
            for (TaCopyEntity entity : entityList) {
                TaCopyCirculationVo copyCirculationVo = new TaCopyCirculationVo();
                MyBeanUtils.apply((Object)entity, (Object)copyCirculationVo);
                list.add(copyCirculationVo);
            }
            PageInfo pageInfo = new PageInfo();
            pageInfo.setList(list);
            pageInfo.setTotal(infoList.getTotal());
            result.setPageInfo(pageInfo);
            return result;
        }
        vo.setQueryCode(loginPosition.getPositionCode());
        PageInfo infoList = PageAutoHelperUtil.generatePage(() -> this.taCarbonCopyDao.findCarbonCopyAndCirculationList(vo), (Page)page);
        result.setPageInfo(infoList);
        return result;
    }

    @Override
    public AjaxJson<TaCarbonCopyEntity> findTaCarbonCopy(TaCarbonCopyVo vo, Page page) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getTaProcessId())) {
            Example example = new Example(TaCarbonCopyEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("taProcessId", (Object)vo.getTaProcessId());
            if (StringUtil.isNotEmpty((CharSequence)vo.getCode())) {
                criteria.andLike("code", "%" + vo.getCode() + "%");
            }
            if (StringUtil.isNotEmpty((CharSequence)vo.getName())) {
                criteria.andLike("name", "%" + vo.getName() + "%");
            }
            if (StringUtil.isNotEmpty((CharSequence)vo.getState())) {
                criteria.andEqualTo("state", (Object)vo.getState());
            }
            PageInfo infoList = PageAutoHelperUtil.generatePage(() -> this.taCarbonCopyDao.selectByExample(example), (Page)page);
            AjaxJson result = new AjaxJson();
            result.setPageInfo(infoList);
            return result;
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getTaProcessKey())) {
            Example example = new Example(TaCarbonCopyEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("taProcessKey", (Object)vo.getTaProcessKey());
            if (StringUtil.isNotEmpty((CharSequence)vo.getCode())) {
                criteria.andLike("code", "%" + vo.getCode() + "%");
            }
            if (StringUtil.isNotEmpty((CharSequence)vo.getName())) {
                criteria.andLike("name", "%" + vo.getName() + "%");
            }
            if (StringUtil.isNotEmpty((CharSequence)vo.getState())) {
                criteria.andEqualTo("state", (Object)vo.getState());
            }
            PageInfo infoList = PageAutoHelperUtil.generatePage(() -> this.taCarbonCopyDao.selectByExample(example), (Page)page);
            AjaxJson result = new AjaxJson();
            result.setPageInfo(infoList);
            return result;
        }
        throw new BusinessException("\u5bf9\u4e0d\u8d77\uff0c\u6570\u636e\u5f02\u5e38\uff0c\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    private boolean validateData(String code, String taProcessId) {
        TaCarbonCopyEntity record = new TaCarbonCopyEntity();
        record.setTaProcessKey(taProcessId);
        record.setCode(code);
        List list = this.taCarbonCopyDao.select(record);
        return CollectionUtil.listEmpty((List)list);
    }

    private boolean validateValues(String ... strs) {
        for (String str : strs) {
            if (!StringUtils.isBlank((CharSequence)str)) continue;
            return false;
        }
        return true;
    }

    private int getWordCountRegex(String s) {
        s = s.replaceAll("[^\\x00-\\xff]", "**");
        int length = s.length();
        return length;
    }

    @Override
    public AjaxJson<TaCopyPersonInfoVo> findCopyPersonInfoList(TaCopyPersonInfoVo vo, Page page) {
        PageInfo voList = PageAutoHelperUtil.generatePage(() -> this.taCarbonCopyDao.findCopyPersonInfoList(vo), (Page)page);
        AjaxJson result = new AjaxJson();
        result.setPageInfo(voList);
        return result;
    }

    @Override
    public AjaxJson<TaCopyCirculationVo> findCircularizePersonInfoList(TaCopyCirculationVo vo, Page page) {
        String pos;
        List positionVos;
        PageInfo voList = PageAutoHelperUtil.generatePage(() -> this.taCarbonCopyDao.findCirculationById(vo), (Page)page);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)voList.getList()) && CollectionUtil.listNotEmptyNotSizeZero((List)(positionVos = this.tmPositionFeign.getUserAndPositionInfoByPosCodesList(pos = ListChangeUtil.changeListEntityOnePropertyCommonString((List)voList.getList(), (String)"circulationCode", null, (boolean)true)).getObjList()))) {
            Map<String, TmPositionVo> map = positionVos.stream().collect(Collectors.toMap(TmPositionVo::getPositionCode, voTemp -> voTemp));
            voList.getList().forEach(item -> {
                if (map.containsKey(item.getCirculationCode())) {
                    item.setCopyCode(((TmPositionVo)map.get(item.getCirculationCode())).getUserName());
                    item.setCopyName(((TmPositionVo)map.get(item.getCirculationCode())).getFullname());
                    item.setCirculationName(((TmPositionVo)map.get(item.getCirculationCode())).getPositionName());
                }
            });
        }
        AjaxJson result = new AjaxJson();
        result.setPageInfo(voList);
        return result;
    }
}

