/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.controller;

import com.biz.eisp.activiti.designer.businessconf.vo.TaProcessBusinessObjConfigVo;
import com.biz.eisp.activiti.runtime.entity.TaRuntimeStatusEntity;
import com.biz.eisp.activiti.runtime.service.TaProcessInstanceService;
import com.biz.eisp.activiti.runtime.vo.BusinessFormVo;
import com.biz.eisp.activiti.runtime.vo.HistoryTaskVo;
import com.biz.eisp.activiti.runtime.vo.MyInstanceVo;
import com.biz.eisp.activiti.runtime.vo.ProcessInstanceVo;
import com.biz.eisp.activiti.util.ParamUtil;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.util.ResourceService;
import com.github.pagehelper.PageInfo;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/taProcessInstanceController"})
public class TaProcessInstanceController {
    @Autowired
    private TaProcessInstanceService taProcessInstanceService;
    @Autowired
    private ResourceService resource;

    @RequestMapping(value={"startBusinessProcess"})
    @ResponseBody
    public AjaxJson startBusinessProcess(TaProcessBusinessObjConfigVo taProcessBusinessObjConfigVo) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taProcessInstanceService.saveStartWorkflow(taProcessBusinessObjConfigVo);
            aj.setMsg("\u542f\u52a8\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            aj.setSuccess(false);
            aj.setMsg("\u542f\u52a8\u4e1a\u52a1\u6d41\u7a0b\u5931\u8d25\uff1a" + e.getMessage());
        }
        return aj;
    }

    @RequestMapping(value={"goMyStartedProcessMain"})
    public ModelAndView goMyStartedProcessList() {
        return new ModelAndView("com/biz/eisp/activiti/instance/myStartedProcessMain");
    }

    @RequestMapping(value={"goProcessInstanceMain"})
    public ModelAndView goProcessInstanceMain() {
        List<TaRuntimeStatusEntity> runtimeStatusList = this.taProcessInstanceService.findTaRuntimeStatusAll();
        if (!CollectionUtil.listNotEmptyNotSizeZero(runtimeStatusList)) {
            runtimeStatusList = new ArrayList<TaRuntimeStatusEntity>();
        }
        ModelAndView mv = new ModelAndView("com/biz/eisp/activiti/instance/processInstanceMain");
        mv.addObject("runtimeStatusList", runtimeStatusList);
        return mv;
    }

    @RequestMapping(value={"findMyStartedProcessList"})
    @ResponseBody
    public DataGrid findMyStartedProcessList(String time, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        TmPositionVo positionEntity = this.resource.getCurrPosition();
        MyInstanceVo myInstanceVo = new MyInstanceVo();
        ParamUtil.packParams(myInstanceVo, (Page)page);
        myInstanceVo.setStartPositionCode(positionEntity.getPositionCode());
        PageInfo<MyInstanceVo> pageInfo = this.taProcessInstanceService.findMyStartedProcessList(myInstanceVo, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"updateViewStatus"})
    @ResponseBody
    public AjaxJson updateViewStatus(MyInstanceVo myInstanceVo) {
        AjaxJson ajaxJson = new AjaxJson();
        this.taProcessInstanceService.updateViewStatus(myInstanceVo);
        return ajaxJson;
    }

    @RequestMapping(value={"findProcessInstanceList"})
    @ResponseBody
    public DataGrid findProcessInstanceList(ProcessInstanceVo processInstanceVo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        ParamUtil.packParams(processInstanceVo, (Page)page);
        PageInfo<ProcessInstanceVo> pageInfo = this.taProcessInstanceService.findProcessInstanceList(processInstanceVo, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"goProcessPicInfoForm"})
    public ModelAndView goProcessPicInfoForm(String processInstanceId) {
        ModelAndView mv = new ModelAndView("com/biz/eisp/activiti/instance/processPicInfoForm");
        mv.addObject("processInstanceId", (Object)processInstanceId);
        return mv;
    }

    @RequestMapping(value={"getProcessPicInfo"})
    public void getProcessPicInfo(String processInstanceId, HttpServletResponse response) throws Exception {
        response.setContentType("UTF-8");
        response.setCharacterEncoding("UTF-8");
        try {
            InputStream is = this.taProcessInstanceService.getProcessInstancePicInfo(processInstanceId);
            int len = 0;
            byte[] b = new byte[1024];
            while ((len = is.read(b, 0, 1024)) != -1) {
                response.getOutputStream().write(b, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"findProcessInstanceHistoryTaskList"})
    @ResponseBody
    public DataGrid findProcessInstanceHistoryTaskList(HistoryTaskVo historyTaskVo) {
        List<HistoryTaskVo> voList = this.taProcessInstanceService.findProcessInstanceHistoryTaskList(historyTaskVo);
        return new DataGrid(voList, null);
    }

    @RequestMapping(value={"deleteProcessInstance"})
    @ResponseBody
    public AjaxJson deleteProcessInstance(MyInstanceVo myInstanceVo) {
        AjaxJson json = new AjaxJson();
        try {
            this.taProcessInstanceService.deleteProcessInstance(myInstanceVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            json.setMsg(e.getMessage());
            json.setSuccess(false);
        }
        return json;
    }

    @RequestMapping(value={"callBackProcess"})
    @ResponseBody
    public AjaxJson callBackProcess(MyInstanceVo myInstanceVo) {
        AjaxJson json = new AjaxJson();
        try {
            this.taProcessInstanceService.callBackProcess(myInstanceVo);
        }
        catch (BusinessException b) {
            json.setMsg(b.getMessage());
            json.setSuccess(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            json.setMsg(e.getMessage());
            json.setSuccess(false);
        }
        return json;
    }

    @RequestMapping(value={"closeProcessInstance"})
    @ResponseBody
    public AjaxJson closeProcessInstance(MyInstanceVo myInstanceVo) {
        AjaxJson json = new AjaxJson();
        try {
            this.taProcessInstanceService.closeProcessInstance(myInstanceVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            json.setMsg(e.getMessage());
            json.setSuccess(false);
        }
        return json;
    }

    @RequestMapping(value={"suspend"})
    @ResponseBody
    public AjaxJson suspend(MyInstanceVo myInstanceVo) {
        AjaxJson json = new AjaxJson();
        try {
            this.taProcessInstanceService.suspendProcessInstance(myInstanceVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            json.setMsg(e.getMessage());
            json.setSuccess(false);
        }
        return json;
    }

    @RequestMapping(value={"restart"})
    @ResponseBody
    public AjaxJson restart(MyInstanceVo myInstanceVo) {
        AjaxJson json = new AjaxJson();
        try {
            this.taProcessInstanceService.activateProcessInstance(myInstanceVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            json.setMsg(e.getMessage());
            json.setSuccess(false);
        }
        return json;
    }

    @GetMapping(value={"/taProcessInstanceController/findTaRuntimeStatusAll"})
    @ResponseBody
    public AjaxJson<TaRuntimeStatusEntity> findTaRuntimeStatusAll() {
        AjaxJson ajaxJson = new AjaxJson();
        List<TaRuntimeStatusEntity> runtimeStatusList = this.taProcessInstanceService.findTaRuntimeStatusAll();
        ajaxJson.setList(runtimeStatusList);
        return ajaxJson;
    }

    @GetMapping(value={"getProcessInstanceBusinessForm"})
    @ResponseBody
    public AjaxJson<BusinessFormVo> getProcessInstanceBusinessForm(@RequestParam(value="processInstanceId") String processInstanceId) {
        AjaxJson ajaxJson = new AjaxJson();
        BusinessFormVo formVo = this.taProcessInstanceService.getProcessInstanceBusinessForm(processInstanceId);
        ajaxJson.setObj((Object)formVo);
        return ajaxJson;
    }
}

