/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.dingtalk.api.controller;

import com.biz.eisp.activiti.HistoryFeign;
import com.biz.eisp.activiti.TaAttachmentFeign;
import com.biz.eisp.activiti.TaCommunicateFeign;
import com.biz.eisp.activiti.TaProcessInstanceFeign;
import com.biz.eisp.activiti.TaProcessNodeAuthFeign;
import com.biz.eisp.activiti.TaTaskFeign;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeAuthVo;
import com.biz.eisp.activiti.runtime.entity.TaCommunicateContentEntity;
import com.biz.eisp.activiti.runtime.vo.BusinessFormVo;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.dingtalk.api.vo.DingtalkActTaskDetail;
import com.biz.eisp.dingtalk.api.vo.DingtalkActTaskDetailReqVo;
import com.biz.eisp.tk.utils.BeanCopyUtils;
import com.biz.eisp.util.ResourceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u9489\u9489H5\u6d41\u7a0b\u5ba1\u6279\u6570\u636e\u63a5\u53e3", tags={"\u9489\u9489H5\u6d41\u7a0b\u5ba1\u6279\u6570\u636e\u63a5\u53e3"})
@Controller
@RequestMapping(value={"/dingtalkActTaskController"})
public class DingtalkActTaskController {
    private static final Logger log = LoggerFactory.getLogger(DingtalkActTaskController.class);
    @Autowired
    private TaProcessInstanceFeign taProcessInstanceFeign;
    @Autowired
    private TaCommunicateFeign taCommunicateFeign;
    @Autowired
    private TaTaskFeign taTaskFeign;
    @Autowired
    private HistoryFeign historyFeign;
    @Autowired
    private TaAttachmentFeign taAttachmentFeign;
    @Autowired
    private TaProcessNodeAuthFeign taProcessNodeAuthFeign;
    @Autowired
    private ResourceService resource;

    @ApiOperation(value="\u5ba1\u6279\u8be6\u60c5")
    @GetMapping(value={"getTaskDetail"})
    @ResponseBody
    public AjaxJson<DingtalkActTaskDetail> getTaskDetail(DingtalkActTaskDetailReqVo param) {
        MyTaskVo myTaskVo = (MyTaskVo)BeanCopyUtils.copyToBean((Object)param, MyTaskVo.class);
        DingtalkActTaskDetail data = new DingtalkActTaskDetail();
        data.setCurrPositionCode(this.resource.getCurrPosition().getPositionCode());
        if (ConstantEnum.YesNoEnum.Y.getValue().equals(myTaskVo.getIsCommunicate())) {
            TaCommunicateContentEntity communicateEntity = (TaCommunicateContentEntity)this.taCommunicateFeign.getCommunicateContentById(myTaskVo.getId()).getObj();
            data.setCommunicateContent(communicateEntity.getContent());
            data.setCommunicateId(communicateEntity.getId());
        }
        this.backNodes(data, myTaskVo);
        List logs = this.taTaskFeign.findApprovalLogs(myTaskVo).getObjList();
        data.setLogs(logs);
        MyTaskVo processVo = (MyTaskVo)this.taTaskFeign.findProcessBasicInfoByProcinstId(myTaskVo.getProcessInstanceId()).getObj();
        List attachments = this.taAttachmentFeign.findAttachmentListByProcinstId(myTaskVo.getProcessInstanceId()).getObjList();
        data.setProcessVo(processVo);
        data.setAttachments(attachments);
        TaProcessNodeAuthVo nodeAuthVo = (TaProcessNodeAuthVo)this.taProcessNodeAuthFeign.getNodeAuthByTaskId(myTaskVo.getTaskId()).getObj();
        data.setNodeAuthVo(nodeAuthVo);
        AjaxJson json = new AjaxJson();
        json.setObj((Object)data);
        return json;
    }

    private void backNodes(DingtalkActTaskDetail data, MyTaskVo myTaskVo) {
        List historicTaskInstanceVos = this.historyFeign.getHistoricTaskInstanceVo(myTaskVo.getProcessInstanceId()).getObjList();
        ArrayList<Map<String, String>> backTaskIdlist = new ArrayList<Map<String, String>>();
        historicTaskInstanceVos.forEach(item -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", item.getTaskDefinitionKey());
            map.put("name", item.getName());
            backTaskIdlist.add(map);
        });
        data.setBackTaskIdlist(backTaskIdlist);
    }

    private void buildBusinessFormVo(MyTaskVo myTaskVo) {
        AjaxJson indicator;
        BusinessFormVo businessFormVo = (BusinessFormVo)this.taProcessInstanceFeign.getProcessInstanceBusinessForm(myTaskVo.getProcessInstanceId()).getObj();
        String modelAndView = StringUtils.isBlank((CharSequence)myTaskVo.getTaskId()) ? businessFormVo.getModelandview() : ((BusinessFormVo)this.taTaskFeign.getTaskBusinessForm(myTaskVo.getTaskId()).getObj()).getModelandview();
        if (modelAndView != null) {
            modelAndView = modelAndView + "?isKeyIndicators=true&businessObjId=" + businessFormVo.getBusinessObjId();
        }
        if ((indicator = this.taTaskFeign.findKeyIndicators(myTaskVo)).isSuccess()) {
            Map attrs = indicator.getAttributes();
            for (String string : attrs.keySet()) {
            }
        }
    }

    @ApiOperation(value="\u5ba1\u6279\u6458\u8981")
    @GetMapping(value={"getTaskAbstract"})
    @ResponseBody
    public AjaxJson<DingtalkActTaskDetail> getTaskAbstract(String processInstanceId) {
        DingtalkActTaskDetail data = new DingtalkActTaskDetail();
        MyTaskVo processVo = (MyTaskVo)this.taTaskFeign.findProcessBasicInfoByProcinstId(processInstanceId).getObj();
        List attachments = this.taAttachmentFeign.findAttachmentListByProcinstId(processInstanceId).getObjList();
        data.setProcessVo(processVo);
        data.setAttachments(attachments);
        AjaxJson json = new AjaxJson();
        json.setObj((Object)data);
        return json;
    }

    @ApiOperation(value="\u4e1a\u52a1\u6570\u636e\u9875\u9762")
    @GetMapping(value={"getTaskBusinessFormUrl"})
    @ResponseBody
    public AjaxJson<String> getTaskBusinessFormUrl(String processInstanceId) {
        String isdetail = "1";
        AjaxJson json = new AjaxJson();
        if (StringUtil.isBlank((CharSequence)processInstanceId)) {
            return json;
        }
        BusinessFormVo formVo = (BusinessFormVo)this.taProcessInstanceFeign.getProcessInstanceBusinessForm(processInstanceId).getObj();
        if (formVo != null) {
            String modelAndView = formVo.getModelandview() + "&id=" + formVo.getBusinessObjId();
            json.setObj((Object)(modelAndView + "&isdetail=" + isdetail));
        }
        return json;
    }
}

