/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.dingtalk.base;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.dingtalk.utils.DingtalkConstant;
import com.biz.eisp.service.RedisService;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccessToken {
    @Autowired
    private RedisService redisService;

    public String getAccessToken() {
        String token = (String)this.redisService.get(DingtalkConstant.AccessTokenEnumKey.ACCESS_TOKEN_AS_H5_APPROVE.name());
        if (StringUtils.isBlank((CharSequence)token)) {
            token = this.loadToken();
        }
        return token;
    }

    private String loadToken() {
        DefaultDingTalkClient client = new DefaultDingTalkClient(DingtalkConstant.TOKEN_URL);
        OapiGettokenRequest request = new OapiGettokenRequest();
        request.setAppkey(DingtalkConstant.APPKEY_AS_H5_APPROVE);
        request.setAppsecret(DingtalkConstant.APPSECRET_AS_H5_APPROVE);
        request.setHttpMethod("GET");
        try {
            OapiGettokenResponse response = (OapiGettokenResponse)client.execute((TaobaoRequest)request);
            String token = response.getAccessToken();
            if (response.isSuccess() && StringUtils.isNotBlank((CharSequence)token)) {
                boolean redisUpdate = this.redisService.setMinutes(DingtalkConstant.AccessTokenEnumKey.ACCESS_TOKEN_AS_H5_APPROVE.name(), (Object)token, 115L);
                if (!redisUpdate) {
                    throw new BusinessException("\u7f13\u5b58\u9489\u9489 access_token \u5931\u8d25\uff01");
                }
                return token;
            }
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u9489\u9489 access_token\uff01");
        }
        catch (ApiException e) {
            throw new BusinessException("\u83b7\u53d6\u9489\u9489 access_token \u5931\u8d25\uff01", (Throwable)e);
        }
    }
}

