/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.dingtalk.service.impl;

import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.activiti.vo.DingtalkTodoAddReqVo;
import com.biz.eisp.api.feign.TmUserFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.dingtalk.service.DingActivitiService;
import com.biz.eisp.dingtalk.service.DingtalkTodoService;
import com.biz.eisp.user.entity.TmUserEntity;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DingActivitiServiceImpl
implements DingActivitiService {
    @Autowired
    private TaTaskService taTaskService;
    @Autowired
    private DingtalkTodoService dingtalkTodoService;
    @Autowired
    private TmUserFeign tmUserFeign;

    @Override
    public void commit(String processInstanceId) {
        this.addDingTodo(processInstanceId);
    }

    private void addDingTodo(String processInstanceId) {
        Map<String, List<String>> map = this.taTaskService.getNowPostMapForDingDing(processInstanceId);
        if (map == null || map.isEmpty()) {
            return;
        }
        MyTaskVo myTaskVo = this.taTaskService.findProcessBasicInfoByProcinstId(processInstanceId);
        map.forEach((k, v) -> v.forEach(item -> {
            if (StringUtils.isNotBlank((CharSequence)item)) {
                TmUserEntity userEntity = (TmUserEntity)ApiResultUtil.objResult((AjaxJson)this.tmUserFeign.findPositionUserByIdOrCode(null, item));
                DingtalkTodoAddReqVo dingtalkTodoAddReqVo = new DingtalkTodoAddReqVo(myTaskVo.getProcessTitle(), processInstanceId, myTaskVo.getCreateUserName(), userEntity.getUsername(), item, processInstanceId, k);
                this.dingtalkTodoService.addDingtalkTodo(dingtalkTodoAddReqVo);
            }
        }));
    }

    @Override
    @Transactional
    public void pass(String processInstanceId) {
        this.dingtalkTodoService.updateTodoByProcessInstanceId(processInstanceId);
        this.addDingTodo(processInstanceId);
    }

    @Override
    public void reject(String processInstanceId) {
        this.dingtalkTodoService.updateTodoByProcessInstanceId(processInstanceId);
    }

    @Override
    public void rejectTarger(String processInstanceId) {
        this.dingtalkTodoService.updateTodoByProcessInstanceId(processInstanceId);
        this.addDingTodo(processInstanceId);
    }
}

