/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.hideNode.service.impl;

import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeVo;
import com.biz.eisp.activiti.entity.activiti.ActHiTaskinstEntity;
import com.biz.eisp.activiti.hideNode.dao.TaHideNodeDao;
import com.biz.eisp.activiti.hideNode.entity.TaHideNodeEntity;
import com.biz.eisp.activiti.hideNode.service.TaHideNodeService;
import com.biz.eisp.activiti.runtime.dao.ActHiTaskinstDao;
import com.biz.eisp.activiti.runtime.service.TaApprovalLogExtendService;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.activiti.runtime.vo.TaProcessApprovalLogVo;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.util.ResourceService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="taApprovalLogExtendService")
@Transactional
public class TaExtendService
implements TaApprovalLogExtendService {
    @Autowired
    private TaHideNodeService taHideNodeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ResourceService resourceUtil;
    @Autowired
    private TaHideNodeDao taHideNodeDao;
    @Autowired
    private ActHiTaskinstDao actHiTaskinstDao;

    @Override
    public List<TaProcessApprovalLogVo> filterApproveContent(List<TaProcessApprovalLogVo> list, MyTaskVo myTaskVo) {
        String positionCode = this.resourceUtil.getCurrPosition().getPositionCode();
        String positionId = this.resourceUtil.getCurrPosition().getId();
        String roleCodes = UserUtils.getUser().getRoleCodes();
        if (StringUtil.isNotEmpty((CharSequence)roleCodes) && roleCodes.contains(Globals.Admin_Name)) {
            return list;
        }
        String processInstanceId = myTaskVo.getProcessInstanceId();
        String taskId = myTaskVo.getTaskId();
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            throw new BusinessException("\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a,\u8bf7\u68c0\u67e5");
        }
        String isCommunicate = myTaskVo.getIsCommunicate();
        if (StringUtils.isBlank((CharSequence)isCommunicate) || isCommunicate.equals("Y") || isCommunicate.equals("N")) {
            Task task = null;
            if (StringUtil.isNotBlank((CharSequence)taskId)) {
                task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
            }
            if (task != null) {
                if (StringUtils.isNotBlank((CharSequence)isCommunicate) && "Y".equals(isCommunicate)) {
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("processInstanceId", processInstanceId);
                    param.put("isCommunicate", "1");
                    List<TaProcessNodeVo> bySql = this.getHiddenProcessNode(param);
                    return this.displayLog(list, bySql);
                }
                String taskDefinitionKey = task.getTaskDefinitionKey();
                List<TaProcessNodeVo> hideNode = this.taHideNodeService.findOpenNode(processInstanceId, taskDefinitionKey);
                return this.displayLog(list, hideNode);
            }
            List<TaProcessNodeVo> bySql = this.getHistoryProcessNode(processInstanceId, positionCode);
            if (CollectionUtil.listNotEmptyNotSizeZero(bySql)) {
                String processNodeCode = bySql.get(0).getProcessNodeCode();
                List<TaProcessNodeVo> hideNodes = this.taHideNodeService.findOpenNode(processInstanceId, processNodeCode);
                return this.displayLog(list, hideNodes);
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("processInstanceId", processInstanceId);
            param.put("isCommunicate", "1");
            List<TaProcessNodeVo> bySql1 = this.getHiddenProcessNode(param);
            return this.displayLog(list, bySql1);
        }
        if (isCommunicate.equals("C")) {
            List<TaProcessNodeVo> bySql = this.getHistoryProcessNode(processInstanceId, positionCode);
            if (CollectionUtil.listNotEmptyNotSizeZero(bySql)) {
                String processNodeCode = bySql.get(0).getProcessNodeCode();
                List<TaProcessNodeVo> hideNodes = this.taHideNodeService.findOpenNode(processInstanceId, processNodeCode);
                return this.displayLog(list, hideNodes);
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("processInstanceId", processInstanceId);
            param.put("isCopyCir", "1");
            List<TaProcessNodeVo> hideNode = this.getHiddenProcessNode(param);
            return this.displayLog(list, hideNode);
        }
        return list;
    }

    private List<TaProcessApprovalLogVo> displayLog(List<TaProcessApprovalLogVo> list, List<TaProcessNodeVo> hideNode) {
        for (TaProcessApprovalLogVo taProcessApprovalLogVo : list) {
            for (TaProcessNodeVo taProcessNodeVo : hideNode) {
                String content;
                String hideCode;
                String taskDefKey = taProcessApprovalLogVo.getTaskDefKey();
                if (StringUtils.isBlank((CharSequence)taskDefKey) || !taskDefKey.equals(hideCode = taProcessNodeVo.getProcessNodeCode()) || !StringUtils.isNotBlank((CharSequence)(content = taProcessApprovalLogVo.getContent()))) continue;
                taProcessApprovalLogVo.setContent("\u610f\u89c1\u9690\u85cf");
            }
        }
        return list;
    }

    private List<TaProcessNodeVo> getHistoryProcessNode(String processInstanceId, String positionCode) {
        Example example = new Example(ActHiTaskinstEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("procInstId", (Object)processInstanceId);
        criteria.andEqualTo("assignee", (Object)positionCode);
        example.setDistinct(true);
        List instList = this.actHiTaskinstDao.selectByExample(example);
        ArrayList<TaProcessNodeVo> processNodeVos = new ArrayList<TaProcessNodeVo>();
        for (ActHiTaskinstEntity inst : instList) {
            TaProcessNodeVo processNodeVo = new TaProcessNodeVo();
            processNodeVo.setProcessNodeCode(inst.getTaskDefKey());
            processNodeVos.add(processNodeVo);
        }
        return processNodeVos;
    }

    private List<TaProcessNodeVo> getHiddenProcessNode(Map<String, Object> criterias) {
        Example example = new Example(TaHideNodeEntity.class);
        Example.Criteria criteria = example.createCriteria();
        for (String prop : criterias.keySet()) {
            criteria.andEqualTo(prop, criterias.get(prop));
        }
        example.setDistinct(true);
        List nodeList = this.taHideNodeDao.selectByExample(example);
        ArrayList<TaProcessNodeVo> processNodeVoList = new ArrayList<TaProcessNodeVo>();
        for (TaHideNodeEntity nodeEntity : nodeList) {
            TaProcessNodeVo processNodeVo = new TaProcessNodeVo();
            processNodeVo.setProcessNodeCode(nodeEntity.getHiddenNodeCode());
            processNodeVoList.add(processNodeVo);
        }
        return processNodeVoList;
    }
}

