/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.external.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.businessconf.entity.TaProcessBusinessObjConfigEntity;
import com.biz.eisp.activiti.designer.businessconf.service.TaProcessBusinessObjConfigService;
import com.biz.eisp.activiti.designer.businessconf.vo.TaProcessBusinessObjConfigVo;
import com.biz.eisp.activiti.designer.processconf.dao.ActTargetConfigDao;
import com.biz.eisp.activiti.designer.processconf.dao.ActTargetConfigProDao;
import com.biz.eisp.activiti.designer.processconf.dao.ActTargetContentDao;
import com.biz.eisp.activiti.designer.processconf.dao.ActTargetContentObjDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessDao;
import com.biz.eisp.activiti.designer.processconf.entity.ActTargetConfigEntity;
import com.biz.eisp.activiti.designer.processconf.entity.ActTargetConfigProEntity;
import com.biz.eisp.activiti.designer.processconf.entity.ActTargetContentEntity;
import com.biz.eisp.activiti.designer.processconf.entity.ActTargetContentObjEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.vo.ActTargetConfigHeadVo;
import com.biz.eisp.activiti.entity.activiti.ActHiProcinstEntity;
import com.biz.eisp.activiti.entity.activiti.ActRuTaskEntity;
import com.biz.eisp.activiti.external.service.ActivitiApiService;
import com.biz.eisp.activiti.runtime.dao.ActHiProcinstDao;
import com.biz.eisp.activiti.runtime.dao.TaAttachmentDao;
import com.biz.eisp.activiti.runtime.dao.TaBaseBusinessObjDao;
import com.biz.eisp.activiti.runtime.dao.TaRuntimeStatusDao;
import com.biz.eisp.activiti.runtime.dao.TaTaskDao;
import com.biz.eisp.activiti.runtime.entity.TaAttachmentEntity;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjEntity;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjExtend;
import com.biz.eisp.activiti.runtime.entity.TaRuntimeStatusEntity;
import com.biz.eisp.activiti.runtime.service.TaBaseBusinessObjExtendService;
import com.biz.eisp.activiti.runtime.service.TaProcessInstanceService;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.vo.OperationVo;
import com.biz.eisp.activiti.runtime.vo.TaProcessApprovalLogVo;
import com.biz.eisp.api.feign.TmPositionFeign;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ActivitiBusinessVo;
import com.biz.eisp.base.utils.UUIDGenerator;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.util.ResourceService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class ActivitiApiServiceImpl
implements ActivitiApiService {
    @Autowired
    private TaBaseBusinessObjDao taBaseBusinessObjDao;
    @Autowired
    private TaProcessInstanceService taProcessInstanceService;
    @Autowired
    private ResourceService resource;
    @Autowired
    private TaProcessBusinessObjConfigService taProcessBusinessObjConfigService;
    @Autowired
    private TaRuntimeStatusDao taRuntimeStatusDao;
    @Autowired
    private TaTaskDao taskDao;
    @Autowired
    private TaTaskService taTaskService;
    @Autowired
    private TmPositionFeign tmPositionFeign;
    @Autowired
    private ActTargetContentDao actTargetContentDao;
    @Autowired
    private ActTargetContentObjDao actTargetContentObjDao;
    @Autowired
    private ActTargetConfigProDao actTargetConfigProDao;
    @Autowired
    private ActTargetConfigDao actTargetConfigDao;
    @Autowired
    private TaProcessDao taProcessDao;
    @Autowired
    private ActHiProcinstDao actHiProcinstDao;
    @Autowired
    private TaBaseBusinessObjExtendService taBaseBusinessObjExtendService;
    @Autowired
    private TaAttachmentDao taAttachmentDao;

    @Override
    public TaBaseBusinessObjEntity saveBusiness(ActivitiBusinessVo businessVo) {
        String processKey = businessVo.getProcessKey();
        String id = businessVo.getBusinessObjId();
        String processTitle = businessVo.getProcessTitle();
        TmPositionVo positionEntity = this.resource.getCurrPosition();
        TaProcessBusinessObjConfigEntity busConfig = this.taProcessBusinessObjConfigService.getConfigByProcessKey(businessVo.getClassName(), processKey);
        if (busConfig == null) {
            throw new BusinessException("\u672a\u914d\u7f6e\u4e1a\u52a1\u4e0e\u6d41\u7a0b\u5173\u8054\uff0c\u8bf7\u914d\u7f6e\u4e14\u91cd\u65b0\u53d1\u5e03");
        }
        TaRuntimeStatusEntity runtimeStatusEntity = this.taRuntimeStatusDao.getOneByCode(WorkFlowGlobals.RUNTIME_STATUS_NEW);
        TaBaseBusinessObjEntity baseEntity = new TaBaseBusinessObjEntity();
        baseEntity.setId(id);
        if (StringUtil.isNotEmpty((CharSequence)businessVo.getBusinessObjNum())) {
            baseEntity.setNum(businessVo.getBusinessObjNum());
        }
        baseEntity.setProcessBusiobjConfigId(busConfig.getId());
        baseEntity.setPositionId(positionEntity.getId());
        baseEntity.setRuntimeStatusId(runtimeStatusEntity.getId());
        baseEntity.setCreateTime(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        baseEntity.setProcessTitle(processTitle);
        baseEntity.setProcessDetail(businessVo.getProcessDetail());
        baseEntity.setPositionCode(positionEntity.getPositionCode());
        baseEntity.setPositionName(positionEntity.getPositionName());
        baseEntity.setUserName(this.resource.getUserVo().getUsername());
        baseEntity.setFullName(this.resource.getUserVo().getFullname());
        this.taBaseBusinessObjDao.insertSelective(baseEntity);
        return baseEntity;
    }

    @Override
    public String commitBusiness(ActivitiBusinessVo businessVo) {
        String businessUrl = businessVo.getBusinessUrl();
        businessVo.getVariables().put("submitPositionId", UserUtils.getUser().getPosId());
        String arrjson = businessVo.getTargetText();
        this.checkParams(businessVo);
        TaBaseBusinessObjEntity businessObjEntity = (TaBaseBusinessObjEntity)this.taBaseBusinessObjDao.selectByPrimaryKey(businessVo.getBusinessObjId());
        if (businessObjEntity == null) {
            businessObjEntity = this.saveBusiness(businessVo);
        } else if (!businessVo.getProcessKey().equals(businessObjEntity.getProcessKey())) {
            TaProcessBusinessObjConfigEntity busConfig = this.taProcessBusinessObjConfigService.getConfigByProcessKey(businessVo.getClassName(), businessVo.getProcessKey());
            if (busConfig == null) {
                throw new BusinessException("\u672a\u914d\u7f6e\u4e1a\u52a1\u4e0e\u6d41\u7a0b\u5173\u8054\uff0c\u8bf7\u914d\u7f6e\u4e14\u91cd\u65b0\u53d1\u5e03");
            }
            businessObjEntity.setProcessBusiobjConfigId(busConfig.getId());
            this.taBaseBusinessObjDao.updateByPrimaryKeySelective(businessObjEntity);
        }
        TaProcessBusinessObjConfigVo configVo = new TaProcessBusinessObjConfigVo();
        configVo.setId(businessObjEntity.getProcessBusiobjConfigId());
        configVo.setProcessKey(businessVo.getProcessKey());
        configVo.setBusinessObjId(businessVo.getBusinessObjId());
        configVo.setBusinessObjNum(businessVo.getBusinessObjNum());
        configVo.setVariables(businessVo.getVariables());
        String processInstanceId = this.taProcessInstanceService.saveStartWorkflow(configVo);
        ActTargetContentEntity actTargetContentEntity = new ActTargetContentEntity();
        if (StringUtil.isNotEmpty((CharSequence)processInstanceId)) {
            TaBaseBusinessObjExtend taBaseBusinessObjExtend = new TaBaseBusinessObjExtend();
            taBaseBusinessObjExtend.setProcessDetail(businessVo.getProcessDetail());
            taBaseBusinessObjExtend.setProcessInstanceId(processInstanceId);
            taBaseBusinessObjExtend.setProcessTitle(businessVo.getProcessTitle());
            taBaseBusinessObjExtend.setBusinessUrl(businessUrl);
            taBaseBusinessObjExtend.setFuncid(businessVo.getFuncid());
            taBaseBusinessObjExtend.setBizType(businessVo.getBizType());
            this.taBaseBusinessObjExtendService.insertSelective(taBaseBusinessObjExtend);
            actTargetContentEntity.setProcessInstanceId(processInstanceId);
            if (StringUtil.isNotEmpty((CharSequence)businessVo.getTargetTextWithHead())) {
                actTargetContentEntity.setTargetText(businessVo.getTargetTextWithHead());
                this.actTargetContentDao.insertSelective(actTargetContentEntity);
            } else {
                ActHiProcinstEntity actHiProcinstEntity = (ActHiProcinstEntity)this.actHiProcinstDao.selectByPrimaryKey(processInstanceId);
                String procDefId = actHiProcinstEntity.getProcDefId();
                Example example = new Example(ActTargetConfigProEntity.class);
                example.setOrderByClause("order_num ASC ");
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("procDefId", (Object)procDefId);
                List list = this.actTargetConfigProDao.selectByExample(example);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                    JSONObject object = new JSONObject();
                    Object oHead = JSONArray.toJSON((Object)list);
                    object.put("head", oHead);
                    JSONArray items = JSONArray.parseArray((String)arrjson);
                    object.put("items", (Object)items);
                    actTargetContentEntity.setTargetText(object.toJSONString());
                    this.actTargetContentDao.insertSelective(actTargetContentEntity);
                }
            }
            List attachmentVos = businessVo.getAttachmentVos();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)attachmentVos)) {
                ArrayList taAttachmentEntities = new ArrayList();
                attachmentVos.forEach(item -> {
                    TaAttachmentEntity attachment = new TaAttachmentEntity();
                    int index = item.getFileName().lastIndexOf(".");
                    String title = item.getFileName().substring(0, index);
                    attachment.setTaskId("");
                    attachment.setProcInstId(processInstanceId);
                    attachment.setBusinessKey(businessVo.getBusinessObjId());
                    attachment.setAttachmentTitle(title);
                    attachment.setUrlPath(item.getUrlPath());
                    attachment.setExtend(item.getExtend());
                    attachment.setRealPath(item.getRealPath());
                    attachment.setCreateDate(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                    attachment.setFileId(item.getFileId());
                    taAttachmentEntities.add(attachment);
                });
                this.taAttachmentDao.insertList(taAttachmentEntities);
            }
        }
        if (StringUtil.isNotBlank((CharSequence)processInstanceId)) {
            this.taTaskService.nullPosForJump(processInstanceId, new OperationVo());
        }
        return processInstanceId;
    }

    @Override
    public TaProcessApprovalLogVo getApprovalLog(String processInstanceId) {
        List<TaProcessApprovalLogVo> approvedList = this.taskDao.findLog(processInstanceId);
        return approvedList.get(approvedList.size() - 1);
    }

    @Override
    public TaProcessApprovalLogVo findApprovalUser(String businessObjId) {
        List<ActRuTaskEntity> actRuTaskList = this.taskDao.findActRuTaskEntityNewest(businessObjId);
        if (!CollectionUtil.listNotEmptyNotSizeZero(actRuTaskList)) {
            return null;
        }
        ActRuTaskEntity actRuTaskEntity = actRuTaskList.get(0);
        if (null == actRuTaskEntity || StringUtil.isEmpty((String)actRuTaskEntity.getProcInstId())) {
            return null;
        }
        List<TaProcessApprovalLogVo> approvalLogVos = this.findRuntimeApprovalList(actRuTaskEntity);
        if (!CollectionUtil.listNotEmptyNotSizeZero(approvalLogVos)) {
            return null;
        }
        return approvalLogVos.get(0);
    }

    @Override
    public ActTargetContentObjEntity getTargetHeadAndDefault(String processKey) throws Exception {
        ActTargetContentObjEntity result = new ActTargetContentObjEntity();
        Example example = new Example(ActTargetConfigEntity.class);
        example.setOrderByClause("order_num ASC ");
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("processId", (Object)this.getProcessIdByKey(processKey));
        List list = this.actTargetConfigDao.selectByExample(example);
        JSONArray head = new JSONArray();
        JSONArray items = new JSONArray();
        JSONObject object = new JSONObject();
        for (ActTargetConfigEntity entity : list) {
            ActTargetConfigHeadVo vo = new ActTargetConfigHeadVo();
            MyBeanUtils.copyBeanNotNull2Bean((Object)entity, (Object)vo);
            object.put(entity.getFiled(), (Object)entity.getDefaultValue());
            Object obj = JSONArray.toJSON((Object)vo);
            head.add(obj);
        }
        items.add((Object)object);
        result.setHeadTarget(head.toJSONString());
        result.setItemTarget(items.toJSONString());
        result.setProcessKey(processKey);
        return result;
    }

    @Override
    public ActTargetContentObjEntity getTargets(String businessObjId, String processKey) {
        ActTargetContentObjEntity queryEntity = new ActTargetContentObjEntity();
        queryEntity.setBusinessObjId(businessObjId);
        queryEntity.setProcessKey(processKey);
        ActTargetContentObjEntity resultEntity = (ActTargetContentObjEntity)this.actTargetContentObjDao.selectOne(queryEntity);
        return resultEntity;
    }

    @Override
    public void saveActTargets(ActTargetContentObjEntity entity) {
        Example example = new Example(ActTargetContentObjEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("businessObjId", (Object)entity.getBusinessObjId());
        criteria.andEqualTo("processKey", (Object)entity.getProcessKey());
        this.actTargetContentObjDao.deleteByExample(example);
        entity.setId(UUIDGenerator.generate());
        this.actTargetContentObjDao.insertSelective(entity);
    }

    private String getProcessIdByKey(String processKey) {
        TaProcessEntity taProcessEntity = new TaProcessEntity();
        taProcessEntity.setProcessKey(processKey);
        TaProcessEntity process = (TaProcessEntity)this.taProcessDao.selectOne(taProcessEntity);
        return process.getId();
    }

    private List<TaProcessApprovalLogVo> findRuntimeApprovalList(ActRuTaskEntity actRuTaskEntity) {
        List<TaProcessApprovalLogVo> voList = this.taskDao.findRuntimeApprovalList(actRuTaskEntity.getProcInstId());
        if (CollectionUtil.listNotEmptyNotSizeZero(voList)) {
            for (TaProcessApprovalLogVo vo : voList) {
                TmPositionVo positionVo = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getUserAndPositionInfoByPosCodes(vo.getAssignees()), (boolean)true);
                vo.setRoleName(positionVo.getPositionNames());
                vo.setAccount(positionVo.getUserNames());
                vo.setName(positionVo.getFullNames());
                vo.setType("\u5f85\u5ba1\u6279");
            }
        }
        return voList;
    }

    private void checkParams(ActivitiBusinessVo businessVo) {
        Assert.hasText((String)businessVo.getBusinessObjId(), (String)"\u4e1a\u52a1\u5bf9\u8c61ID\u672a\u63d0\u4f9b");
        Assert.hasText((String)businessVo.getProcessKey(), (String)"\u6d41\u7a0bKEY\u672a\u63d0\u4f9b");
        Assert.hasText((String)businessVo.getClassName(), (String)"\u4e1a\u52a1\u5b9e\u4f53\u540d\u79f0\u672a\u63d0\u4f9b");
    }
}

