/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.dingtalk.service.impl;

import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.vo.DingtalkTodoAddReqVo;
import com.biz.eisp.activiti.vo.DingtalkTodoUpdateReqVo;
import com.biz.eisp.api.feign.TmUserFeign;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.SysParamUtil;
import com.biz.eisp.dingtalk.base.AccessToken;
import com.biz.eisp.dingtalk.service.ActDingtalkTodoLogService;
import com.biz.eisp.dingtalk.service.DingtalkTodoService;
import com.biz.eisp.dingtalk.service.DingtalkUserService;
import com.biz.eisp.dingtalk.service.entity.ActDingtalkTodoLogEntity;
import com.biz.eisp.dingtalk.service.entity.DingtalkTodoInfoEntity;
import com.biz.eisp.dingtalk.service.vo.ActDingtalkTodoLogVo;
import com.biz.eisp.dingtalk.utils.DingtalkConfigurer;
import com.biz.eisp.parameter.entity.KnlParameterManageEntity;
import com.biz.eisp.tk.utils.BeanCopyUtils;
import com.biz.eisp.user.TmUserQueryVo;
import com.biz.eisp.user.TmUserVo;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiWorkrecordAddRequest;
import com.dingtalk.api.request.OapiWorkrecordUpdateRequest;
import com.dingtalk.api.response.OapiWorkrecordAddResponse;
import com.dingtalk.api.response.OapiWorkrecordUpdateResponse;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.CollectionUtils;

@Service
@Transactional
public class DingtalkTodoServiceImpl
implements DingtalkTodoService {
    private static final Logger log = LoggerFactory.getLogger(DingtalkTodoServiceImpl.class);
    private static final String ON = "ON";
    private static final String OFF = "OFF";
    @Autowired
    private DingtalkConfigurer dingtalkConfigurer;
    @Autowired
    private AccessToken accessToken;
    @Autowired
    private DingtalkUserService dingtalkUserService;
    @Autowired
    private TmUserFeign tmUserFeign;
    @Autowired
    private ActDingtalkTodoLogService actDingtalkTodoLogService;
    @Autowired
    private TaTaskService taTaskService;

    private boolean dingtalkTodoIsOn() {
        KnlParameterManageEntity knlParameterManageEntity = SysParamUtil.getPatamByCode((String)"dingtalk_todo_onoff");
        if (null == knlParameterManageEntity) {
            log.warn("\u672a\u83b7\u53d6\u5230\u9489\u9489\u5f85\u529e\u63a5\u53e3\u5f00\u5173\u53c2\u6570\uff1adingtalk_todo_onoff");
            return false;
        }
        if (!ON.equals(knlParameterManageEntity.getParameterValue())) {
            log.warn("\u9489\u9489\u5f85\u529e\u63a5\u53e3\u672a\u5f00\u542f\uff0c\u5df2\u5ffd\u7565\u672c\u6b21\u8bf7\u6c42\uff0c\u7cfb\u7edf\u53c2\u6570\uff1adingtalk_todo_onoff={}", (Object)knlParameterManageEntity.getParameterValue());
            return false;
        }
        return true;
    }

    private String jumpUrl(DingtalkTodoAddReqVo reqVo) {
        KnlParameterManageEntity knlParameterManageEntity = SysParamUtil.getPatamByCode((String)"dingtalk_todo_url");
        if (null == knlParameterManageEntity) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u9489\u9489\u5f85\u529e\u8df3\u8f6c\u8def\u5f84\u53c2\u6570\uff1adingtalk_todo_url");
        }
        String url = knlParameterManageEntity.getParameterValue();
        if (StringUtil.isBlank((CharSequence)url)) {
            throw new BusinessException("\u9489\u9489\u5f85\u529e\u8df3\u8f6c\u8def\u5f84 dingtalk_todo_url \u672a\u6b63\u786e\u914d\u7f6e\uff0c\u5df2\u5ffd\u7565\u672c\u6b21\u8bf7\u6c42\u3002");
        }
        String param = null;
        param = url.indexOf("?") > 0 ? "&" : "?";
        param = param + "processInstanceId=" + reqVo.getProcessInstanceId();
        if (StringUtil.isNotBlank((CharSequence)reqVo.getTaskId())) {
            param = param + "&taskId=" + reqVo.getTaskId();
        }
        param = param + "&userName=" + reqVo.getUserName();
        param = param + "&timestamp=" + System.currentTimeMillis();
        return url + param;
    }

    @Override
    public void updateTodoByProcessInstanceId(String processInstanceId) {
        if (StringUtil.isBlank((CharSequence)processInstanceId)) {
            return;
        }
        DingtalkTodoUpdateReqVo reqVo = new DingtalkTodoUpdateReqVo();
        reqVo.setProcessInstanceId(processInstanceId);
        List<ActDingtalkTodoLogEntity> logs = this.deleteLogs(reqVo);
        if (CollectionUtil.listEmpty(logs)) {
            return;
        }
        this.invocDingtalkUpdate(logs);
    }

    @Override
    public void updateTodo(DingtalkTodoUpdateReqVo reqVo) {
        List<ActDingtalkTodoLogEntity> logs = this.deleteLogs(reqVo);
        if (CollectionUtil.listEmpty(logs)) {
            return;
        }
        this.invocDingtalkUpdate(logs);
    }

    private void invocDingtalkUpdate(List<ActDingtalkTodoLogEntity> logs) {
        HashSet success = Sets.newHashSet();
        Map<String, ActDingtalkTodoLogEntity> map = null;
        try {
            map = logs.stream().collect(Collectors.toMap(ActDingtalkTodoLogEntity::getId, v -> v, (t, t2) -> t2));
            for (Map.Entry<String, ActDingtalkTodoLogEntity> entry : map.entrySet()) {
                this.doUpdateTodo(entry.getValue());
                success.add(entry.getKey());
            }
        }
        catch (Exception e) {
            this.rollbackFails(success, map);
            log.error("\u66f4\u65b0\u9489\u9489\u5f85\u529e\u5931\u8d25>>>>", (Throwable)e);
        }
    }

    private void rollbackFails(Set<String> success, Map<String, ActDingtalkTodoLogEntity> map) {
        ArrayList rollback = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(map)) {
            map.forEach((key, item) -> {
                if (!success.contains(key)) {
                    rollback.add(item);
                }
            });
        }
        this.actDingtalkTodoLogService.saveList(rollback);
    }

    private void doUpdateTodo(ActDingtalkTodoLogEntity actDingtalkTodoEntity) {
        DefaultDingTalkClient client = new DefaultDingTalkClient(this.dingtalkConfigurer.getTodoUpdateUrl());
        OapiWorkrecordUpdateRequest req = new OapiWorkrecordUpdateRequest();
        req.setUserid(actDingtalkTodoEntity.getDingtalkUserId());
        req.setRecordId(actDingtalkTodoEntity.getTodoId());
        try {
            OapiWorkrecordUpdateResponse response = (OapiWorkrecordUpdateResponse)client.execute((TaobaoRequest)req, this.accessToken.getAccessToken());
            if (response.getErrcode().equals(0L)) {
                return;
            }
            throw new BusinessException("\u66f4\u65b0\u9489\u9489\u5f85\u529e\u6d88\u606f\u5f02\u5e38," + response.getErrmsg());
        }
        catch (ApiException e) {
            throw new BusinessException("\u66f4\u65b0\u9489\u9489\u5f85\u529e\u6d88\u606f\u5f02\u5e38, \u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
        }
    }

    private List<ActDingtalkTodoLogEntity> deleteLogs(DingtalkTodoUpdateReqVo reqVo) {
        try {
            if (!this.dingtalkTodoIsOn()) {
                return null;
            }
            if (null == reqVo) {
                return null;
            }
            return this.doDeleteLogs(reqVo);
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            log.error("\u66f4\u65b0\u9489\u9489\u5f85\u529e\u5931\u8d25>>>>", (Throwable)e);
            return null;
        }
    }

    private List<ActDingtalkTodoLogEntity> doDeleteLogs(DingtalkTodoUpdateReqVo reqVo) {
        List<ActDingtalkTodoLogEntity> actDingtalkTodoEntity = this.loadActDingtalkTodoEntity(reqVo);
        if (!CollectionUtils.isEmpty(actDingtalkTodoEntity)) {
            this.actDingtalkTodoLogService.deleteEntity(actDingtalkTodoEntity.stream().map(ActDingtalkTodoLogEntity::getId).collect(Collectors.toSet()));
        }
        return actDingtalkTodoEntity;
    }

    private List<ActDingtalkTodoLogEntity> loadActDingtalkTodoEntity(DingtalkTodoUpdateReqVo reqVo) {
        String processInstanceId = reqVo.getProcessInstanceId();
        String taskId = reqVo.getTaskId();
        String userName = reqVo.getUserName();
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            return Lists.newArrayList();
        }
        List<ActDingtalkTodoLogEntity> actDingtalkTodoEntity = this.actDingtalkTodoLogService.findEntity(processInstanceId, taskId, userName);
        return actDingtalkTodoEntity;
    }

    @Override
    public void addDingtalkTodo(DingtalkTodoAddReqVo reqVo) {
        try {
            this.checkDingtalkTodoAddReqVo(reqVo);
            if (!this.dingtalkTodoIsOn()) {
                return;
            }
            if (null == reqVo) {
                return;
            }
            this.loadMobile(reqVo);
            if (StringUtil.isBlank((CharSequence)reqVo.getUserMobile())) {
                return;
            }
            DingtalkTodoInfoEntity todo = this.buildParamAndAddTodo(reqVo);
            this.saveTodoLog(reqVo, todo);
        }
        catch (BusinessException e) {
            log.error("\u66f4\u65b0\u9489\u9489\u5f85\u529e\u5931\u8d25>>>>", (Object)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u9489\u9489\u5f85\u529e\u5931\u8d25>>>>", (Throwable)e);
        }
    }

    private void checkDingtalkTodoAddReqVo(DingtalkTodoAddReqVo reqVo) {
        if (StringUtil.isBlank((CharSequence)reqVo.getUserName())) {
            throw new BusinessException("\u672a\u6307\u5b9a\u7528\u6237\u767b\u9646\u8d26\u53f7\uff0c\u5ffd\u7565\u672c\u6b21\u8bf7\u6c42\uff01");
        }
    }

    private void loadMobile(DingtalkTodoAddReqVo reqVo) {
        String mobile = reqVo.getUserMobile();
        if (StringUtil.isBlank((CharSequence)mobile)) {
            TmUserQueryVo tmUserQueryVo = new TmUserQueryVo();
            tmUserQueryVo.setUsername(reqVo.getUserName());
            TmUserVo userVo = (TmUserVo)this.tmUserFeign.getTmUser(tmUserQueryVo).getObj();
            mobile = userVo.getMobilephone();
            reqVo.setUserMobile(mobile);
        }
    }

    private void saveTodoLog(DingtalkTodoAddReqVo reqVo, DingtalkTodoInfoEntity todo) {
        ActDingtalkTodoLogVo vo = new ActDingtalkTodoLogVo();
        vo.setProcessInstanceId(reqVo.getProcessInstanceId());
        vo.setTaskId(reqVo.getTaskId());
        vo.setUserPositionCode(reqVo.getUserPositionCode());
        vo.setUserName(reqVo.getUserName());
        vo.setMobile(reqVo.getUserMobile());
        vo.setDingtalkUserId(todo.getUserid());
        vo.setTodoId(todo.getTodoId());
        this.actDingtalkTodoLogService.saveList(Lists.newArrayList((Object[])new ActDingtalkTodoLogEntity[]{(ActDingtalkTodoLogEntity)BeanCopyUtils.copyToBean((Object)vo, ActDingtalkTodoLogEntity.class)}));
    }

    private DingtalkTodoInfoEntity buildParamAndAddTodo(DingtalkTodoAddReqVo reqVo) {
        String url = this.jumpUrl(reqVo);
        String userid = this.dingtalkUserService.getUserIdByMobile(reqVo.getUserMobile());
        DingtalkTodoInfoEntity todo = new DingtalkTodoInfoEntity();
        todo.setCreateTime(System.currentTimeMillis());
        todo.setTitle(reqVo.getTitle());
        todo.setUserid(userid);
        DingtalkTodoInfoEntity.FormItem formItem = new DingtalkTodoInfoEntity.FormItem();
        formItem.setTitle(reqVo.getFormTitle());
        formItem.setContent(reqVo.getFormContent());
        todo.setFormItemObjList(Lists.newArrayList((Object[])new DingtalkTodoInfoEntity.FormItem[]{formItem}));
        todo.setUrl(url + "&pc=false");
        todo.setPcUrl(url + "&pc=true");
        todo = this.doAddTodo(todo);
        return todo;
    }

    private DingtalkTodoInfoEntity doAddTodo(DingtalkTodoInfoEntity todo) {
        this.todoInfoEntityCheck(todo);
        DefaultDingTalkClient client = new DefaultDingTalkClient(this.dingtalkConfigurer.getTodoAddUrl());
        OapiWorkrecordAddRequest req = (OapiWorkrecordAddRequest)BeanCopyUtils.copyToBean((Object)todo, OapiWorkrecordAddRequest.class);
        List formItemVos = BeanCopyUtils.copyToBeanList(todo.getFormItemObjList(), OapiWorkrecordAddRequest.FormItemVo.class);
        req.setFormItemList(formItemVos);
        try {
            OapiWorkrecordAddResponse response = (OapiWorkrecordAddResponse)client.execute((TaobaoRequest)req, this.accessToken.getAccessToken());
            if (response.getErrcode().equals(0L)) {
                todo.setTodoId(response.getRecordId());
                return todo;
            }
            throw new BusinessException("\u83b7\u53d6\u9489\u9489\u90e8\u95e8\u4fe1\u606f\u5f02\u5e38," + response.getErrmsg());
        }
        catch (ApiException e) {
            throw new BusinessException("\u83b7\u53d6\u9489\u9489\u90e8\u95e8\u4fe1\u606f\u5f02\u5e38, \u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
        }
    }

    private void todoInfoEntityCheck(DingtalkTodoInfoEntity todo) {
        if (StringUtils.isBlank((CharSequence)todo.getUserid())) {
            throw new BusinessException("\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == todo.getCreateTime()) {
            throw new BusinessException("\u5f85\u529e\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)todo.getTitle())) {
            throw new BusinessException("\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (todo.getTitle().length() > 50) {
            throw new BusinessException("\u6807\u9898\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\uff01");
        }
        List<DingtalkTodoInfoEntity.FormItem> formItems = todo.getFormItemObjList();
        if (CollectionUtils.isEmpty(formItems)) {
            throw new BusinessException("\u5f85\u529e\u4e8b\u9879\u8868\u5355\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        formItems.stream().forEach(item -> {
            if (StringUtils.isBlank((CharSequence)item.getTitle())) {
                throw new BusinessException("\u8868\u5355\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)item.getContent())) {
                throw new BusinessException("\u8868\u5355\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        });
    }
}

