/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processcheck.batchck;

import com.biz.eisp.activiti.designer.processcheck.batchck.BatchCheckProDeal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchCheckProThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(BatchCheckProThread.class);
    private BatchCheckProDeal deal;
    private int batchSize = 5;

    public BatchCheckProThread(BatchCheckProDeal deal) {
        this.deal = deal;
    }

    @Override
    public void run() {
        List<String> users;
        while ((users = this.deal.getUsers()) != null) {
            int batchNum = users.size() % this.batchSize == 0 ? users.size() / this.batchSize : users.size() / this.batchSize + 1;
            for (int i = 0; i < batchNum; ++i) {
                int startNum = i * this.batchSize;
                int endNum = startNum + this.batchSize;
                endNum = endNum > users.size() ? users.size() : endNum;
                try {
                    this.deal.batchChecks(users.subList(startNum, endNum));
                    continue;
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        }
    }
}

