/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processcheck.service.impl;

import com.biz.eisp.activiti.TaProcessFeign;
import com.biz.eisp.activiti.designer.processcheck.dao.TaProcessCheckBatchDao;
import com.biz.eisp.activiti.designer.processcheck.dao.TaProcessCheckDetailDao;
import com.biz.eisp.activiti.designer.processcheck.dao.TaProcessCheckRecordDao;
import com.biz.eisp.activiti.designer.processcheck.entity.TaProcessCheckBatch;
import com.biz.eisp.activiti.designer.processcheck.entity.TaProcessCheckDetail;
import com.biz.eisp.activiti.designer.processcheck.entity.TaProcessCheckRecord;
import com.biz.eisp.activiti.designer.processcheck.service.TaProcessCheckService;
import com.biz.eisp.activiti.designer.processcheck.vo.ProcCkQuerySetVo;
import com.biz.eisp.activiti.designer.processcheck.vo.TaProcessCkRecordVo;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessDao;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeProEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.runtime.dao.ActRuTaskDao;
import com.biz.eisp.activiti.util.EhcacheUtil;
import com.biz.eisp.activiti.util.JsonUtil;
import com.biz.eisp.api.feign.TmPositionFeign;
import com.biz.eisp.api.feign.TmUserFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.user.TmUserQueryVo;
import com.biz.eisp.user.TmUserVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="taProcessCheckService")
@Transactional
public class TaProcessCheckServiceImpl
implements TaProcessCheckService {
    private static final Logger log = LoggerFactory.getLogger(TaProcessCheckServiceImpl.class);
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private TaProcessNodeService taProcessNodeService;
    @Autowired
    private TaProcessFeign taProcessFeign;
    @Autowired
    TaProcessCheckDetailDao taProcessCheckDetailDao;
    @Autowired
    TaProcessCheckRecordDao taProcessCheckRecordDao;
    @Autowired
    ActRuTaskDao actRuTaskDao;
    @Autowired
    private TaProcessDao taProcessDao;
    @Autowired
    private TaProcessCheckBatchDao taProcessCheckBatchDao;
    @Autowired
    private TmPositionFeign tmPositionFeign;
    @Autowired
    private TmUserFeign tmUserFeign;

    @Override
    public TaProcessCkRecordVo createProcessCheck(String processKey) throws Exception {
        TaProcessEntity process = new TaProcessEntity();
        AjaxJson ajaxJson = this.taProcessFeign.getTaProcessEntityByProcessKey((List)Lists.newArrayList((Object[])new String[]{processKey}));
        List taProcessEntities = ajaxJson.getObjList();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)taProcessEntities)) {
            process = (TaProcessEntity)taProcessEntities.get(0);
        }
        TaProcessCkRecordVo vo = new TaProcessCkRecordVo();
        String processId = process.getId();
        vo.setProcessId(processId);
        vo.setState("0");
        vo.setIsBatchUser(Integer.valueOf(0));
        vo.setTitle(process.getProcessName() + "_\u68c0\u6d4b\u62a5\u544a");
        ArrayList<TaProcessCheckDetail> ckPassDetails = new ArrayList<TaProcessCheckDetail>();
        TaProcessCheckDetail ckd = new TaProcessCheckDetail();
        ckd.setCheckType("PASS");
        ckd.setNodeName("\u53d1\u8d77");
        ckd.setNodeKey("TO_START");
        ckd.setState("0");
        ckPassDetails.add(ckd);
        Process proc = this.getActProcess(process.getProcessKey());
        Collection flowElements = proc.getFlowElements();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof UserTask)) continue;
            ckd = new TaProcessCheckDetail();
            ckd.setCheckType("PASS");
            ckd.setNodeName(flowElement.getName());
            ckd.setNodeKey(flowElement.getId());
            ckd.setState("0");
            ckPassDetails.add(ckd);
        }
        vo.setCkPassDetails(ckPassDetails);
        EhcacheUtil.putItem("PRO_CK_" + processId, vo);
        this.delNoCkRecordAndDetails(processId, process.getProcessKey());
        return vo;
    }

    private void delNoCkRecordAndDetails(String processId, String procKey) {
        TaProcessCkRecordVo vo = new TaProcessCkRecordVo();
        vo.setProcessId(processId);
        vo.setState("0");
        List<TaProcessCkRecordVo> list = this.getCkRecords(vo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            for (TaProcessCkRecordVo t : list) {
                List<TaProcessCheckDetail> list1 = this.findCheckDetails(t.getId());
                if (CollectionUtil.listNotEmptyNotSizeZero(list1)) {
                    list1.forEach(item -> this.taProcessCheckDetailDao.delete(item));
                }
                this.taProcessCheckRecordDao.deleteByPrimaryKey(t.getId());
            }
        }
        List tasks = this.taskService.createTaskQuery().processDefinitionKey(procKey).processVariableValueEquals("FROM_TYPE", (Object)"PROCESS_PASS_CHECK").list();
        for (Task task : tasks) {
            this.actRuTaskDao.deleteByPrimaryKey(task.getId());
        }
    }

    @Override
    public List<TaProcessCkRecordVo> getCkRecords(TaProcessCkRecordVo vo) {
        List list;
        Example example = new Example(TaProcessCheckRecord.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotEmpty((CharSequence)vo.getProcessId())) {
            criteria.andEqualTo("processId", (Object)vo.getProcessId());
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getState())) {
            criteria.andEqualTo("state", (Object)vo.getState());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(list = this.taProcessCheckRecordDao.selectByExample(example)))) {
            return list.stream().map(old -> {
                TaProcessCkRecordVo taProcessCkRecordVo = new TaProcessCkRecordVo();
                BeanUtils.copyProperties((Object)old, (Object)taProcessCkRecordVo);
                return taProcessCkRecordVo;
            }).collect(Collectors.toList());
        }
        return new ArrayList<TaProcessCkRecordVo>();
    }

    @Override
    public String saveRecord(String processId, String proCkQuerySet) throws Exception {
        TaProcessCkRecordVo vo = (TaProcessCkRecordVo)EhcacheUtil.getItem("PRO_CK_" + processId);
        TaProcessCheckRecord entity = new TaProcessCheckRecord();
        entity.setCheckTime(DateUtils.getFormatDateStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        entity.setProcessId(vo.getProcessId());
        entity.setState(vo.getState());
        entity.setTitle(vo.getTitle());
        entity.setIsBatchUser(vo.getIsBatchUser());
        entity.setCkParams(proCkQuerySet);
        this.taProcessCheckRecordDao.insertSelective(entity);
        for (TaProcessCheckDetail detail : vo.getCkPassDetails()) {
            detail.setRecordId(entity.getId());
            this.taProcessCheckDetailDao.insertSelective(detail);
        }
        EhcacheUtil.removeItem("PRO_CK_" + processId);
        return entity.getId();
    }

    @Override
    public TaProcessCheckDetail passCkReq(TaProcessCheckDetail detail) throws Exception {
        if (detail != null) {
            detail = detail.getNodeKey().equals("TO_START") ? this.passStarPro(detail) : this.passProNode(detail);
        } else {
            throw new Exception("\u672a\u627e\u5230\u8be5\u68c0\u6d4b\u8bb0\u5f55\u9879");
        }
        return detail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaProcessCheckDetail passProNode(TaProcessCheckDetail detail) throws Exception {
        detail.setCheckTime(DateUtils.getFormatDateStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        StringBuffer ckDetail = new StringBuffer();
        String oldCkResult = "";
        if (StringUtils.isNotEmpty((CharSequence)detail.getCheckResult())) {
            oldCkResult = detail.getCheckResult();
        }
        try {
            TaProcessCheckRecord record = (TaProcessCheckRecord)this.taProcessCheckRecordDao.selectByPrimaryKey(detail.getRecordId());
            if (record == null) {
                throw new Exception("\u672a\u627e\u5230\u68c0\u6d4b\u8bb0\u5f55");
            }
            TaProcessEntity process = (TaProcessEntity)this.taProcessDao.selectByPrimaryKey(record.getProcessId());
            if (process == null) {
                throw new Exception("\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f53");
            }
            TaProcessCheckDetail startDetail = this.findCheckDetail("TO_START", record.getId());
            List tasks = this.taskService.createTaskQuery().processInstanceId(startDetail.getProcessInsId()).taskDefinitionKey(detail.getNodeKey()).list();
            int taskSize = tasks.size();
            ckDetail.append("<p>\u68c0\u6d4b\u51fa\u8be5\u8282\u70b9\u4ea7\u751f\u4e86" + taskSize + "\u4e2a\u4efb\u52a1</p>");
            int index = 1;
            for (Task task : tasks) {
                ckDetail.append("<p>\u5f00\u59cb\u5904\u7406\u7b2c" + index + "\u4e2a\u4efb\u52a1...</p>");
                ckDetail = this.completeTask(task, ckDetail);
                ckDetail.append("<p>\u5904\u7406\u7b2c" + index + "\u4e2a\u4efb\u52a1\u7ed3\u675f...</p>");
                ++index;
            }
            detail.setState("1");
            detail.setProcessInsId(startDetail.getProcessInsId());
            detail.setCheckResult(oldCkResult + ckDetail.toString() + "<p>\u8282\u70b9\u901a\u8fc7\u68c0\u6d4b\u6210\u529f!</p>");
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ckDetail.append("<p><span style=\"color:red\">\u8282\u70b9\u901a\u8fc7\u68c0\u6d4b\u5931\u8d25!</span></p>");
            String msg = e.getMessage();
            if (StringUtils.isEmpty((CharSequence)msg)) {
                msg = "\u672a\u77e5\u9519\u8bef\uff0c\u65e5\u5fd7\u672a\u88ab\u6355\u83b7\u3002";
            }
            ckDetail.append("<p><span style=\"color:red\">\u9519\u8bef\u65e5\u5fd7\uff1a" + msg + "</span></p>");
            detail.setState("2");
            detail.setCheckResult(oldCkResult + ckDetail.toString());
        }
        finally {
            detail.setCheckResult(detail.getCheckResult() + "<p>-----------------------------------------</p>");
            return detail;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StringBuffer completeTask(Task task, StringBuffer ckDetail) throws Exception {
        boolean toComplete = true;
        String taskKey = task.getTaskDefinitionKey();
        String processKey = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(task.getProcessDefinitionId()).singleResult()).getKey();
        TaProcessNodeProEntity node = this.taProcessNodeService.getTaProcessNodeByVersionKey(task.getProcessDefinitionId(), taskKey);
        if (node == null) {
            throw new RuntimeException("\u8282\u70b9\u8868\u4e2d\u672a\u627e\u5230\u8be5\u8282\u70b9\uff01");
        }
        Map variables = this.runtimeService.getVariables(task.getExecutionId());
        String proStartPosiCode = (String)variables.get("proStartPosiCode");
        TmPositionVo vo = this.getPositionVoInfo(proStartPosiCode);
        TmPositionVo currVo = null;
        if (task.getTaskDefinitionKey().equals("DEFAULT_START")) {
            ckDetail.append("<p>\u4efb\u52a1\u5904\u7406\u4eba\uff1a[" + vo.getUserName() + "]" + vo.getFullname()).append("\u3001\u804c\u4f4d[" + vo.getPositionCode() + "]" + vo.getPositionName() + "</p>");
        } else if (StringUtils.isEmpty((CharSequence)task.getAssignee())) {
            List identityLinkList = this.taskService.getIdentityLinksForTask(task.getId());
            if (!CollectionUtil.listNotEmptyNotSizeZero((List)identityLinkList)) throw new RuntimeException("\u8282\u70b9\u4efb\u52a1\u7684[assignee]\u5ba1\u6279\u4eba\u5b57\u6bb5\u4e3a\u7a7a\uff01");
            for (IdentityLink identityLink : identityLinkList) {
                if (!StringUtils.isNotBlank((CharSequence)identityLink.getUserId())) continue;
                currVo = this.getPositionVoInfo(identityLink.getUserId());
                if (currVo == null) {
                    throw new RuntimeException("\u6839\u636e\u4efb\u52a1\u6267\u884c\u804c\u4f4d[" + task.getAssignee() + "]\u67e5\u8be2\u804c\u4f4d\u6570\u636e\u4e3a\u7a7a\uff01");
                }
                ckDetail.append("<p>\u4efb\u52a1\u5904\u7406\u4eba\uff1a[" + currVo.getUserName() + "]" + currVo.getFullname()).append("\u3001\u804c\u4f4d[" + currVo.getPositionCode() + "]" + currVo.getPositionName() + "</p>");
            }
        } else {
            currVo = this.getPositionVoInfo(task.getAssignee());
            if (currVo == null) {
                throw new RuntimeException("\u6839\u636e\u4efb\u52a1\u6267\u884c\u804c\u4f4d[" + task.getAssignee() + "]\u67e5\u8be2\u804c\u4f4d\u6570\u636e\u4e3a\u7a7a\uff01");
            }
            ckDetail.append("<p>\u4efb\u52a1\u5904\u7406\u4eba\uff1a[" + currVo.getUserName() + "]" + currVo.getFullname()).append("\u3001\u804c\u4f4d[" + currVo.getPositionCode() + "]" + currVo.getPositionName() + "</p>");
        }
        if (!toComplete) return ckDetail;
        this.taskService.complete(task.getId());
        return ckDetail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaProcessCheckDetail passStarPro(TaProcessCheckDetail detail) throws Exception {
        detail.setCheckTime(DateUtils.getFormatDateStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        TaProcessCheckRecord record = (TaProcessCheckRecord)this.taProcessCheckRecordDao.selectByPrimaryKey(detail.getRecordId());
        if (record == null) {
            throw new Exception("\u672a\u627e\u5230\u68c0\u6d4b\u8bb0\u5f55");
        }
        TaProcessEntity process = (TaProcessEntity)this.taProcessDao.selectByPrimaryKey(record.getProcessId());
        if (process == null) {
            throw new Exception("\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f53");
        }
        String authenticatedUser = "";
        StringBuffer ckDetail = new StringBuffer();
        try {
            HashMap<String, Object> variables = this.getCkParams(record.getCkParams());
            variables.put("FROM_TYPE", "PROCESS_PASS_CHECK");
            authenticatedUser = (String)variables.get("proStartUserName");
            if (StringUtils.isEmpty((CharSequence)authenticatedUser)) {
                authenticatedUser = "admin";
                variables.put("proStartUserName", "admin");
                ckDetail.append("<p>\u672a\u8bbe\u7f6e\u53d1\u8d77\u4eba\u8d26\u53f7\uff0c\u9ed8\u8ba4\u91c7\u7528[" + authenticatedUser + "]\u53bb\u6267\u884c\u6d41\u7a0b\u53d1\u8d77\uff1b</p>");
            } else {
                ckDetail.append("<p>\u91c7\u7528\u8bbe\u7f6e\u7684\u53d1\u8d77\u4eba\u8d26\u53f7[" + authenticatedUser + "]\u53bb\u6267\u884c\u6d41\u7a0b\u53d1\u8d77\uff1b</p>");
            }
            TmUserVo user = this.getUserVo(authenticatedUser);
            if (user == null) {
                ckDetail.append("<p><span style=\"color:red\">\u6839\u636e\u53d1\u8d77\u4eba\u8d26\u53f7[" + authenticatedUser + "]\u672a\u627e\u5230\u5bf9\u5e94\u7528\u6237;</span></p>");
                throw new Exception("");
            }
            AjaxJson ajaxJson = this.tmPositionFeign.getPosition(user.getPosId(), "");
            TmPositionVo vo = (TmPositionVo)ajaxJson.getObj();
            if (vo == null) {
                ckDetail.append("<p><span style=\"color:red\">\u672a\u627e\u5230\u53d1\u8d77\u4eba\u5bf9\u5e94\u804c\u4f4d;</span></p>");
                throw new Exception("");
            }
            ckDetail.append("<p>\u53d1\u8d77\u4eba\u4fe1\u606f\uff1a[" + authenticatedUser + "]" + user.getFullname()).append("\uff0c\u804c\u4f4d[" + vo.getPositionCode() + "]" + vo.getPositionName() + "\uff1b</p>");
            variables.put("proStartPosiCode", vo.getPositionCode());
            this.identityService.setAuthenticatedUserId(authenticatedUser);
            String bussId = UUID.randomUUID().toString().replace("-", "");
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(process.getProcessKey(), bussId, variables);
            ckDetail.append("<p>\u6210\u529f\u53d1\u8d77\u4e86\u6d41\u7a0b\uff0c\u53d1\u8d77\u68c0\u6d4b\u6210\u529f!</p>");
            detail.setState("1");
            detail.setProcessInsId(processInstance.getProcessInstanceId());
            detail.setCheckResult(ckDetail.toString());
        }
        catch (Exception e) {
            ckDetail.append("<p><span style=\"color:red\">\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25!</span></p>");
            String msg = e.getMessage();
            if (StringUtils.isEmpty((CharSequence)msg)) {
                msg = "\u672a\u77e5\u9519\u8bef\uff0c\u65e5\u5fd7\u672a\u88ab\u6355\u83b7\u3002";
            } else if (msg.length() > 500) {
                msg = msg.substring(0, 500) + "...";
            }
            ckDetail.append("<p><span style=\"color:red\">\u9519\u8bef\u65e5\u5fd7\uff1a" + msg + "</span></p>");
            detail.setState("2");
            detail.setCheckResult(ckDetail.toString());
        }
        finally {
            detail.setCheckResult(detail.getCheckResult() + "<p>-----------------------------------------</p>");
            return detail;
        }
    }

    @Override
    public HashMap<String, Object> getCkParams(String json) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)json)) {
            HashMap jsonMap = (HashMap)JsonUtil.jsonToObject(json, Object.class);
            for (Map.Entry entry : jsonMap.entrySet()) {
                if ("proStartUserName".equals(entry.getKey())) {
                    result.put("proStartUserName", entry.getValue());
                    continue;
                }
                if ("title".equals(entry.getKey())) {
                    result.put("title", entry.getValue());
                    continue;
                }
                if ("isBatchUser".equals(entry.getKey())) {
                    result.put("isBatchUser", entry.getValue());
                    continue;
                }
                if ("paramName".equals(entry.getKey()) && StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) {
                    String paramValue = (String)jsonMap.get("paramValue");
                    if (paramValue.equals("true") || paramValue.equals("false")) {
                        result.put((String)entry.getValue(), Boolean.parseBoolean(paramValue));
                        continue;
                    }
                    result.put((String)entry.getValue(), paramValue);
                    continue;
                }
                if (!((String)entry.getKey()).contains("paramName") || !StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
                String index = ((String)entry.getKey()).replace("paramName", "");
                String paramValue = (String)jsonMap.get("paramValue" + index);
                if (paramValue.equals("true") || paramValue.equals("false")) {
                    result.put((String)entry.getValue(), Boolean.parseBoolean(paramValue));
                    continue;
                }
                result.put((String)entry.getValue(), paramValue);
            }
        }
        return result;
    }

    @Override
    public TaProcessCheckDetail findCheckDetail(String nodeCode, String recordId) {
        List list;
        Example example = new Example(TaProcessCheckDetail.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)nodeCode) && StringUtil.isNotEmpty((CharSequence)recordId)) {
            criteria.andEqualTo("nodeKey", (Object)nodeCode);
            criteria.andEqualTo("recordId", (Object)recordId);
        }
        if ((list = this.taProcessCheckDetailDao.selectByExample(example)).size() > 0) {
            return (TaProcessCheckDetail)list.get(0);
        }
        return null;
    }

    @Override
    public List<TaProcessCheckDetail> findCheckDetails(String recordId) {
        Example example = new Example(TaProcessCheckDetail.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)recordId)) {
            criteria.andEqualTo("recordId", (Object)recordId);
        }
        List list = this.taProcessCheckDetailDao.selectByExample(example);
        return list;
    }

    @Override
    public List<TaProcessCheckBatch> findCheckBatchs(String recordId) {
        Example example = new Example(TaProcessCheckBatch.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)recordId)) {
            criteria.andEqualTo("recordId", (Object)recordId);
        }
        return this.taProcessCheckBatchDao.selectByExample(example);
    }

    @Override
    public void updateEntity(TaProcessCheckDetail detail) {
        this.taProcessCheckDetailDao.updateByPrimaryKeySelective(detail);
    }

    private Process getActProcess(String processKey) {
        ProcessDefinition pf = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).latestVersion().singleResult();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(pf.getId());
        return (Process)bpmnModel.getProcesses().get(0);
    }

    @Override
    public List<ProcCkQuerySetVo> checkQuerySet(String processId) {
        ArrayList<ProcCkQuerySetVo> params = new ArrayList<ProcCkQuerySetVo>();
        TaProcessEntity proc = (TaProcessEntity)this.taProcessDao.selectByPrimaryKey(processId);
        Process process = this.getActProcess(proc.getProcessKey());
        Collection flowElements = process.getFlowElements();
        for (FlowElement flowElement : flowElements) {
            SequenceFlow sequenceFlow;
            String condition;
            if (!(flowElement instanceof SequenceFlow) || !StringUtils.isNotEmpty((CharSequence)(condition = (sequenceFlow = (SequenceFlow)flowElement).getConditionExpression()))) continue;
            params.add(new ProcCkQuerySetVo(condition, "", sequenceFlow.getName(), "1"));
        }
        return params;
    }

    @Override
    public void updateCkRecord(TaProcessCheckRecord entity) throws Exception {
        TaProcessCheckRecord oldEntity = (TaProcessCheckRecord)this.taProcessCheckRecordDao.selectByPrimaryKey(entity.getId());
        if (oldEntity != null) {
            oldEntity.setTitle(entity.getTitle());
            oldEntity.setCkParams(entity.getCkParams());
            oldEntity.setState(entity.getState());
            oldEntity.setResultRemark(entity.getResultRemark());
            this.taProcessCheckRecordDao.updateByPrimaryKeySelective(oldEntity);
        }
    }

    @Override
    public void deleteHis(String id) throws Exception {
        List<TaProcessCheckBatch> list2;
        this.taProcessCheckRecordDao.deleteByPrimaryKey(id);
        List<TaProcessCheckDetail> list1 = this.findCheckDetails(id);
        if (CollectionUtil.listNotEmptyNotSizeZero(list1)) {
            list1.forEach(item -> this.taProcessCheckDetailDao.delete(item));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(list2 = this.findCheckBatchs(id))) {
            list2.forEach(item -> this.taProcessCheckBatchDao.delete(item));
        }
    }

    @Override
    public TaProcessCkRecordVo findRecordDetail(String recordId) throws Exception {
        TaProcessCheckRecord entity = (TaProcessCheckRecord)this.taProcessCheckRecordDao.selectByPrimaryKey(recordId);
        TaProcessCkRecordVo vo = new TaProcessCkRecordVo();
        BeanUtils.copyProperties((Object)entity, (Object)vo);
        vo.setCkParamMap(this.getCkParams(vo.getCkParams()));
        vo.setRealParams(this.checkQuerySet(vo.getProcessId()));
        vo.setCkPassDetails(this.findCheckDetails(recordId));
        vo.setBatchDetails(this.findCheckBatchs(recordId));
        return vo;
    }

    @Override
    public List<String> getBatchUserIds(String proCkQuerySet) throws Exception {
        String[] users;
        ArrayList<String> list = new ArrayList<String>();
        HashMap<String, Object> map = this.getCkParams(proCkQuerySet);
        String strUsers = (String)map.get("proStartUserName");
        if (StringUtils.isBlank((CharSequence)strUsers)) {
            throw new Exception("\u7528\u6237\u53c2\u6570\u4e3a\u7a7a");
        }
        for (String user : users = strUsers.split(",")) {
            if (!StringUtils.isNotBlank((CharSequence)user) || list.contains(user)) continue;
            list.add(user);
        }
        if (list.size() == 0) {
            throw new Exception("\u68c0\u6d4b\u7528\u6237\u4e3a\u7a7a");
        }
        return list;
    }

    @Override
    public void saveBatchCk(String batchId, String resultRemark) throws Exception {
        TaProcessCkRecordVo vo = (TaProcessCkRecordVo)EhcacheUtil.getItem("PRO_CK_" + batchId);
        TaProcessCheckRecord entity = new TaProcessCheckRecord();
        entity.setCheckTime(vo.getCheckTime());
        entity.setProcessId(vo.getProcessId());
        entity.setState("1");
        int fail = (Integer)EhcacheUtil.getItem("PRO_CK_PG_FAIL_" + batchId);
        if (fail > 0) {
            entity.setState("2");
        }
        entity.setTitle(vo.getTitle() + "(\u6279\u91cf)");
        entity.setIsBatchUser(vo.getIsBatchUser());
        entity.setCkParams(vo.getCkParams());
        entity.setResultRemark(resultRemark);
        this.taProcessCheckRecordDao.insertSelective(entity);
        List ckDetails = vo.getCkPassDetails();
        for (String user : vo.getUsers()) {
            TaProcessCheckBatch batch = new TaProcessCheckBatch();
            batch.setRecordId(entity.getId());
            batch.setUserName(user);
            ArrayList<TaProcessCheckDetail> details = new ArrayList<TaProcessCheckDetail>();
            for (TaProcessCheckDetail detail : ckDetails) {
                if (!user.equals(detail.getUserName())) continue;
                detail.setRecordId(entity.getId());
                details.add(detail);
            }
            batch.setJsonData(JsonUtil.toJson(details));
            this.taProcessCheckBatchDao.insertSelective(batch);
        }
    }

    private TmPositionVo getPositionVoInfo(String positionCode) {
        if (StringUtils.isBlank((CharSequence)positionCode)) {
            throw new RuntimeException("\u672a\u4f20\u9012\u804c\u4f4d\u7f16\u7801\u4fe1\u606f");
        }
        AjaxJson ajaxJson = this.tmPositionFeign.getPosition("", positionCode);
        return (TmPositionVo)ajaxJson.getObj();
    }

    private TmUserVo getUserVo(String userName) {
        TmUserQueryVo tmUserQueryVo = new TmUserQueryVo();
        tmUserQueryVo.setUsername(userName);
        AjaxJson ajaxJson = this.tmUserFeign.getTmUser(tmUserQueryVo);
        return (TmUserVo)ajaxJson.getObj();
    }
}

