/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.controller;

import com.biz.eisp.activiti.designer.processconf.service.TaProcessDefinitionService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessDefinitionVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.RepositoryService;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"taProcessDefinitionController"})
public class TaProcessDefinitionController {
    private static final Logger log = LoggerFactory.getLogger(TaProcessDefinitionController.class);
    @Autowired
    private TaProcessDefinitionService taProcessDefinitionService;
    @Autowired
    private RepositoryService repositoryService;

    @RequestMapping(value={"goProcessDefinitionMain"})
    public ModelAndView deploymentListByProcesskey(String processKey, HttpServletRequest request) {
        if (StringUtils.isEmpty((String)processKey)) {
            throw new BusinessException("\u672a\u627e\u5230\u6d41\u7a0b\u5b9a\u4e49Key");
        }
        request.setAttribute("processKey", (Object)processKey);
        return new ModelAndView("com/biz/eisp/activiti/designer/processconf/processdefinition/processDefinitionMain");
    }

    @RequestMapping(value={"findProcessDefinitionList"})
    @ResponseBody
    public DataGrid findProcessDefinitionList(TaProcessDefinitionVo taProcessDefinitionVo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        PageInfo<TaProcessDefinitionVo> pageInfo = this.taProcessDefinitionService.findProcessDefinitionList(taProcessDefinitionVo, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"setProcessState"})
    @ResponseBody
    public AjaxJson setProcessState(String state, String processDefinitionId, HttpServletRequest request) {
        AjaxJson json = new AjaxJson();
        String msg = this.taProcessDefinitionService.toggleProcessState(state, processDefinitionId);
        json.setMsg(msg);
        return json;
    }

    @RequestMapping(value={"goProcessDefinitionPicInfoForm"})
    public ModelAndView goProcessDefinitionPicInfoForm(String diagramResourceName, String deploymentId, HttpServletRequest request) {
        request.setAttribute("diagramResourceName", (Object)diagramResourceName);
        request.setAttribute("deploymentId", (Object)deploymentId);
        return new ModelAndView("com/biz/eisp/activiti/designer/processconf/processdefinition/processDefinitionPicInfoForm");
    }

    @RequestMapping(value={"getProcessDefinitionPicInfo"})
    public void getProcessDefinitionPicInfo(String diagramResourceName, String deploymentId, HttpServletResponse response) {
        try {
            InputStream inputStream = this.repositoryService.getResourceAsStream(deploymentId, diagramResourceName);
            ServletOutputStream outputStream = response.getOutputStream();
            TaProcessDefinitionController.copyImageStream(inputStream, (OutputStream)outputStream);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    public static void copyImageStream(InputStream inputStream, OutputStream outputStream) {
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        finally {
            try {
                inputStream.close();
                outputStream.close();
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
    }

    @RequestMapping(value={"deleteProcessDefinition"})
    @ResponseBody
    public AjaxJson deleteProcessDefinition(@RequestParam String deploymentId, @RequestParam String processDefinitionKey) {
        AjaxJson json = new AjaxJson();
        try {
            this.taProcessDefinitionService.deleteProcessDefinition(deploymentId, processDefinitionKey);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            json.setSuccess(false);
            json.setMsg(e.getMessage());
        }
        return json;
    }
}

