/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.controller;

import com.biz.eisp.activiti.designer.processconf.service.TaProcessFunctionAuthService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessFunctionAuthVo;
import com.biz.eisp.activiti.runtime.service.TaProcessThemeService;
import com.biz.eisp.activiti.runtime.vo.TaProcessThemeVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UUIDGenerator;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.utils.LockUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/taProcessThemeController"})
public class TaProcessThemeController {
    private static final Logger log = LoggerFactory.getLogger(TaProcessThemeController.class);
    @Autowired
    private TaProcessThemeService taProcessThemeService;
    @Autowired
    private TaProcessFunctionAuthService taProcessFunctionAuthService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private LockUtils lockUtils;

    @RequestMapping(value={"goTaProcessTheme"})
    public ModelAndView goTaProcessManage(String businessKey, String type, String fullPathName, String detail, String value) {
        ModelAndView mv = new ModelAndView("com/biz/eisp/activiti/runtime/taProcessThemeMain");
        mv.addObject("businessKey", (Object)businessKey);
        mv.addObject("type", (Object)type);
        mv.addObject("detail", (Object)detail);
        mv.addObject("fullPathName", (Object)fullPathName);
        mv.addObject("value", (Object)value);
        mv.addObject("businessKeyMain", (Object)UUIDGenerator.generate());
        return mv;
    }

    @RequestMapping(value={"goSelectTaProcessTheme"})
    public ModelAndView goSelectTaProcessTheme(HttpServletRequest request, String businessKey, String type, String fullPathName, String detail, String value, String functionId) {
        ModelAndView mv = new ModelAndView("com/biz/eisp/activiti/runtime/selectTaProcessThemeMain");
        mv.addObject("businessKey", (Object)businessKey);
        mv.addObject("type", (Object)type);
        mv.addObject("detail", (Object)detail);
        mv.addObject("fullPathName", (Object)fullPathName);
        mv.addObject("value", (Object)value);
        List<TaProcessFunctionAuthVo> processVoList = this.taProcessFunctionAuthService.findTaProcessListByFunctionId(functionId);
        mv.addObject("processVoList", processVoList);
        mv.addObject("businessKeyMain", (Object)UUIDGenerator.generate());
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"doSubmit"})
    @ResponseBody
    public AjaxJson doSubmit(TaProcessThemeVo themeVo, String fullPathName) {
        AjaxJson returnJson = new AjaxJson();
        String businessKeyMain = themeVo.getBusinessKeyMain();
        try {
            boolean lock;
            if (this.redisService != null && StringUtil.isNotEmpty((CharSequence)businessKeyMain) && !(lock = this.lockUtils.lock("submit_act_" + businessKeyMain))) {
                throw new BusinessException("\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4");
            }
            this.taProcessThemeService.doSubmit(themeVo, fullPathName);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            returnJson.setSuccess(false);
            returnJson.setMsg(e.getMessage());
        }
        finally {
            if (this.redisService != null) {
                this.lockUtils.unLock("submit_act_" + businessKeyMain);
            }
        }
        return returnJson;
    }
}

