/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.dingtalk.service.impl;

import com.biz.eisp.activiti.util.JsonUtil;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.dingtalk.base.AccessToken;
import com.biz.eisp.dingtalk.service.DingtalkUserService;
import com.biz.eisp.dingtalk.service.entity.DingtalkUserEntity;
import com.biz.eisp.dingtalk.service.entity.DingtalkUserInfoEntity;
import com.biz.eisp.dingtalk.utils.DingtalkConfigurer;
import com.biz.eisp.tk.utils.BeanCopyUtils;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiUserGetByMobileRequest;
import com.dingtalk.api.request.OapiUserGetRequest;
import com.dingtalk.api.request.OapiUserSimplelistRequest;
import com.dingtalk.api.response.OapiUserGetByMobileResponse;
import com.dingtalk.api.response.OapiUserGetResponse;
import com.dingtalk.api.response.OapiUserSimplelistResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Service;

@Configuration
@Service
public class DingtalkUserServiceImpl
implements DingtalkUserService {
    private static final Logger log = LoggerFactory.getLogger(DingtalkUserServiceImpl.class);
    @Autowired
    private DingtalkConfigurer dingtalkConfigurer;
    @Autowired
    private AccessToken accessToken;

    @Override
    public DingtalkUserInfoEntity getUserInfo(String userId) {
        DefaultDingTalkClient client = new DefaultDingTalkClient(this.dingtalkConfigurer.getUserinfoUrl());
        OapiUserGetRequest request = new OapiUserGetRequest();
        request.setUserid(userId);
        request.setHttpMethod("GET");
        try {
            OapiUserGetResponse response = (OapiUserGetResponse)client.execute((TaobaoRequest)request, this.accessToken.getAccessToken());
            if (response.isSuccess()) {
                DingtalkUserInfoEntity user = (DingtalkUserInfoEntity)BeanCopyUtils.copyToBean((Object)response, DingtalkUserInfoEntity.class);
                return user;
            }
            throw new BusinessException("\u83b7\u53d6\u9489\u9489\u7528\u6237\u4fe1\u606f\u5f02\u5e38," + response.getErrmsg());
        }
        catch (ApiException e) {
            throw new BusinessException("\u83b7\u53d6\u9489\u9489\u7528\u6237\u4fe1\u606f\u5f02\u5e38, \u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
        }
    }

    @Override
    public List<DingtalkUserEntity> getOrgUsers(Long orgId) {
        DefaultDingTalkClient client = new DefaultDingTalkClient(this.dingtalkConfigurer.getOrgUserinfoUrl());
        OapiUserSimplelistRequest request = new OapiUserSimplelistRequest();
        request.setDepartmentId(orgId);
        request.setOffset(Long.valueOf(0L));
        request.setSize(Long.valueOf(10L));
        request.setHttpMethod("GET");
        try {
            OapiUserSimplelistResponse response = (OapiUserSimplelistResponse)client.execute((TaobaoRequest)request, this.accessToken.getAccessToken());
            if (response.isSuccess()) {
                List users = BeanCopyUtils.copyToBeanList((List)response.getUserlist(), DingtalkUserEntity.class);
                return users;
            }
            throw new BusinessException("\u83b7\u53d6\u9489\u9489\u90e8\u95e8\u7528\u6237\u4fe1\u606f\u5f02\u5e38," + response.getErrmsg());
        }
        catch (ApiException e) {
            throw new BusinessException("\u83b7\u53d6\u9489\u9489\u90e8\u95e8\u7528\u6237\u4fe1\u606f\u5f02\u5e38, \u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
        }
    }

    @Override
    public String getUserIdByMobile(String mobile) {
        if (StringUtil.isBlank((CharSequence)mobile)) {
            return null;
        }
        DefaultDingTalkClient client = new DefaultDingTalkClient(this.dingtalkConfigurer.getUseridByMobileUrl());
        OapiUserGetByMobileRequest request = new OapiUserGetByMobileRequest();
        request.setMobile(mobile);
        try {
            OapiUserGetByMobileResponse response = (OapiUserGetByMobileResponse)client.execute((TaobaoRequest)request, this.accessToken.getAccessToken());
            if (response.isSuccess() && StringUtil.isNotBlank((CharSequence)response.getUserid())) {
                return response.getUserid();
            }
            log.error("\u624b\u673a\u53f7\u83b7\u53d6\u9489\u9489\u7528\u6237id\u5931\u8d25>>>>> mobile={}, response={}", (Object)mobile, (Object)JsonUtil.toJson(response));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return null;
    }
}

