/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.api.controller;

import com.biz.eisp.activiti.designer.processconf.dao.TaProcessDao;
import com.biz.eisp.activiti.designer.processconf.entity.ActTargetContentObjEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessOrgPageService;
import com.biz.eisp.activiti.external.service.ActivitiApiService;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.activiti.runtime.vo.OperationVo;
import com.biz.eisp.api.feign.TmOrgFeign;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.FormEnum;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ActivitiBusinessVo;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.dingtalk.service.DingActivitiService;
import com.biz.eisp.org.TmOrgVo;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.ActivitiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import tk.mybatis.mapper.entity.Example;

@Controller
@RequestMapping(value={"/activitiApiController"})
public class ActivitiApiController {
    private static final Logger log = LoggerFactory.getLogger(ActivitiApiController.class);
    @Autowired
    private ActivitiApiService activitiApiService;
    @Autowired
    private TaProcessDao taProcessDao;
    @Autowired
    private TmOrgFeign tmOrgFeign;
    @Autowired
    private TaProcessOrgPageService taProcessOrgPageService;
    @Autowired
    private DingActivitiService dingActivitiService;
    @Autowired
    private TaTaskService taTaskService;

    @PostMapping(value={"commit"})
    @ResponseBody
    public AjaxJson commit(@RequestBody ActivitiBusinessVo businessVo) {
        AjaxJson json = new AjaxJson();
        try {
            String instanceId = this.activitiApiService.commitBusiness(businessVo);
            json.setObj((Object)instanceId);
            try {
                OperationVo operationVo = new OperationVo();
                if (StringUtil.isNotBlank((CharSequence)instanceId)) {
                    operationVo.setProcessInstanceId(instanceId);
                    this.taTaskService.jumUser(instanceId, operationVo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.dingActivitiService.commit(instanceId);
        }
        catch (ActivitiException ae) {
            log.debug("listener failed !", (Throwable)ae);
            json.setErrMsg("\u6d41\u7a0b\u521d\u59cb\u5316\u8282\u70b9\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        catch (BusinessException e1) {
            json.setErrMsg(e1.getMessage());
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4\u5931\u8d25", (Throwable)e);
            json.setErrMsg("\u63d0\u4ea4\u5931\u8d25:" + this.clearOtherNotMessageInfo(e.getMessage()));
        }
        return json;
    }

    @PostMapping(value={"getTargetHeadAndDefault"})
    @ResponseBody
    public AjaxJson<ActTargetContentObjEntity> getTargetHeadAndDefault(@RequestParam(value="processKey") String processKey) {
        AjaxJson json = new AjaxJson();
        try {
            ActTargetContentObjEntity entity = this.activitiApiService.getTargetHeadAndDefault(processKey);
            json.setObj((Object)entity);
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4\u5931\u8d25", (Throwable)e);
            json.setErrMsg("\u63d0\u4ea4\u5931\u8d25:" + this.clearOtherNotMessageInfo(e.getMessage()));
        }
        return json;
    }

    @PostMapping(value={"getTargets"})
    @ResponseBody
    public AjaxJson<ActTargetContentObjEntity> getTargets(@RequestParam(value="businessObjId") String businessObjId, @RequestParam(value="processKey") String processKey) {
        AjaxJson json = new AjaxJson();
        try {
            ActTargetContentObjEntity entity = this.activitiApiService.getTargets(businessObjId, processKey);
            json.setObj((Object)entity);
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4\u5931\u8d25", (Throwable)e);
            json.setErrMsg("\u63d0\u4ea4\u5931\u8d25:" + this.clearOtherNotMessageInfo(e.getMessage()));
        }
        return json;
    }

    @PostMapping(value={"saveActTargets"})
    @ResponseBody
    public AjaxJson saveActTargets(@RequestBody ActTargetContentObjEntity entity) {
        AjaxJson json = new AjaxJson();
        try {
            this.activitiApiService.saveActTargets(entity);
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4\u5931\u8d25", (Throwable)e);
            json.setErrMsg("\u63d0\u4ea4\u5931\u8d25:" + this.clearOtherNotMessageInfo(e.getMessage()));
        }
        return json;
    }

    private String clearOtherNotMessageInfo(String str) {
        if (StringUtil.isNotEmpty((CharSequence)str)) {
            return str.substring(str.lastIndexOf(58) + 1);
        }
        return "";
    }

    @RequestMapping(value={"goActivitiSub/{processPage}"})
    public ModelAndView goTaBusinessObjMain(@PathVariable(value="processPage") String processPage, HttpServletRequest request) {
        UserRedis userRedis = UserUtils.getUser();
        List orgVos = this.tmOrgFeign.getOrgListByUser(userRedis.getId(), null).getObjList();
        String chooseFlag = "radio";
        MyTaskVo processVo = new MyTaskVo();
        if (CollectionUtil.listEmpty((List)orgVos) || StringUtil.isBlank((CharSequence)processPage)) {
            processVo.setProcessDefinitionName("\u6d41\u7a0b\u672a\u5b9a\u4e49");
        } else {
            List<String> orgCodes;
            List<String> orgTypes = orgVos.stream().map(TmOrgVo::getOrgType).collect(Collectors.toList());
            List<String> bpmKeys = this.taProcessOrgPageService.getBpmKeyByOrg(processPage, orgTypes, orgCodes = orgVos.stream().map(TmOrgVo::getOrgCode).collect(Collectors.toList()));
            if (CollectionUtil.listEmpty(bpmKeys)) {
                processVo.setProcessDefinitionName("\u6d41\u7a0b\u672a\u5b9a\u4e49");
            } else if (bpmKeys.size() == 1) {
                TaProcessEntity taProcessEntity = new TaProcessEntity();
                Example example = new Example(TaProcessEntity.class);
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("processKey", (Object)bpmKeys.get(0));
                List taProcessEntities = this.taProcessDao.selectByExample(example);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)taProcessEntities)) {
                    taProcessEntity = (TaProcessEntity)taProcessEntities.get(0);
                } else {
                    taProcessEntity.setProcessName("\u6d41\u7a0b\u672a\u5b9a\u4e49");
                }
                processVo.setProcessDefinitionName(taProcessEntity.getProcessName());
                processVo.setProcessDefinitionKey(taProcessEntity.getProcessKey());
            } else {
                Example example = new Example(TaProcessEntity.class);
                Example.Criteria criteria = example.createCriteria();
                criteria.andIn("processKey", bpmKeys);
                List taProcessEntities = this.taProcessDao.selectByExample(example);
                if (CollectionUtil.listEmpty((List)taProcessEntities)) {
                    processVo.setProcessDefinitionName("\u6d41\u7a0b\u672a\u5b9a\u4e49");
                } else if (taProcessEntities.size() == 1) {
                    processVo.setProcessDefinitionName(((TaProcessEntity)taProcessEntities.get(0)).getProcessName());
                } else {
                    chooseFlag = FormEnum.select.name();
                    request.setAttribute("taProcessEntities", (Object)taProcessEntities);
                }
            }
        }
        processVo.setCreateUserName(userRedis.getRealname());
        TmOrgVo tmOrgVo = (TmOrgVo)this.tmOrgFeign.getOrgByIdOrCode(null, userRedis.getOrgCode()).getObj();
        processVo.setOrgName(tmOrgVo.getOrgName());
        processVo.setCreateTime(DateUtils.dateNow2Str());
        request.setAttribute("chooseFlag", (Object)chooseFlag);
        request.setAttribute("processVo", (Object)processVo);
        return new ModelAndView("com/biz/eisp/activiti/activitiForm");
    }
}

