/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.transformer;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessNodeAuthDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessNodeDao;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeAuthEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.tools.DictUtil;
import com.google.common.base.Function;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TaProcessVoToTaProcessEntity
implements Function<TaProcessVo, TaProcessEntity> {
    private TaProcessNodeService taProcessNodeService;
    private TaProcessDao taProcessDao;
    private TaProcessNodeDao taProcessNodeDao;
    private TaProcessNodeAuthDao taProcessNodeAuthDao;

    public TaProcessVoToTaProcessEntity(TaProcessNodeService taProcessNodeService, TaProcessDao taProcessDao, TaProcessNodeDao taProcessNodeDao, TaProcessNodeAuthDao taProcessNodeAuthDao) {
        this.taProcessDao = taProcessDao;
        this.taProcessNodeDao = taProcessNodeDao;
        this.taProcessNodeService = taProcessNodeService;
        this.taProcessNodeAuthDao = taProcessNodeAuthDao;
    }

    public TaProcessEntity apply(TaProcessVo vo) {
        TaProcessEntity entity = null;
        if (vo == null) {
            return null;
        }
        if (StringUtil.isEmpty((String)vo.getId())) {
            entity = new TaProcessEntity();
            TaProcessEntity tmp = new TaProcessEntity();
            tmp.setProcessKey(vo.getProcessKey());
            List list = this.taProcessDao.select(tmp);
            if (list.size() > 0) {
                throw new BusinessException("\u6d41\u7a0bKey\u91cd\u590d\u4e86");
            }
        } else {
            entity = (TaProcessEntity)this.taProcessDao.selectByPrimaryKey(vo.getId());
        }
        entity.setListenerClass(vo.getListenerClass());
        entity.setNote(vo.getNote());
        entity.setProcessKey(vo.getProcessKey());
        entity.setProcessName(vo.getProcessName());
        entity.setProcessState(vo.getProcessState());
        entity.setProcessXml(vo.getProcessDescriptor().getBytes());
        entity.setRedirectUrl(vo.getRedirectUrl());
        entity.setTableName(vo.getTableName());
        if (StringUtil.isNotEmpty((CharSequence)entity.getId())) {
            this.taProcessDao.updateByPrimaryKeySelective(entity);
        } else {
            entity.setProcessState(WorkFlowGlobals.PROCESS_DEPLOY_NO);
            this.taProcessDao.insertSelective(entity);
        }
        String nodes = vo.getNodes();
        HashMap newMap = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)nodes)) {
            String[] temp;
            for (String aTemp : temp = nodes.split("@@@")) {
                TaProcessNodeEntity taProcessNodeEntity;
                String[] fileds = aTemp.split("###");
                String tid = fileds[0].substring(3);
                String name = fileds[1].substring(9);
                String roleCode = null;
                if (fileds.length > 2) {
                    roleCode = fileds[2].substring(9);
                }
                if ((taProcessNodeEntity = this.taProcessNodeService.getTaProcessNodeEntity(tid, vo.getProcessKey())) == null) {
                    taProcessNodeEntity = new TaProcessNodeEntity();
                    taProcessNodeEntity.setProcessNodeCode(tid);
                    taProcessNodeEntity.setProcessNodeName(name);
                    taProcessNodeEntity.setProcessId(entity.getId());
                    taProcessNodeEntity.setDuplicateJumpNode("N");
                    taProcessNodeEntity.setNullJumpNode("N");
                    this.taProcessNodeDao.insertSelective(taProcessNodeEntity);
                } else {
                    taProcessNodeEntity.setProcessNodeCode(tid);
                    taProcessNodeEntity.setProcessNodeName(name);
                    taProcessNodeEntity.setProcessId(entity.getId());
                    this.taProcessNodeDao.updateByPrimaryKeySelective(taProcessNodeEntity);
                }
                this.saveTaProcessNodeAuth(taProcessNodeEntity);
            }
        }
        return entity;
    }

    private void saveTaProcessNodeAuth(TaProcessNodeEntity taProcessNodeEntity) {
        TaProcessNodeAuthEntity entity = new TaProcessNodeAuthEntity();
        entity.setProcessNodeId(taProcessNodeEntity.getId());
        TaProcessNodeAuthEntity authEntity = (TaProcessNodeAuthEntity)this.taProcessNodeAuthDao.selectOne(entity);
        if (authEntity == null) {
            authEntity = new TaProcessNodeAuthEntity();
            authEntity.setProcessNodeId(taProcessNodeEntity.getId());
            authEntity.setProcessId(taProcessNodeEntity.getProcessId());
            String btn1 = DictUtil.getDictDataVal((String)"tm_process_node_auth", (String)"btn1") == null ? "Y" : DictUtil.getDictDataVal((String)"tm_process_node_auth", (String)"btn1");
            String btn2 = DictUtil.getDictDataVal((String)"tm_process_node_auth", (String)"btn2") == null ? "Y" : DictUtil.getDictDataVal((String)"tm_process_node_auth", (String)"btn2");
            String btn3 = DictUtil.getDictDataVal((String)"tm_process_node_auth", (String)"btn3") == null ? "Y" : DictUtil.getDictDataVal((String)"tm_process_node_auth", (String)"btn3");
            String btn4 = DictUtil.getDictDataVal((String)"tm_process_node_auth", (String)"btn4") == null ? "Y" : DictUtil.getDictDataVal((String)"tm_process_node_auth", (String)"btn4");
            String btn5 = DictUtil.getDictDataVal((String)"tm_process_node_auth", (String)"btn5") == null ? "Y" : DictUtil.getDictDataVal((String)"tm_process_node_auth", (String)"btn5");
            String btn6 = DictUtil.getDictDataVal((String)"tm_process_node_auth", (String)"btn6") == null ? "Y" : DictUtil.getDictDataVal((String)"tm_process_node_auth", (String)"btn6");
            String btn7 = DictUtil.getDictDataVal((String)"tm_process_node_auth", (String)"btn7") == null ? "Y" : DictUtil.getDictDataVal((String)"tm_process_node_auth", (String)"btn7");
            String btn8 = DictUtil.getDictDataVal((String)"tm_process_node_auth", (String)"btn8") == null ? "Y" : DictUtil.getDictDataVal((String)"tm_process_node_auth", (String)"btn8");
            String btn9 = DictUtil.getDictDataVal((String)"tm_process_node_auth", (String)"btn9") == null ? "Y" : DictUtil.getDictDataVal((String)"tm_process_node_auth", (String)"btn9");
            String btn10 = DictUtil.getDictDataVal((String)"tm_process_node_auth", (String)"btn10") == null ? "Y" : DictUtil.getDictDataVal((String)"tm_process_node_auth", (String)"btn10");
            authEntity.setBtn1(btn1);
            authEntity.setBtn2(btn2);
            authEntity.setBtn3(btn3);
            authEntity.setBtn4(btn4);
            authEntity.setBtn5(btn5);
            authEntity.setBtn6(btn6);
            authEntity.setBtn7(btn7);
            authEntity.setBtn8(btn8);
            authEntity.setBtn9(btn9);
            authEntity.setBtn10(btn10);
        }
        if (StringUtil.isNotEmpty((CharSequence)authEntity.getId())) {
            this.taProcessNodeAuthDao.updateByPrimaryKeySelective(authEntity);
        } else {
            this.taProcessNodeAuthDao.insertSelective(authEntity);
        }
    }
}

