/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.dingtalk.service.impl;

import com.biz.eisp.activiti.runtime.dao.TaTaskDao;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.activiti.runtime.vo.TaProcessApprovalLogVo;
import com.biz.eisp.activiti.vo.DingtalkTodoAddReqVo;
import com.biz.eisp.api.feign.TmUserFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.dingtalk.service.DingActivitiService;
import com.biz.eisp.dingtalk.service.DingtalkTodoService;
import com.biz.eisp.dingtalk.utils.DingtalkConstant;
import com.biz.eisp.user.entity.TmUserEntity;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DingActivitiServiceImpl
implements DingActivitiService {
    private static final Logger log = LoggerFactory.getLogger(DingActivitiServiceImpl.class);
    @Autowired
    private TaTaskService taTaskService;
    @Autowired
    private TaTaskDao taTaskDao;
    @Autowired
    private DingtalkTodoService dingtalkTodoService;
    @Autowired
    private TmUserFeign tmUserFeign;

    @Override
    public void commit(String processInstanceId) {
        this.addDingTodo(processInstanceId);
    }

    private void addDingTodo(String processInstanceId) {
        try {
            if (!DingtalkConstant.checkOffOrOn()) {
                return;
            }
            List<TaProcessApprovalLogVo> voList = this.taTaskDao.findRuntimeApprovalList(processInstanceId);
            Map<String, List<String>> map = CollectionUtil.listNotEmptyNotSizeZero(voList) ? voList.stream().collect(Collectors.groupingBy(TaProcessApprovalLogVo::getId, Collectors.mapping(TaProcessApprovalLogVo::getAssignees, Collectors.toList()))) : this.taTaskService.getNowPostMapForDingDing(processInstanceId);
            if (map == null || map.isEmpty()) {
                return;
            }
            MyTaskVo myTaskVo = this.taTaskService.findProcessBasicInfoByProcinstId(processInstanceId);
            if (null == myTaskVo) {
                log.error("DingActivitiServiceImpl.addDingTodo >>>> \u672a\u52a0\u8f7d\u5230\u4efb\u52a1\u4fe1\u606f\uff0c\u5ffd\u7565\u672c\u6b21\u8bf7\u6c42\uff01 processInstanceId={}", (Object)processInstanceId);
                return;
            }
            map.forEach((k, v) -> v.forEach(item -> {
                if (StringUtils.isNotBlank((CharSequence)item)) {
                    TmUserEntity userEntity = (TmUserEntity)ApiResultUtil.objResult((AjaxJson)this.tmUserFeign.findPositionUserByIdOrCode(null, item));
                    if (null == userEntity) {
                        log.error("DingActivitiServiceImpl.addDingTodo >>>> \u672a\u52a0\u8f7d\u5230\u7528\u6237\u4fe1\u606f\uff0c\u5ffd\u7565\u672c\u6b21\u8bf7\u6c42\uff01 processInstanceId={}, item={}", (Object)processInstanceId, item);
                        return;
                    }
                    DingtalkTodoAddReqVo dingtalkTodoAddReqVo = new DingtalkTodoAddReqVo(myTaskVo.getProcessTitle(), processInstanceId, myTaskVo.getCreateUserName(), userEntity.getUsername(), item, processInstanceId, k);
                    this.dingtalkTodoService.addDingtalkTodo(dingtalkTodoAddReqVo);
                }
            }));
        }
        catch (Exception e) {
            log.error("DingActivitiServiceImpl.addDingTodo >>>> \u672a\u77e5\u9519\u8bef\uff0c\u5ffd\u7565\u672c\u6b21\u8bf7\u6c42\uff01 processInstanceId={}", (Object)processInstanceId, (Object)e);
        }
    }

    @Override
    @Transactional
    public void pass(String processInstanceId) {
        if (!DingtalkConstant.checkOffOrOn()) {
            return;
        }
        this.dingtalkTodoService.updateTodoByProcessInstanceId(processInstanceId);
        this.addDingTodo(processInstanceId);
    }

    @Override
    public void reject(String processInstanceId) {
        if (!DingtalkConstant.checkOffOrOn()) {
            return;
        }
        this.dingtalkTodoService.updateTodoByProcessInstanceId(processInstanceId);
    }

    @Override
    public void rejectTarger(String processInstanceId) {
        if (!DingtalkConstant.checkOffOrOn()) {
            return;
        }
        this.dingtalkTodoService.updateTodoByProcessInstanceId(processInstanceId);
        this.addDingTodo(processInstanceId);
    }
}

