/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.dingtalk.service.impl;

import com.biz.eisp.activiti.vo.DingtalkTodoUpdateReqVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.dingtalk.dao.ActDingtalkTodoLogDao;
import com.biz.eisp.dingtalk.service.ActDingtalkTodoLogService;
import com.biz.eisp.dingtalk.service.entity.ActDingtalkTodoLogEntity;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class ActDingtalkTodoLogServiceImpl
implements ActDingtalkTodoLogService {
    @Autowired
    private ActDingtalkTodoLogDao actDingtalkTodoLogDao;

    @Override
    public List<ActDingtalkTodoLogEntity> saveList(List<ActDingtalkTodoLogEntity> entities) {
        if (CollectionUtil.listEmpty(entities)) {
            return Lists.newArrayList();
        }
        entities.stream().forEach(item -> this.checkEntity((ActDingtalkTodoLogEntity)item));
        this.actDingtalkTodoLogDao.insertList(entities);
        return entities;
    }

    @Override
    public List<ActDingtalkTodoLogEntity> findEntity(DingtalkTodoUpdateReqVo reqVo) {
        if (StringUtils.isBlank((CharSequence)reqVo.getProcessInstanceId())) {
            return Lists.newArrayList();
        }
        Example param = new Example(ActDingtalkTodoLogEntity.class);
        Example.Criteria builder = param.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)reqVo.getLogId())) {
            builder.andEqualTo("id", (Object)reqVo.getLogId());
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getTodoId())) {
            builder.andEqualTo("todoId", (Object)reqVo.getTodoId());
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getTaskId())) {
            builder.andEqualTo("taskId", (Object)reqVo.getTaskId());
        }
        if (StringUtils.isNotBlank((CharSequence)reqVo.getUserName())) {
            builder.andEqualTo("userName", (Object)reqVo.getUserName());
        }
        builder.andEqualTo("processInstanceId", (Object)reqVo.getProcessInstanceId());
        return this.actDingtalkTodoLogDao.selectByExample(param);
    }

    @Override
    public void deleteEntity(Set<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.actDingtalkTodoLogDao.deleteByIds(ids.stream().collect(Collectors.joining("','", "'", "'")));
    }

    private void doUpdate(ActDingtalkTodoLogEntity entity) {
        String processInstanceId = entity.getProcessInstanceId();
        String taskId = entity.getTaskId();
        String userName = entity.getUserName();
        if (StringUtils.isBlank((CharSequence)processInstanceId) || StringUtils.isBlank((CharSequence)taskId) || StringUtils.isBlank((CharSequence)userName)) {
            return;
        }
        Example param = new Example(ActDingtalkTodoLogEntity.class);
        Example.Criteria builder = param.createCriteria();
        builder.andEqualTo("taskId", (Object)taskId);
        builder.andEqualTo("userName", (Object)userName);
        builder.andEqualTo("processInstanceId", (Object)processInstanceId);
        this.actDingtalkTodoLogDao.updateByExample(entity, param);
    }

    private void checkEntity(ActDingtalkTodoLogEntity entity) {
        if (StringUtils.isBlank((CharSequence)entity.getTaskId())) {
            throw new BusinessException("\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)entity.getDingtalkUserId())) {
            throw new BusinessException("\u9489\u9489\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)entity.getTodoId())) {
            throw new BusinessException("\u5f85\u529e\u4e8b\u9879id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)entity.getUserName())) {
            throw new BusinessException("\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)entity.getUserPositionCode())) {
            throw new BusinessException("\u7528\u6237\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

