/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.controller;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessDao;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import tk.mybatis.mapper.entity.Example;

@Controller
@RequestMapping(value={"taProcessController"})
public class TaProcessController {
    @Autowired
    private TaProcessService taProcessService;
    @Autowired
    private TaProcessDao taProcessDao;

    @RequestMapping(value={"goTaProcessMain"})
    public String goTaProcessMain() {
        return "com/biz/eisp/activiti/designer/processconf/taProcessMain";
    }

    @RequestMapping(value={"goTaProcessForm"})
    public String goTaProcessForm(Model model, String id) {
        model.addAttribute("processid", (Object)id);
        return "com/biz/eisp/activiti/designer/processconf/taProcessForm";
    }

    @RequestMapping(value={"processTabs"})
    public String processTabs(String id, Model model) {
        model.addAttribute("taProcessId", (Object)id);
        return "com/biz/eisp/activiti/designer/processconf/taProcessTabs";
    }

    @RequestMapping(value={"goTaProcessSelect"})
    public String goTaProcessSelect() {
        return "com/biz/eisp/activiti/designer/processconf/taProcessSelect";
    }

    @RequestMapping(value={"goTaProcessPropertiesForm"})
    public String goTaProcessPropertiesForm(Model model, HttpServletRequest request) {
        TaProcessVo processVo;
        String id = OConvertUtils.getString((String)request.getParameter("id"));
        String checkbox = OConvertUtils.getString((String)request.getParameter("checkbox"));
        String processId = OConvertUtils.getString((String)request.getParameter("processId"));
        String processDefinitionId = OConvertUtils.getString((String)request.getParameter("processDefinitionId"));
        if (StringUtil.isNotEmpty((CharSequence)processDefinitionId) && (processVo = this.taProcessService.getProcessById(processDefinitionId)) != null) {
            model.addAttribute("processDefinitionId", (Object)processVo.getId());
            processId = processVo.getProcessKey();
            model.addAttribute("listenerClass", (Object)processVo.getListenerClass());
            model.addAttribute("tableName", (Object)processVo.getTableName());
            model.addAttribute("redirectUrl", (Object)processVo.getRedirectUrl());
        }
        model.addAttribute("checkbox", (Object)checkbox);
        model.addAttribute("id", (Object)id);
        model.addAttribute("processId", (Object)processId);
        model.addAttribute("key", (Object)processId);
        return "com/biz/eisp/activiti/designer/processconf/taProcessPropertiesForm";
    }

    @RequestMapping(value={"findProcessList"})
    @ResponseBody
    public DataGrid findProcessList(HttpServletRequest request) {
        EuPage page = new EuPage(request);
        PageInfo<TaProcessEntity> pageInfo = this.taProcessService.findTaProcessList((Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"saveTaProcess"})
    @ResponseBody
    public AjaxJson saveTaProcess(TaProcessVo taProcessVo) {
        AjaxJson json = new AjaxJson();
        try {
            taProcessVo.setId(taProcessVo.getProcessDefinitionId());
            TaProcessEntity taProcessEntity = this.taProcessService.saveTaProcess(taProcessVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            json.setSuccess(false);
            json.setMsg(e.getMessage());
        }
        return json;
    }

    @RequestMapping(value={"deleteTaProcess"})
    @ResponseBody
    public AjaxJson deleteTaProcess(@RequestParam String id) {
        AjaxJson json = new AjaxJson();
        try {
            this.taProcessService.deleteTaProcess(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            json.setSuccess(false);
            json.setMsg(e.getMessage());
        }
        return json;
    }

    @RequestMapping(value={"getProcessXml"})
    @ResponseBody
    public String getProcessXml(@RequestParam String processId, HttpServletResponse response) {
        TaProcessVo taProcessVo = this.taProcessService.getProcessById(processId);
        return taProcessVo.getProcessDescriptor();
    }

    @GetMapping(value={"getProcessById"})
    @ResponseBody
    public AjaxJson<TaProcessVo> getProcessById(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TaProcessVo taProcessVo = this.taProcessService.getProcessById(id);
        ajaxJson.setObj((Object)taProcessVo);
        return ajaxJson;
    }

    @GetMapping(value={"getTaProcessEntityByProcessKey"})
    @ResponseBody
    public AjaxJson<TaProcessEntity> getTaProcessEntityByProcessKey(@RequestParam(value="processKey") List<String> processKey) {
        AjaxJson ajaxJson = new AjaxJson();
        Example example = new Example(TaProcessEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("processKey", processKey);
        List taProcessEntities = this.taProcessDao.selectByExample(example);
        ajaxJson.setList(taProcessEntities);
        return ajaxJson;
    }

    @GetMapping(value={"getDeployedByProcessKey"})
    @ResponseBody
    public AjaxJson<TaProcessEntity> getDeployedByProcessKey(@RequestParam(value="processKey") List<String> processKey) {
        AjaxJson ajaxJson = new AjaxJson();
        Example example = new Example(TaProcessEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("processKey", processKey);
        criteria.andEqualTo("processState", (Object)WorkFlowGlobals.PROCESS_DEPLOY_YES);
        List taProcessEntities = this.taProcessDao.selectByExample(example);
        ajaxJson.setList(taProcessEntities);
        return ajaxJson;
    }
}

