/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.service.impl;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.processconf.dao.ActTargetConfigDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessDao;
import com.biz.eisp.activiti.designer.processconf.entity.ActTargetConfigEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.service.ActTargetConfigService;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UUIDGenerator;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(rollbackFor={Exception.class})
public class ActTargetConfigServiceImpl
implements ActTargetConfigService {
    @Autowired
    private ActTargetConfigDao actTargetConfigDao;
    @Autowired
    private TaProcessDao taProcessDao;

    @Override
    public PageInfo<ActTargetConfigEntity> getMaiList(ActTargetConfigEntity entity, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.actTargetConfigDao.select(entity), (Page)page);
    }

    @Override
    public AjaxJson saveData(List<ActTargetConfigEntity> entities, String processId) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)processId)) {
            ajaxJson.setErrMsg("\u53c2\u6570\u9519\u8bef");
            return ajaxJson;
        }
        for (ActTargetConfigEntity entity : entities) {
            entity.setId(UUIDGenerator.generate());
            entity.setProcessId(processId);
            String filed = entity.getFiled();
            if (StringUtil.isEmpty((String)filed)) {
                ajaxJson.setErrMsg("\u5c5e\u6027\u548c\u6807\u9898\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a.");
                return ajaxJson;
            }
            if (StringUtil.isEmpty((String)(filed = filed.replaceAll("\\s*", "")))) {
                ajaxJson.setErrMsg("\u5c5e\u6027\u5b57\u6bb5\u53bb\u7a7a\u5b57\u7b26\u4e32\u540e\u4e0d\u80fd\u4e3a\u7a7a.");
                return ajaxJson;
            }
            entity.setFiled(filed);
            String name = entity.getName();
            if (StringUtil.isEmpty((String)name)) {
                ajaxJson.setErrMsg("\u5c5e\u6027\u548c\u6807\u9898\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                return ajaxJson;
            }
            if (StringUtil.isEmpty((String)(name = name.trim()))) {
                ajaxJson.setErrMsg("\u6807\u9898\u5b57\u6bb5\u53bb\u9996\u5c3e\u7a7a\u683c\u540e\u4e0d\u80fd\u4e3a\u7a7a");
                return ajaxJson;
            }
            entity.setName(name);
        }
        Example example = new Example(ActTargetConfigEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("processId", (Object)processId);
        this.actTargetConfigDao.deleteByExample(example);
        this.actTargetConfigDao.insertList(entities);
        TaProcessEntity entity = (TaProcessEntity)this.taProcessDao.selectByPrimaryKey(processId);
        if (null != entity) {
            entity.setProcessState(WorkFlowGlobals.PROCESS_DEPLOY_NO);
            this.taProcessDao.updateByPrimaryKeySelective(entity);
        }
        return ajaxJson;
    }
}

