/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.service.impl;

import com.biz.eisp.activiti.designer.processconf.dao.TaProcessDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessOrgDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessOrgPageDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessPageDao;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessOrgEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessOrgPageEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessPageEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessOrgPageService;
import com.biz.eisp.activiti.designer.processconf.transformer.TaProcessOrgPageEntityToTaProcessOrgPageVo;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessOrgPageVo;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessOrgVo;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessPageVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.tag.tags.FormTags;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.utils.JsonPropertyUtil;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.params.Constant;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="taProcessOrgPageService")
@Transactional
public class TaProcessOrgPageServiceImpl
implements TaProcessOrgPageService {
    @Autowired
    private TaProcessOrgPageDao taProcessOrgPageDao;
    @Autowired
    private TaProcessDao taProcessDao;
    @Autowired
    private TaProcessPageDao taProcessPageDao;
    @Autowired
    private TaProcessOrgDao taProcessOrgDao;

    @Override
    public PageInfo<TaProcessOrgPageEntity> findTaProcessOrgPageList(Page page) {
        Example example = new Example(TaProcessOrgPageEntity.class);
        Example.Criteria criteriarc = example.createCriteria();
        String processId = (String)page.get((Object)"processId");
        if (StringUtils.isNotBlank((CharSequence)processId)) {
            criteriarc.andEqualTo("processId", (Object)processId);
        }
        return PageAutoHelperUtil.generatePage(() -> this.taProcessOrgPageDao.selectByExample(example), (Page)page);
    }

    @Override
    public TaProcessOrgPageVo getProcessOrgPageById(String id) {
        TaProcessOrgPageEntity entity = (TaProcessOrgPageEntity)this.taProcessOrgPageDao.selectByPrimaryKey(id);
        TaProcessOrgPageVo vo = new TaProcessOrgPageEntityToTaProcessOrgPageVo().apply(entity);
        Example examplePage = new Example(TaProcessPageEntity.class);
        Example.Criteria criteriaDetail = examplePage.createCriteria();
        criteriaDetail.andEqualTo("processKey", (Object)entity.getProcessKey());
        List pageEntities = this.taProcessPageDao.selectByExample(examplePage);
        ArrayList pageTags = new ArrayList();
        pageEntities.forEach(item -> {
            FormTags formTags = new FormTags();
            formTags.setCode(item.getPageCode());
            formTags.setName(item.getPageName());
            pageTags.add(formTags);
        });
        vo.setPageFormTags(pageTags);
        Example exampleOrg = new Example(TaProcessOrgEntity.class);
        Example.Criteria criteriaOrg = exampleOrg.createCriteria();
        criteriaOrg.andEqualTo("processKey", (Object)entity.getProcessKey());
        List orgEntities = this.taProcessOrgDao.selectByExample(exampleOrg);
        ArrayList orgCodeTags = new ArrayList();
        ArrayList orgTypeTags = new ArrayList();
        orgEntities.forEach(item -> {
            FormTags formTags = new FormTags();
            if (Constant.OptionalType.ORG_CODE.getCode().equals(item.getType())) {
                formTags.setCode(item.getOrgCode());
                formTags.setName(item.getOrgName());
                orgCodeTags.add(formTags);
            } else if (Constant.OptionalType.ORG_TYPE.getCode().equals(item.getType())) {
                formTags.setCode(item.getOrgTypeCode());
                formTags.setName(item.getOrgTypeName());
                orgTypeTags.add(formTags);
            }
        });
        vo.setOrgCodeFormTags(orgCodeTags);
        vo.setOrgTypeFormTags(orgTypeTags);
        return vo;
    }

    @Override
    public AjaxJson save(TaProcessOrgPageEntity entity, AjaxJson ajaxJson) {
        String orgType;
        String orgName;
        if (StringUtil.isEmpty((String)entity.getPageJson())) {
            ajaxJson.setErrMsg("\u8bf7\u9009\u62e9\u53ef\u9009\u9875\u9762");
            return ajaxJson;
        }
        String processId = entity.getProcessId();
        if (StringUtil.isEmpty((String)processId)) {
            ajaxJson.setErrMsg("\u8bf7\u91cd\u65b0\u9009\u62e9\u6d41\u7a0b");
            return ajaxJson;
        }
        TaProcessEntity taProcessEntity = (TaProcessEntity)this.taProcessDao.selectByPrimaryKey(processId);
        if (taProcessEntity == null) {
            ajaxJson.setErrMsg("\u8bf7\u91cd\u65b0\u9009\u62e9\u6d41\u7a0b");
            return ajaxJson;
        }
        entity.setProcessKey(taProcessEntity.getProcessKey());
        ArrayList<TaProcessOrgVo> listOrgCodeEntity = new ArrayList<TaProcessOrgVo>();
        if (StringUtil.isNotEmpty((CharSequence)entity.getOrgCodeJson())) {
            TaProcessOrgVo[] entities = (TaProcessOrgVo[])JsonPropertyUtil.toObject((String)entity.getOrgCodeJson(), TaProcessOrgVo[].class);
            listOrgCodeEntity.addAll(Arrays.asList(entities));
        }
        ArrayList<TaProcessOrgVo> listOrgTypeEntity = new ArrayList<TaProcessOrgVo>();
        if (StringUtil.isNotEmpty((CharSequence)entity.getOrgTypeJson())) {
            TaProcessOrgVo[] entities = (TaProcessOrgVo[])JsonPropertyUtil.toObject((String)entity.getOrgTypeJson(), TaProcessOrgVo[].class);
            listOrgTypeEntity.addAll(Arrays.asList(entities));
        }
        if (CollectionUtil.listEmpty(listOrgCodeEntity) && CollectionUtil.listEmpty(listOrgTypeEntity)) {
            ajaxJson.setErrMsg("\u8bf7\u9009\u62e9\u53ef\u9009\u7ec4\u7ec7\u6216\u7ec4\u7ec7\u7c7b\u578b");
            return ajaxJson;
        }
        Example example = new Example(TaProcessOrgPageEntity.class);
        Example.Criteria criteriaDetail = example.createCriteria();
        criteriaDetail.andEqualTo("processId", (Object)entity.getProcessId());
        List taProcessOrgPageEntities = this.taProcessOrgPageDao.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)taProcessOrgPageEntities)) {
            ajaxJson.setErrMsg("\u8be5\u6d41\u7a0bKEY\u5df2\u5b58\u5728\u4e1a\u52a1\u5173\u7cfb\uff0c\u8bf7\u524d\u5f80\u4fee\u6539\uff01");
            return ajaxJson;
        }
        Example examplePage = new Example(TaProcessPageEntity.class);
        Example.Criteria criteriaDetailPage = examplePage.createCriteria();
        criteriaDetailPage.andEqualTo("processId", (Object)entity.getProcessId());
        criteriaDetailPage.orEqualTo("processKey", (Object)entity.getProcessKey());
        this.taProcessPageDao.deleteByExample(examplePage);
        StringBuffer processPage = new StringBuffer();
        TaProcessPageVo[] entities = (TaProcessPageVo[])JsonPropertyUtil.toObject((String)entity.getPageJson(), TaProcessPageVo[].class);
        List<TaProcessPageVo> listPageEntity = Arrays.asList(entities);
        listPageEntity.forEach(detail -> {
            TaProcessPageEntity processPageEntity = new TaProcessPageEntity();
            processPageEntity.setProcessId(entity.getProcessId());
            processPageEntity.setProcessKey(entity.getProcessKey());
            processPageEntity.setPageName(detail.getName());
            processPageEntity.setPageCode(detail.getCode());
            this.taProcessPageDao.insertSelective(processPageEntity);
            processPage.append(detail.getName() + ",");
        });
        entity.setProcessPage(processPage.toString().substring(0, processPage.toString().length() - 1));
        Example exampleOrg = new Example(TaProcessOrgEntity.class);
        Example.Criteria criteriaOrg = exampleOrg.createCriteria();
        criteriaOrg.andEqualTo("processId", (Object)entity.getProcessId());
        criteriaOrg.orEqualTo("processKey", (Object)entity.getProcessKey());
        this.taProcessOrgDao.deleteByExample(exampleOrg);
        StringBuffer processOrgName = new StringBuffer();
        if (CollectionUtil.listNotEmptyNotSizeZero(listOrgCodeEntity)) {
            Constant.OptionalType orgCodeOptional = Constant.OptionalType.ORG_CODE;
            listOrgCodeEntity.forEach(detail -> {
                TaProcessOrgEntity processOrgEntity = new TaProcessOrgEntity();
                processOrgEntity.setProcessId(entity.getProcessId());
                processOrgEntity.setProcessKey(entity.getProcessKey());
                processOrgEntity.setType(orgCodeOptional.getCode());
                processOrgEntity.setTypeName(orgCodeOptional.getName());
                processOrgEntity.setOrgCode(detail.getCode());
                processOrgEntity.setOrgName(detail.getName());
                processOrgName.append(detail.getName() + ",");
                this.taProcessOrgDao.insertSelective(processOrgEntity);
            });
        }
        if (StringUtil.isNotEmpty((CharSequence)(orgName = processOrgName.toString()))) {
            orgName = orgName.substring(0, orgName.length() - 1);
        }
        entity.setProcessOrgName(orgName);
        StringBuffer processOrgType = new StringBuffer();
        if (CollectionUtil.listNotEmptyNotSizeZero(listOrgTypeEntity)) {
            Constant.OptionalType orgTypeOptional = Constant.OptionalType.ORG_TYPE;
            listOrgTypeEntity.forEach(detail -> {
                TaProcessOrgEntity processOrgEntity = new TaProcessOrgEntity();
                processOrgEntity.setProcessId(entity.getProcessId());
                processOrgEntity.setProcessKey(entity.getProcessKey());
                processOrgEntity.setType(orgTypeOptional.getCode());
                processOrgEntity.setTypeName(orgTypeOptional.getName());
                processOrgEntity.setOrgTypeCode(detail.getCode());
                processOrgEntity.setOrgTypeName(detail.getName());
                processOrgType.append(detail.getName() + ",");
                this.taProcessOrgDao.insertSelective(processOrgEntity);
            });
        }
        if (StringUtil.isNotEmpty((CharSequence)(orgType = processOrgType.toString()))) {
            orgType = orgType.substring(0, orgType.length() - 1);
        }
        entity.setProcessOrgType(orgType);
        this.taProcessOrgPageDao.insertSelective(entity);
        return ajaxJson;
    }

    @Override
    public AjaxJson update(TaProcessOrgPageEntity entity, AjaxJson ajaxJson) {
        String orgType;
        String orgName;
        if (StringUtil.isEmpty((String)entity.getPageJson())) {
            ajaxJson.setErrMsg("\u8bf7\u9009\u62e9\u53ef\u9009\u9875\u9762");
            return ajaxJson;
        }
        String processId = entity.getProcessId();
        if (StringUtil.isEmpty((String)processId)) {
            ajaxJson.setErrMsg("\u8bf7\u91cd\u65b0\u9009\u62e9\u6d41\u7a0b");
            return ajaxJson;
        }
        TaProcessEntity taProcessEntity = (TaProcessEntity)this.taProcessDao.selectByPrimaryKey(processId);
        if (taProcessEntity == null) {
            ajaxJson.setErrMsg("\u8bf7\u91cd\u65b0\u9009\u62e9\u6d41\u7a0b");
            return ajaxJson;
        }
        entity.setProcessKey(taProcessEntity.getProcessKey());
        ArrayList<TaProcessOrgVo> listOrgCodeEntity = new ArrayList<TaProcessOrgVo>();
        if (StringUtil.isNotEmpty((CharSequence)entity.getOrgCodeJson())) {
            TaProcessOrgVo[] entities = (TaProcessOrgVo[])JsonPropertyUtil.toObject((String)entity.getOrgCodeJson(), TaProcessOrgVo[].class);
            listOrgCodeEntity.addAll(Arrays.asList(entities));
        }
        ArrayList<TaProcessOrgVo> listOrgTypeEntity = new ArrayList<TaProcessOrgVo>();
        if (StringUtil.isNotEmpty((CharSequence)entity.getOrgTypeJson())) {
            TaProcessOrgVo[] entities = (TaProcessOrgVo[])JsonPropertyUtil.toObject((String)entity.getOrgTypeJson(), TaProcessOrgVo[].class);
            listOrgTypeEntity.addAll(Arrays.asList(entities));
        }
        if (CollectionUtil.listEmpty(listOrgCodeEntity) && CollectionUtil.listEmpty(listOrgTypeEntity)) {
            ajaxJson.setErrMsg("\u8bf7\u9009\u62e9\u53ef\u9009\u7ec4\u7ec7\u6216\u7ec4\u7ec7\u7c7b\u578b");
            return ajaxJson;
        }
        Example example = new Example(TaProcessOrgPageEntity.class);
        Example.Criteria criteriaDetail = example.createCriteria();
        criteriaDetail.andEqualTo("processId", (Object)entity.getProcessId());
        criteriaDetail.andNotEqualTo("id", (Object)entity.getId());
        List taProcessOrgPageEntities = this.taProcessOrgPageDao.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)taProcessOrgPageEntities)) {
            ajaxJson.setErrMsg("\u8be5\u6d41\u7a0bKEY\u5df2\u5b58\u5728\u4e1a\u52a1\u5173\u7cfb\uff0c\u8bf7\u524d\u5f80\u4fee\u6539\uff01");
            return ajaxJson;
        }
        Example examplePage = new Example(TaProcessPageEntity.class);
        Example.Criteria criteriaDetailPage = examplePage.createCriteria();
        criteriaDetailPage.andEqualTo("processId", (Object)entity.getProcessId());
        criteriaDetailPage.orEqualTo("processKey", (Object)entity.getProcessKey());
        this.taProcessPageDao.deleteByExample(examplePage);
        StringBuffer processPage = new StringBuffer();
        TaProcessPageVo[] entities = (TaProcessPageVo[])JsonPropertyUtil.toObject((String)entity.getPageJson(), TaProcessPageVo[].class);
        List<TaProcessPageVo> listPageEntity = Arrays.asList(entities);
        listPageEntity.forEach(detail -> {
            TaProcessPageEntity processPageEntity = new TaProcessPageEntity();
            processPageEntity.setProcessId(entity.getProcessId());
            processPageEntity.setProcessKey(entity.getProcessKey());
            processPageEntity.setPageName(detail.getName());
            processPageEntity.setPageCode(detail.getCode());
            this.taProcessPageDao.insertSelective(processPageEntity);
            processPage.append(detail.getName() + ",");
        });
        entity.setProcessPage(processPage.toString().substring(0, processPage.toString().length() - 1));
        Example exampleOrg = new Example(TaProcessOrgEntity.class);
        Example.Criteria criteriaOrg = exampleOrg.createCriteria();
        criteriaOrg.andEqualTo("processId", (Object)entity.getProcessId());
        criteriaOrg.andEqualTo("processKey", (Object)entity.getProcessKey());
        this.taProcessOrgDao.deleteByExample(exampleOrg);
        StringBuffer processOrgName = new StringBuffer();
        if (CollectionUtil.listNotEmptyNotSizeZero(listOrgCodeEntity)) {
            Constant.OptionalType orgCodeOptional = Constant.OptionalType.ORG_CODE;
            listOrgCodeEntity.forEach(detail -> {
                TaProcessOrgEntity processOrgEntity = new TaProcessOrgEntity();
                processOrgEntity.setProcessId(entity.getProcessId());
                processOrgEntity.setProcessKey(entity.getProcessKey());
                processOrgEntity.setType(orgCodeOptional.getCode());
                processOrgEntity.setTypeName(orgCodeOptional.getName());
                processOrgEntity.setOrgCode(detail.getCode());
                processOrgEntity.setOrgName(detail.getName());
                processOrgName.append(detail.getName() + ",");
                this.taProcessOrgDao.insertSelective(processOrgEntity);
            });
        }
        if (StringUtil.isNotEmpty((CharSequence)(orgName = processOrgName.toString()))) {
            orgName = orgName.substring(0, orgName.length() - 1);
        }
        entity.setProcessOrgName(orgName);
        StringBuffer processOrgType = new StringBuffer();
        if (CollectionUtil.listNotEmptyNotSizeZero(listOrgTypeEntity)) {
            Constant.OptionalType orgTypeOptional = Constant.OptionalType.ORG_TYPE;
            listOrgTypeEntity.forEach(detail -> {
                TaProcessOrgEntity processOrgEntity = new TaProcessOrgEntity();
                processOrgEntity.setProcessId(entity.getProcessId());
                processOrgEntity.setProcessKey(entity.getProcessKey());
                processOrgEntity.setType(orgTypeOptional.getCode());
                processOrgEntity.setTypeName(orgTypeOptional.getName());
                processOrgEntity.setOrgTypeCode(detail.getCode());
                processOrgEntity.setOrgTypeName(detail.getName());
                processOrgType.append(detail.getName() + ",");
                this.taProcessOrgDao.insertSelective(processOrgEntity);
            });
        }
        if (StringUtil.isNotEmpty((CharSequence)(orgType = processOrgType.toString()))) {
            orgType = orgType.substring(0, orgType.length() - 1);
        }
        entity.setProcessOrgType(orgType);
        this.taProcessOrgPageDao.updateByPrimaryKeySelective(entity);
        return ajaxJson;
    }

    @Override
    public boolean delete(String id) {
        TaProcessOrgPageEntity entity = (TaProcessOrgPageEntity)this.taProcessOrgPageDao.selectByPrimaryKey(id);
        int i = this.taProcessOrgPageDao.deleteByPrimaryKey(id);
        if (i > 0) {
            Example examplePage = new Example(TaProcessPageEntity.class);
            Example.Criteria criteriaDetail = examplePage.createCriteria();
            criteriaDetail.andEqualTo("processId", (Object)entity.getProcessId());
            this.taProcessPageDao.deleteByExample(examplePage);
            Example exampleOrgType = new Example(TaProcessOrgEntity.class);
            Example.Criteria criteriaOrgType = exampleOrgType.createCriteria();
            criteriaOrgType.andEqualTo("processId", (Object)entity.getProcessId());
            this.taProcessOrgDao.deleteByExample(exampleOrgType);
            return true;
        }
        return false;
    }

    @Override
    public List<String> getBpmKey(String processPage, List<String> orgTypes) {
        return this.getBpmKeyByOrg(processPage, orgTypes, null);
    }

    @Override
    public List<String> getBpmKeyByOrg(String processPage, List<String> orgTypes, List<String> orgCodes) {
        List<String> bpmKey = new ArrayList<String>();
        if (StringUtil.isBlank((CharSequence)processPage)) {
            return bpmKey;
        }
        if (CollectionUtil.listEmpty(orgTypes) && CollectionUtil.listEmpty(orgCodes)) {
            return bpmKey;
        }
        Example example = new Example(TaProcessPageEntity.class);
        Example.Criteria criteriaPage = example.createCriteria();
        criteriaPage.andEqualTo("pageCode", (Object)processPage);
        List processPageEntities = this.taProcessPageDao.selectByExample(example);
        if (CollectionUtil.listEmpty((List)processPageEntities)) {
            return bpmKey;
        }
        bpmKey = processPageEntities.stream().map(TaProcessPageEntity::getProcessKey).collect(Collectors.toList());
        List<TaProcessOrgEntity> orgEntities = this.taProcessOrgDao.getBpmKeyByOrg(bpmKey, orgTypes, orgCodes);
        if (CollectionUtil.listEmpty(orgEntities)) {
            return new ArrayList<String>();
        }
        bpmKey = orgEntities.stream().distinct().map(TaProcessOrgEntity::getProcessKey).collect(Collectors.toList());
        return bpmKey;
    }
}

