/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.dingtalk.api.controller;

import com.biz.eisp.activiti.HistoryFeign;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeAuthService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeAuthVo;
import com.biz.eisp.activiti.runtime.entity.TaAttachmentEntity;
import com.biz.eisp.activiti.runtime.entity.TaCommunicateContentEntity;
import com.biz.eisp.activiti.runtime.service.TaAttachmentService;
import com.biz.eisp.activiti.runtime.service.TaCommunicateService;
import com.biz.eisp.activiti.runtime.service.TaProcessInstanceService;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.vo.BusinessFormVo;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.dingtalk.api.vo.DingtalkActTaskDetail;
import com.biz.eisp.dingtalk.api.vo.DingtalkActTaskDetailReqVo;
import com.biz.eisp.dingtalk.service.DingActivitiService;
import com.biz.eisp.tk.utils.BeanCopyUtils;
import com.biz.eisp.util.ResourceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u9489\u9489H5\u6d41\u7a0b\u5ba1\u6279\u6570\u636e\u63a5\u53e3", tags={"\u9489\u9489H5\u6d41\u7a0b\u5ba1\u6279\u6570\u636e\u63a5\u53e3"})
@Controller
@RequestMapping(value={"/dingtalkActTaskController"})
public class DingtalkActTaskController {
    private static final Logger log = LoggerFactory.getLogger(DingtalkActTaskController.class);
    @Autowired
    private TaTaskService taTaskService;
    @Autowired
    private TaProcessInstanceService taProcessInstanceService;
    @Autowired
    private TaCommunicateService taCommunicateService;
    @Autowired
    private HistoryFeign historyFeign;
    @Autowired
    private TaAttachmentService taAttachmentService;
    @Autowired
    private TaProcessNodeAuthService taProcessNodeAuthService;
    @Autowired
    private ResourceService resource;
    @Autowired
    private DingActivitiService dingActivitiService;

    @ApiOperation(value="\u5ba1\u6279\u8be6\u60c5")
    @GetMapping(value={"getTaskDetail"})
    @ResponseBody
    public AjaxJson<DingtalkActTaskDetail> getTaskDetail(DingtalkActTaskDetailReqVo param) {
        MyTaskVo myTaskVo = (MyTaskVo)BeanCopyUtils.copyToBean((Object)param, MyTaskVo.class);
        DingtalkActTaskDetail data = new DingtalkActTaskDetail();
        data.setCurrPositionCode(this.resource.getCurrPosition().getPositionCode());
        MyTaskVo processVo = this.taTaskService.findProcessBasicInfoByProcinstId(myTaskVo.getProcessInstanceId());
        if (ConstantEnum.YesNoEnum.Y.getValue().equals(myTaskVo.getIsCommunicate())) {
            TaCommunicateContentEntity communicateEntity = this.taCommunicateService.getCommunicateContentById(myTaskVo.getId());
            data.setCommunicateContent(communicateEntity.getContent());
            data.setCommunicateId(communicateEntity.getId());
            processVo.setIsCommunicate(ConstantEnum.YesNoEnum.Y.getValue());
        }
        this.backNodes(data, myTaskVo);
        List logs = this.taTaskService.findApprovalLogs(myTaskVo).getObjList();
        data.setLogs(logs);
        List<TaAttachmentEntity> attachments = this.taAttachmentService.findAttachmentListByProcinstId(myTaskVo.getProcessInstanceId());
        data.setProcessVo(processVo);
        data.setAttachments(attachments);
        TaProcessNodeAuthVo nodeAuthVo = this.taProcessNodeAuthService.getNodeAuthByTaskId(myTaskVo.getTaskId());
        data.setNodeAuthVo(nodeAuthVo);
        BusinessFormVo formVo = this.taProcessInstanceService.getProcessInstanceBusinessForm(myTaskVo.getProcessInstanceId());
        if (formVo != null) {
            data.setBusinessObjId(formVo.getBusinessObjId());
        }
        AjaxJson json = new AjaxJson();
        json.setObj((Object)data);
        return json;
    }

    private void backNodes(DingtalkActTaskDetail data, MyTaskVo myTaskVo) {
        List historicTaskInstanceVos = this.historyFeign.getHistoricTaskInstanceVo(myTaskVo.getProcessInstanceId()).getObjList();
        ArrayList<Map<String, String>> backTaskIdlist = new ArrayList<Map<String, String>>();
        historicTaskInstanceVos.forEach(item -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", item.getTaskDefinitionKey());
            map.put("name", item.getName());
            backTaskIdlist.add(map);
        });
        data.setBackTaskIdlist(backTaskIdlist);
    }

    private void buildBusinessFormVo(MyTaskVo myTaskVo) {
        AjaxJson indicator;
        BusinessFormVo businessFormVo = this.taProcessInstanceService.getProcessInstanceBusinessForm(myTaskVo.getProcessInstanceId());
        String modelAndView = StringUtils.isBlank((CharSequence)myTaskVo.getTaskId()) ? businessFormVo.getModelandview() : this.taTaskService.getTaskBusinessForm(myTaskVo.getTaskId()).getModelandview();
        if (modelAndView != null) {
            modelAndView = modelAndView + "?isKeyIndicators=true&businessObjId=" + businessFormVo.getBusinessObjId();
        }
        if ((indicator = this.taTaskService.findKeyIndicators(myTaskVo)).isSuccess()) {
            Map attrs = indicator.getAttributes();
            for (String string : attrs.keySet()) {
            }
        }
    }

    @ApiOperation(value="\u5ba1\u6279\u6458\u8981")
    @GetMapping(value={"getTaskAbstract"})
    @ResponseBody
    public AjaxJson<DingtalkActTaskDetail> getTaskAbstract(String processInstanceId) {
        DingtalkActTaskDetail data = new DingtalkActTaskDetail();
        MyTaskVo processVo = this.taTaskService.findProcessBasicInfoByProcinstId(processInstanceId);
        List<TaAttachmentEntity> attachments = this.taAttachmentService.findAttachmentListByProcinstId(processInstanceId);
        data.setProcessVo(processVo);
        data.setAttachments(attachments);
        AjaxJson json = new AjaxJson();
        json.setObj((Object)data);
        return json;
    }

    @ApiOperation(value="\u6d4b\u8bd5")
    @GetMapping(value={"test"})
    @ResponseBody
    public AjaxJson<Void> test(String processInstanceId, Integer no) {
        if (no == 1) {
            this.dingActivitiService.commit(processInstanceId);
        } else if (no == 2) {
            this.dingActivitiService.pass(processInstanceId);
        } else if (no == 3) {
            this.dingActivitiService.reject(processInstanceId);
        } else if (no == 4) {
            this.dingActivitiService.rejectTarger(processInstanceId);
        }
        return new AjaxJson();
    }
}

