/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.api.controller;

import com.biz.eisp.activiti.service.ReceiveMdmService;
import com.biz.eisp.activiti.vo.GroupActivitiVo;
import com.biz.eisp.activiti.vo.MembershipActivitiVo;
import com.biz.eisp.activiti.vo.UserActivitiVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import java.util.List;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngines;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/receiveMdmController"})
public class ReceiveMdmController {
    private static final Logger log = LoggerFactory.getLogger(ReceiveMdmController.class);
    @Autowired
    private ReceiveMdmService receiveMdmService;

    @PostMapping(value={"saveUser"})
    public AjaxJson saveUser(@RequestBody UserActivitiVo userActivitiVo) {
        AjaxJson ajaxJson = new AjaxJson();
        this.receiveMdmService.saveUser(userActivitiVo);
        return ajaxJson;
    }

    @PostMapping(value={"deleteUser"})
    public AjaxJson deleteUser(@RequestParam(value="username") String username) {
        AjaxJson ajaxJson = new AjaxJson();
        ProcessEngine engine = ProcessEngines.getDefaultProcessEngine();
        IdentityService identityService = engine.getIdentityService();
        identityService.deleteUser(username);
        return ajaxJson;
    }

    @PostMapping(value={"saveUserGroup"})
    public AjaxJson saveUserGroup(@RequestBody GroupActivitiVo groupActivitiVo) {
        AjaxJson ajaxJson = new AjaxJson();
        this.receiveMdmService.saveGroup(groupActivitiVo);
        return ajaxJson;
    }

    @PostMapping(value={"deleteGroup"})
    public AjaxJson deleteGroup(@RequestParam(value="type") String type) {
        AjaxJson ajaxJson = new AjaxJson();
        ProcessEngine engine = ProcessEngines.getDefaultProcessEngine();
        IdentityService identityService = engine.getIdentityService();
        identityService.deleteGroup(type);
        return ajaxJson;
    }

    @PostMapping(value={"saveMembership"})
    public AjaxJson saveMembership(@RequestBody List<MembershipActivitiVo> membershipActivitiVos) {
        AjaxJson ajaxJson = new AjaxJson();
        membershipActivitiVos.forEach(item -> this.receiveMdmService.saveMembership((MembershipActivitiVo)item));
        return ajaxJson;
    }

    @PostMapping(value={"deleteMembership"})
    public AjaxJson deleteMembership(@RequestBody List<MembershipActivitiVo> membershipActivitiVos) {
        AjaxJson ajaxJson = new AjaxJson();
        ProcessEngine engine = ProcessEngines.getDefaultProcessEngine();
        IdentityService identityService = engine.getIdentityService();
        membershipActivitiVos.forEach(item -> identityService.deleteMembership(item.getPosCode(), item.getRoleCode()));
        return ajaxJson;
    }
}

