/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.businessconf.service.impl;

import com.biz.eisp.activiti.designer.businessconf.dao.TaBusinessObjDao;
import com.biz.eisp.activiti.designer.businessconf.dao.TaProcessBusinessObjConfigDao;
import com.biz.eisp.activiti.designer.businessconf.entity.TaBusinessObjEntity;
import com.biz.eisp.activiti.designer.businessconf.entity.TaProcessBusinessObjConfigEntity;
import com.biz.eisp.activiti.designer.businessconf.service.TaProcessBusinessObjConfigService;
import com.biz.eisp.activiti.designer.businessconf.transformer.TaProcessBusinessObjConfigVoToEntity;
import com.biz.eisp.activiti.designer.businessconf.vo.TaProcessBusinessObjConfigVo;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessDao;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="taProcessBusinessObjService")
@Transactional
public class TaProcessBusinessObjServiceImpl
implements TaProcessBusinessObjConfigService {
    @Autowired
    private TaProcessBusinessObjConfigDao taProcessBusinessObjConfigDao;
    @Autowired
    private TaProcessDao processDao;
    @Autowired
    private TaBusinessObjDao businessObjDao;

    @Override
    public TaProcessBusinessObjConfigEntity getConfigByProcessKey(String className, String processKey) {
        TaProcessEntity processRecord = new TaProcessEntity();
        processRecord.setProcessKey(processKey);
        TaProcessEntity processEntity = (TaProcessEntity)this.processDao.selectOne(processRecord);
        TaBusinessObjEntity objRecord = new TaBusinessObjEntity();
        objRecord.setEntityName(className);
        TaBusinessObjEntity objEntity = (TaBusinessObjEntity)this.businessObjDao.selectOne(objRecord);
        if (processEntity != null && objEntity != null) {
            TaProcessBusinessObjConfigEntity record = new TaProcessBusinessObjConfigEntity();
            record.setBusinessObjId(objEntity.getId());
            record.setProcessId(processEntity.getId());
            return (TaProcessBusinessObjConfigEntity)this.taProcessBusinessObjConfigDao.selectOne(record);
        }
        return new TaProcessBusinessObjConfigEntity();
    }

    @Override
    public TaProcessBusinessObjConfigEntity getConfigById(String id) {
        return (TaProcessBusinessObjConfigEntity)this.taProcessBusinessObjConfigDao.selectByPrimaryKey(id);
    }

    @Override
    public PageInfo<TaProcessBusinessObjConfigVo> findConfigByProcessId(String taProcessId, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.taProcessBusinessObjConfigDao.findConfigByProcessId(taProcessId), (Page)page);
    }

    @Override
    public TaProcessBusinessObjConfigEntity saveOrUpdateConfig(TaProcessBusinessObjConfigVo vo) {
        TaProcessBusinessObjConfigEntity one = new TaProcessBusinessObjConfigVoToEntity().apply(vo);
        if (StringUtil.isEmpty((String)vo.getId())) {
            this.taProcessBusinessObjConfigDao.insertSelective(one);
        } else {
            this.taProcessBusinessObjConfigDao.updateByPrimaryKeySelective(one);
        }
        return one;
    }

    @Override
    public void deleteConfig(String id) {
        this.taProcessBusinessObjConfigDao.deleteByPrimaryKey(id);
    }

    @Override
    public void validateBusinessName(String id, String businessName) {
        Example example = new Example(TaProcessBusinessObjConfigEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isEmpty((String)id)) {
            criteria.andEqualTo("businessName", (Object)businessName);
        } else {
            criteria.andEqualTo("businessName", (Object)businessName);
            criteria.andNotEqualTo("id", (Object)id);
        }
        List result = this.taProcessBusinessObjConfigDao.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)result)) {
            throw new BusinessException("\u4e1a\u52a1\u540d\u79f0\u5df2\u5b58\u5728");
        }
    }
}

