/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.activiti.designer.processconf.dao.ActTargetContentDao;
import com.biz.eisp.activiti.designer.processconf.entity.ActTargetContentEntity;
import com.biz.eisp.activiti.designer.processconf.service.ActTargetContentExtendService;
import com.biz.eisp.activiti.designer.processconf.service.ActTargetContentService;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(rollbackFor={Exception.class})
public class ActTargetContentServiceImpl
implements ActTargetContentService {
    @Autowired
    private ActTargetContentDao actTargetContentDao;
    @Autowired(required=false)
    private ActTargetContentExtendService actTargetContentExtendService;

    @Override
    public List<ActTargetContentEntity> getActTargetContentList(String processInstanceId) {
        if (StringUtil.isEmpty((String)processInstanceId)) {
            return new ArrayList<ActTargetContentEntity>();
        }
        Example example = new Example(ActTargetContentEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("processInstanceId", (Object)processInstanceId);
        List entities = this.actTargetContentDao.selectByExample(example);
        return entities;
    }

    @Override
    public AjaxJson getTargetConfigJson(String processInstanceId) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)processInstanceId)) {
            ajaxJson.setErrMsg("\u672a\u8bbe\u7f6e\u5173\u952e\u6307\u6807");
            return ajaxJson;
        }
        List<Object> entities = new ArrayList();
        entities = this.actTargetContentExtendService != null ? this.actTargetContentExtendService.getActTargetContentList(processInstanceId) : this.getActTargetContentList(processInstanceId);
        if (CollectionUtil.listNotEmptyNotSizeZero(entities)) {
            ActTargetContentEntity entity = (ActTargetContentEntity)entities.get(0);
            String targetText = entity.getTargetText();
            JSONObject object = JSONObject.parseObject((String)targetText);
            ajaxJson.setObj((Object)object);
        } else {
            ajaxJson.setErrMsg("\u672a\u8bbe\u7f6e\u5173\u952e\u6307\u6807");
        }
        return ajaxJson;
    }
}

