/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.service.impl;

import com.biz.eisp.activiti.designer.processconf.dao.TaListenerDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaRProcessNodeListenerDao;
import com.biz.eisp.activiti.designer.processconf.entity.TaListenerEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaRProcessNodeListenerEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaListenerService;
import com.biz.eisp.activiti.designer.processconf.vo.TaListenerVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.github.pagehelper.PageInfo;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="taListenerService")
@Transactional
public class TaListenerServiceImpl
implements TaListenerService {
    @Autowired
    private TaListenerDao taListenerDao;
    @Autowired
    private TaRProcessNodeListenerDao taRProcessNodeListenerDao;

    @Override
    public List<TaListenerEntity> findTaListenerList(TaListenerVo taListener) {
        return this.taListenerDao.findTaListenerList(taListener);
    }

    @Override
    public PageInfo<TaListenerEntity> findTaListenerPageList(TaListenerVo taListener, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.taListenerDao.findTaListenerList(taListener), (Page)page);
    }

    @Override
    public PageInfo<TaListenerEntity> findTaListenerList(String ids, Page page) {
        Example examplerec = new Example(TaListenerEntity.class);
        Example.Criteria criteriarc = examplerec.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            String[] newIds = ids.split(",");
            criteriarc.andIn("id", Arrays.asList(newIds));
        } else {
            criteriarc.andIsNull("id");
        }
        PageInfo info = PageAutoHelperUtil.generatePage(() -> this.taListenerDao.selectByExample(examplerec), (Page)page);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)info.getList())) {
            List list = info.getList();
            for (TaListenerEntity entity : list) {
                TaRProcessNodeListenerEntity node = new TaRProcessNodeListenerEntity();
                node.setListenerId(entity.getId());
                entity.setTaRProcessNodeListenerEntityList(this.taRProcessNodeListenerDao.select(node));
            }
        }
        return info;
    }

    @Override
    public void saveTaListener(TaListenerEntity taListener) {
        if (StringUtils.isBlank((CharSequence)taListener.getId())) {
            taListener.setListenerState(Short.valueOf(Short.parseShort("0")));
            this.taListenerDao.insertSelective(taListener);
        } else {
            this.taListenerDao.updateByPrimaryKeySelective(taListener);
        }
    }

    @Override
    public TaListenerEntity getTaListener(String id) {
        TaListenerEntity entity = (TaListenerEntity)this.taListenerDao.selectByPrimaryKey(id);
        TaRProcessNodeListenerEntity node = new TaRProcessNodeListenerEntity();
        node.setListenerId(entity.getId());
        entity.setTaRProcessNodeListenerEntityList(this.taRProcessNodeListenerDao.select(node));
        return entity;
    }

    @Override
    public void deleteListenerById(String ids) {
        if (StringUtil.isNotEmpty((CharSequence)ids)) {
            String[] idsArr;
            for (String id : idsArr = ids.split(",")) {
                this.taListenerDao.deleteByPrimaryKey(id);
            }
        }
    }

    @Override
    public String toggleListenerState(String ids, String listenerState) {
        String[] idsArr;
        String message = "\u64cd\u4f5c\u6210\u529f";
        for (String id : idsArr = ids.split(",")) {
            TaListenerEntity entity = (TaListenerEntity)this.taListenerDao.selectByPrimaryKey(id);
            if (entity == null) continue;
            entity.setListenerState(Short.valueOf(listenerState));
            this.taListenerDao.updateByPrimaryKeySelective(entity);
        }
        return message;
    }

    @Override
    public void checkListenerExist(TaListenerVo taListenerVo) {
        Example example = new Example(TaListenerEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)taListenerVo.getId())) {
            criteria.andNotEqualTo("id", (Object)taListenerVo.getId());
        }
        criteria.andEqualTo("listenerName", (Object)taListenerVo.getListenerName());
        int count = this.taListenerDao.selectCountByExample(example);
        if (count > 0) {
            throw new BusinessException("\u76d1\u542c\u540d\u79f0\u5df2\u5b58\u5728");
        }
    }

    @Override
    public PageInfo<TaListenerEntity> findListenerRelatedByNode(Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.taRProcessNodeListenerDao.findAllListenerRelatedByNode(), (Page)page);
    }
}

