/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.service.impl;

import com.biz.eisp.activiti.designer.processconf.dao.TaProcessDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessNodeAuthProDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessNodeDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessNodeProDao;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeAuthProEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeProEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.designer.processconf.transformer.TaProcessNodeEntityToTaProcessNodeVo;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="taProcessNodeService")
@Transactional
public class TaProcessNodeServiceImpl
implements TaProcessNodeService {
    @Autowired
    private TaProcessNodeDao taProcessNodeDao;
    @Autowired
    private TaProcessDao taProcessDao;
    @Autowired
    private TaProcessNodeProDao taProcessNodeProDao;
    @Autowired
    private TaProcessNodeAuthProDao taProcessNodeAuthProDao;

    @Override
    public TaProcessNodeEntity getTaProcessNodeEntity(String taskDefinitionKey, String processkey) {
        TaProcessEntity entity = new TaProcessEntity();
        entity.setProcessKey(processkey);
        TaProcessEntity result = (TaProcessEntity)this.taProcessDao.selectOne(entity);
        TaProcessNodeEntity nodeEntity = new TaProcessNodeEntity();
        nodeEntity.setProcessId(result.getId());
        nodeEntity.setProcessNodeCode(taskDefinitionKey);
        List entityList = this.taProcessNodeDao.select(nodeEntity);
        if (entityList != null && entityList.size() > 0) {
            return (TaProcessNodeEntity)entityList.get(0);
        }
        return null;
    }

    @Override
    public PageInfo<TaProcessNodeEntity> getNodeByProcessId(String processId, Page page) {
        Example examplerec = new Example(TaProcessNodeEntity.class);
        Example.Criteria criteriarc = examplerec.createCriteria();
        criteriarc.andEqualTo("processId", (Object)processId);
        examplerec.setOrderByClause("sort asc");
        PageInfo info = PageAutoHelperUtil.generatePage(() -> this.taProcessNodeDao.selectByExample(examplerec), (Page)page);
        if (info != null && CollectionUtil.listNotEmptyNotSizeZero((List)info.getList())) {
            List list = info.getList();
            for (TaProcessNodeEntity entity : list) {
                TaProcessEntity result = (TaProcessEntity)this.taProcessDao.selectByPrimaryKey(entity.getProcessId());
                entity.setProcessName(result.getProcessName());
            }
        }
        return info;
    }

    @Override
    public List<TaProcessNodeVo> getNodeByProcessId(String processId) {
        TaProcessNodeEntity node = new TaProcessNodeEntity();
        node.setProcessId(processId);
        List list = this.taProcessNodeDao.select(node);
        TaProcessEntity rl = (TaProcessEntity)this.taProcessDao.selectByPrimaryKey(processId);
        ArrayList<TaProcessNodeVo> result = new ArrayList<TaProcessNodeVo>();
        for (TaProcessNodeEntity entity : list) {
            entity.setTaProcessEntity(rl);
            TaProcessNodeVo vo = new TaProcessNodeEntityToTaProcessNodeVo().apply(entity);
            result.add(vo);
        }
        result.forEach(item -> {
            item.setNullJumpNode("Y");
            item.setDuplicateJumpNode("Y");
        });
        return result;
    }

    @Override
    public List<TaProcessNodeEntity> getNodeEntityByProcessId(String processId) {
        TaProcessNodeEntity node = new TaProcessNodeEntity();
        node.setProcessId(processId);
        List list = this.taProcessNodeDao.select(node);
        TaProcessEntity rl = new TaProcessEntity();
        ArrayList result = new ArrayList();
        for (TaProcessNodeEntity entity : list) {
            entity.setTaProcessEntity(rl);
        }
        return list;
    }

    @Override
    public void validateNode(TaProcessNodeVo nodeVo) {
        if (StringUtil.isNotEmpty((CharSequence)nodeVo.getId())) {
            int count;
            Example.Criteria criteriarc;
            Example example;
            if ("1".equals(nodeVo.getFlag())) {
                example = new Example(TaProcessNodeEntity.class);
                criteriarc = example.createCriteria();
                criteriarc.andEqualTo("processNodeCode", (Object)nodeVo.getProcessNodeCode());
                criteriarc.andNotEqualTo("id", (Object)nodeVo.getId());
                count = this.taProcessNodeDao.selectCountByExample(example);
                if (count > 0) {
                    throw new BusinessException("\u8282\u70b9\u7f16\u7801\u5df2\u5b58\u5728");
                }
            }
            if ("0".equals(nodeVo.getFlag())) {
                example = new Example(TaProcessNodeEntity.class);
                criteriarc = example.createCriteria();
                criteriarc.andEqualTo("processNodeName", (Object)nodeVo.getProcessNodeName());
                criteriarc.andNotEqualTo("id", (Object)nodeVo.getId());
                criteriarc.andEqualTo("processId", (Object)nodeVo.getTaProcessId());
                count = this.taProcessNodeDao.selectCountByExample(example);
                if (count > 0) {
                    throw new BusinessException("\u8282\u70b9\u540d\u79f0\u5df2\u5b58\u5728");
                }
            }
        } else {
            int count;
            Example.Criteria criteriarc;
            Example example;
            if ("1".equals(nodeVo.getFlag())) {
                example = new Example(TaProcessNodeEntity.class);
                criteriarc = example.createCriteria();
                criteriarc.andEqualTo("processNodeCode", (Object)nodeVo.getProcessNodeCode());
                count = this.taProcessNodeDao.selectCountByExample(example);
                if (count > 0) {
                    throw new BusinessException("\u8282\u70b9\u7f16\u7801\u5df2\u5b58\u5728");
                }
            }
            if ("0".equals(nodeVo.getFlag())) {
                example = new Example(TaProcessNodeEntity.class);
                criteriarc = example.createCriteria();
                criteriarc.andEqualTo("processNodeName", (Object)nodeVo.getProcessNodeName());
                count = this.taProcessNodeDao.selectCountByExample(example);
                if (count > 0) {
                    throw new BusinessException("\u8282\u70b9\u540d\u79f0\u5df2\u5b58\u5728");
                }
            }
        }
    }

    @Override
    public TaProcessNodeProEntity getTaProcessNodeByVersionKey(String processVersion, String taskDefinitionKey) {
        TaProcessNodeProEntity pro = new TaProcessNodeProEntity();
        pro.setProcessNodeCode(taskDefinitionKey);
        pro.setProcDefId(processVersion);
        List entityList = this.taProcessNodeProDao.select(pro);
        if (entityList != null && entityList.size() > 0) {
            return (TaProcessNodeProEntity)entityList.get(0);
        }
        return new TaProcessNodeProEntity();
    }

    @Override
    public TaProcessNodeAuthProEntity getTaProcessNodeAuthEntity(String processVersion, String processNodeId) {
        TaProcessNodeAuthProEntity pro = new TaProcessNodeAuthProEntity();
        pro.setProcessNodeId(processNodeId);
        pro.setProcDefId(processVersion);
        List entityList = this.taProcessNodeAuthProDao.select(pro);
        if (entityList != null && entityList.size() > 0) {
            return (TaProcessNodeAuthProEntity)entityList.get(0);
        }
        return new TaProcessNodeAuthProEntity();
    }

    @Override
    public TaProcessNodeVo getNodeById(String id) {
        TaProcessNodeEntity entity = (TaProcessNodeEntity)this.taProcessNodeDao.selectByPrimaryKey(id);
        String processId = entity.getProcessId();
        TaProcessEntity processEntity = (TaProcessEntity)this.taProcessDao.selectByPrimaryKey(processId);
        entity.setTaProcessEntity(processEntity);
        return new TaProcessNodeEntityToTaProcessNodeVo().apply(entity);
    }

    @Override
    public void deleteProcessNodeById(String id) {
        this.taProcessNodeDao.deleteByPrimaryKey(id);
    }

    @Override
    public void saveProcessNode(TaProcessNodeVo vo) {
        TaProcessNodeEntity entity = new TaProcessNodeEntity();
        MyBeanUtils.apply((Object)vo, (Object)entity);
        entity.setProcessId(vo.getTaProcessId());
        if (StringUtil.isEmpty((String)vo.getId())) {
            this.taProcessNodeDao.insertSelective(entity);
        } else {
            this.taProcessNodeDao.updateByPrimaryKeySelective(entity);
        }
    }
}

