/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.listener.task;

import com.biz.eisp.activiti.runtime.dao.TaBaseBusinessObjQueryDao;
import com.biz.eisp.activiti.runtime.dao.TaCopyDao;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjQueryEntity;
import com.biz.eisp.activiti.runtime.entity.TaCarbonCopyEntity;
import com.biz.eisp.activiti.runtime.entity.TaCopyEntity;
import com.biz.eisp.activiti.runtime.service.TaCarbonCopyService;
import com.biz.eisp.activiti.runtime.vo.TaCarbonCopyVo;
import com.biz.eisp.api.feign.RoleActivitiFeign;
import com.biz.eisp.api.feign.TmPositionFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.config.SpringApplicationContextUtil;
import com.biz.eisp.position.TmPositionVo;
import java.util.HashSet;
import java.util.List;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.lang.StringUtils;

public class CarbonCopyListener
implements ExecutionListener {
    private static final long serialVersionUID = 1230733149844003676L;
    private TaCarbonCopyService taCarbonCopyService = (TaCarbonCopyService)SpringApplicationContextUtil.getApplicationContext().getBean("taCarbonCopyService");
    private RepositoryService repositoryService = (RepositoryService)SpringApplicationContextUtil.getApplicationContext().getBean(RepositoryService.class);
    private HistoryService historyService = (HistoryService)SpringApplicationContextUtil.getApplicationContext().getBean(HistoryService.class);
    private TaCopyDao taCopyDao = (TaCopyDao)SpringApplicationContextUtil.getApplicationContext().getBean(TaCopyDao.class);
    private TaBaseBusinessObjQueryDao taBaseBusinessObjQueryDao = (TaBaseBusinessObjQueryDao)SpringApplicationContextUtil.getApplicationContext().getBean(TaBaseBusinessObjQueryDao.class);
    private RoleActivitiFeign roleActivitiFeign = (RoleActivitiFeign)SpringApplicationContextUtil.getApplicationContext().getBean(RoleActivitiFeign.class);
    private TmPositionFeign tmPositionFeign = (TmPositionFeign)SpringApplicationContextUtil.getApplicationContext().getBean(TmPositionFeign.class);

    public void notify(DelegateExecution execution) throws Exception {
        String formType = (String)execution.getVariable("FROM_TYPE");
        if (StringUtils.isNotBlank((String)formType) && "PROCESS_PASS_CHECK".equals(formType)) {
            return;
        }
        Object isAbort = execution.getVariable("aborts");
        if (isAbort == null) {
            this.carbonCopy(execution);
        }
    }

    private void carbonCopy(DelegateExecution execution) {
        String piId = execution.getProcessInstanceId();
        String pdId = execution.getProcessDefinitionId();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(pdId).singleResult();
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(piId).singleResult();
        String businessKey = hpi.getBusinessKey();
        TaBaseBusinessObjQueryEntity businessObjEntity = (TaBaseBusinessObjQueryEntity)this.taBaseBusinessObjQueryDao.selectByPrimaryKey(businessKey);
        String positionId = businessObjEntity.getPositionId();
        TmPositionVo positionVo = (TmPositionVo)ApiResultUtil.objResult((AjaxJson)this.tmPositionFeign.getPosition(positionId, null), (boolean)true);
        String processKey = processDefinition.getKey();
        String processName = processDefinition.getName();
        TaCarbonCopyVo query = new TaCarbonCopyVo();
        query.setTaProcessKey(processKey);
        List ccs = this.taCarbonCopyService.findTaCarbonCopy(query, null).getObjList();
        HashSet<String> innertPosition = new HashSet<String>();
        for (TaCarbonCopyEntity vo : ccs) {
            String state = vo.getState();
            String code = vo.getCode();
            if (state.equals("0")) {
                List positions = ApiResultUtil.listResult((AjaxJson)this.tmPositionFeign.findPositionAndOrgByRoleCode(code));
                for (TmPositionVo tm : positions) {
                    innertPosition.add(tm.getPositionCode());
                }
                break;
            }
            if (!state.equals("1")) continue;
            innertPosition.add(code);
        }
        for (String str : innertPosition) {
            TaCopyEntity copy = new TaCopyEntity();
            copy.setBusinessKey(businessKey);
            copy.setProcessInstanceId(piId);
            copy.setProcessName(processName);
            copy.setProcessKey(processKey);
            copy.setProcessTitle(businessObjEntity.getProcessTitle());
            copy.setCopyCode(str);
            copy.setCopyName("\u7cfb\u7edf");
            copy.setViewStatus("0");
            copy.setCreateProcessPositionCode(positionVo.getPositionCode());
            copy.setCreateProcessPositionName(positionVo.getPositionName());
            this.taCopyDao.insertSelective(copy);
        }
    }
}

