/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.runtime.dao.TaAgencyApprovalDao;
import com.biz.eisp.activiti.runtime.entity.TaAgencyApprovalEntity;
import com.biz.eisp.activiti.runtime.service.TaAgencyApprovalService;
import com.biz.eisp.activiti.runtime.vo.TaAgencyApprovalVo;
import com.biz.eisp.api.feign.TmPositionFeign;
import com.biz.eisp.api.feign.TmUserFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.user.TmUserQueryVo;
import com.biz.eisp.user.TmUserVo;
import com.biz.eisp.util.ResourceService;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="taAgencyApprovalService")
@Transactional
public class TaAgencyApprovalServiceImpl
implements TaAgencyApprovalService {
    @Autowired
    private TaAgencyApprovalDao taAgencyApprovalDao;
    @Autowired
    private TmUserFeign tmUserFeign;
    @Autowired
    private ResourceService resource;
    @Autowired
    private TmPositionFeign tmPositionFeign;

    @Override
    public List<TaAgencyApprovalEntity> findTaAgencyApprovalList(TaAgencyApprovalVo vo) {
        Example example = new Example(TaAgencyApprovalEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)vo.getUserId())) {
            criteria.andEqualTo("userId", (Object)vo.getUserId());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getUsername())) {
            criteria.andEqualTo("username", (Object)vo.getUsername());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getFullname())) {
            criteria.andEqualTo("fullname", (Object)vo.getFullname());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getRepresentedUserName())) {
            criteria.andEqualTo("representedUserName", (Object)vo.getRepresentedUserName());
        }
        return this.taAgencyApprovalDao.selectByExample(example);
    }

    @Override
    public PageInfo<TaAgencyApprovalEntity> findTaAgencyApprovalPageList(TaAgencyApprovalVo vo, Page page) {
        Example example = new Example(TaAgencyApprovalEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)vo.getUserId())) {
            criteria.andEqualTo("userId", (Object)vo.getUserId());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getUsername())) {
            criteria.andEqualTo("username", (Object)vo.getUsername());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getFullname())) {
            criteria.andEqualTo("fullname", (Object)vo.getFullname());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getRepresentedUserName())) {
            criteria.andEqualTo("representedUserName", (Object)vo.getRepresentedUserName());
        }
        return PageAutoHelperUtil.generatePage(() -> this.taAgencyApprovalDao.selectByExample(example), (Page)page);
    }

    @Override
    public void save(TaAgencyApprovalVo vo) throws Exception {
        TaAgencyApprovalEntity entity = new TaAgencyApprovalEntity();
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            TmPositionVo positionEntity = this.resource.getCurrPosition();
            entity.setRepresentedUserName(this.resource.getUserVo().getUsername());
            entity.setRepresentedPositionCode(positionEntity.getPositionCode());
            entity.setRepresentedPositionName(positionEntity.getPositionName());
            this.taAgencyApprovalDao.insertSelective(entity);
        }
    }

    @Override
    public void update(TaAgencyApprovalVo vo) throws Exception {
        TaAgencyApprovalEntity entity = null;
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = (TaAgencyApprovalEntity)this.taAgencyApprovalDao.selectByPrimaryKey(vo.getId());
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            this.taAgencyApprovalDao.updateByPrimaryKeySelective(entity);
        }
    }

    @Override
    public boolean delete(String id) {
        int i = this.taAgencyApprovalDao.deleteByPrimaryKey(id);
        return i > 0;
    }

    @Override
    public AjaxJson addAgencyApproval(String userIds, String beginTime, String endTime) {
        String userId;
        String[] userIdArr;
        AjaxJson ajaxJson = new AjaxJson();
        String[] stringArray = userIdArr = userIds.split(",");
        int n = stringArray.length;
        for (int i = 0; i < n && (ajaxJson = this.addAgencyApprovalItem(userId = stringArray[i], beginTime, endTime)).isSuccess(); ++i) {
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson saveAgencyApprovalTime(String beginTime, String endTime) {
        AjaxJson ajaxJson = new AjaxJson();
        TaAgencyApprovalVo taAgencyApprovalVo = new TaAgencyApprovalVo();
        taAgencyApprovalVo.setRepresentedUserName(this.resource.getUserVo().getUsername());
        List<TaAgencyApprovalEntity> list = this.findTaAgencyApprovalList(taAgencyApprovalVo);
        list.forEach(item -> {
            item.setBeginTime(beginTime);
            item.setEndTime(endTime);
        });
        int i = this.taAgencyApprovalDao.updateBatchByPrimaryKeySelective(list);
        if (i > 0) {
            return ajaxJson;
        }
        ajaxJson.setSuccess(false);
        ajaxJson.setMsg("\u4fdd\u5b58\u65f6\u95f4\u5931\u8d25");
        return ajaxJson;
    }

    private AjaxJson addAgencyApprovalItem(String userId, String beginTime, String endTime) {
        AjaxJson j = new AjaxJson();
        TmUserQueryVo tmUserQueryVo = new TmUserQueryVo();
        tmUserQueryVo.setId(userId);
        AjaxJson ajaxJson = this.tmUserFeign.getTmUser(tmUserQueryVo);
        if (null != ajaxJson.getObj()) {
            TmUserVo tmUserVo = (TmUserVo)ajaxJson.getObj();
            Example example = new Example(TaAgencyApprovalEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("userId", (Object)userId);
            List taAgencyApprovalEntityList = this.taAgencyApprovalDao.selectByExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)taAgencyApprovalEntityList)) {
                j.setSuccess(false);
                j.setMsg("\u7528\u6237\u8d26\u53f7\u4e3a" + tmUserVo.getUsername() + "\u7684\u7528\u6237\u5df2\u7ecf\u6dfb\u52a0\u4ee3\u7406\u5ba1\u6279\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
            } else {
                TaAgencyApprovalEntity taAgencyApprovalEntity = new TaAgencyApprovalEntity();
                AjaxJson tmPositionVoAjaxJson = this.tmPositionFeign.getUserMainPositon(tmUserVo.getUsername(), tmUserVo.getUserId());
                if (StringUtil.isNotEmpty((Object)tmPositionVoAjaxJson.getObj())) {
                    taAgencyApprovalEntity.setAgentPositionCode(((TmPositionVo)tmPositionVoAjaxJson.getObj()).getPositionCode());
                    taAgencyApprovalEntity.setAgentPositionName(((TmPositionVo)tmPositionVoAjaxJson.getObj()).getPositionName());
                }
                taAgencyApprovalEntity.setUserId(tmUserVo.getId());
                taAgencyApprovalEntity.setFullname(tmUserVo.getFullname());
                taAgencyApprovalEntity.setUsername(tmUserVo.getUsername());
                taAgencyApprovalEntity.setBeginTime(beginTime);
                taAgencyApprovalEntity.setEndTime(endTime);
                TmPositionVo positionEntity = this.resource.getCurrPosition();
                taAgencyApprovalEntity.setRepresentedUserName(this.resource.getUserVo().getUsername());
                taAgencyApprovalEntity.setRepresentedPositionCode(positionEntity.getPositionCode());
                taAgencyApprovalEntity.setRepresentedPositionName(positionEntity.getPositionName());
                this.taAgencyApprovalDao.insertSelective(taAgencyApprovalEntity);
            }
        }
        return j;
    }

    @Override
    public void deleteAgencyApproval(String ids) {
        String[] idArr;
        for (String id : idArr = ids.split(",")) {
            TaAgencyApprovalEntity entity = (TaAgencyApprovalEntity)this.taAgencyApprovalDao.selectByPrimaryKey(id);
            this.taAgencyApprovalDao.delete(entity);
        }
    }

    @Override
    public List<TaAgencyApprovalEntity> getAgencyApprovalByPoscodes(List<String> posCodes, String date) {
        Example example = new Example(TaAgencyApprovalEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("agentPositionCode", posCodes);
        criteria.andGreaterThanOrEqualTo("endTime", (Object)date);
        criteria.andLessThanOrEqualTo("beginTime", (Object)date);
        return this.taAgencyApprovalDao.selectByExample(example);
    }
}

