/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.businessconf.dao.TaProcessVariableDao;
import com.biz.eisp.activiti.designer.businessconf.entity.TaProcessVariableEntity;
import com.biz.eisp.activiti.designer.businessconf.entity.TaProcessVariableProEntity;
import com.biz.eisp.activiti.designer.processconf.dao.ActTargetConfigDao;
import com.biz.eisp.activiti.designer.processconf.dao.ActTargetConfigProDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessNodeAuthDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessNodeAuthProDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessNodeDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessNodeProDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessProDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessVariableProDao;
import com.biz.eisp.activiti.designer.processconf.dao.TaRRoleProcDefDao;
import com.biz.eisp.activiti.designer.processconf.entity.ActTargetConfigEntity;
import com.biz.eisp.activiti.designer.processconf.entity.ActTargetConfigProEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeAuthEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeAuthProEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeProEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessProEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaRRoleProcDefEntity;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessVo;
import com.biz.eisp.activiti.runtime.dao.TaDeploymentDao;
import com.biz.eisp.activiti.runtime.service.TaDeploymentService;
import com.biz.eisp.base.IdEntity;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StreamUtils;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.github.pagehelper.PageInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.DeploymentBuilder;
import org.activiti.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="taDeploymentService")
@Transactional
public class TaDeploymentServiceImpl
implements TaDeploymentService {
    private static final Logger log = LoggerFactory.getLogger(TaDeploymentServiceImpl.class);
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private TaDeploymentDao taDeploymentDao;
    @Autowired
    private TaProcessDao taProcessDao;
    @Autowired
    private TaRRoleProcDefDao taRRoleProcDefDao;
    @Autowired
    private TaProcessProDao taProcessProDao;
    @Autowired
    private TaProcessNodeDao taProcessNodeDao;
    @Autowired
    private TaProcessNodeProDao taProcessNodeProDao;
    @Autowired
    private TaProcessVariableDao taprocessvariableDao;
    @Autowired
    private TaProcessVariableProDao taProcessVariableProDao;
    @Autowired
    private TaProcessNodeAuthDao taProcessNodeAuthDao;
    @Autowired
    private TaProcessNodeAuthProDao taProcessNodeAuthProDao;
    @Autowired
    private ActTargetConfigDao actTargetConfigDao;
    @Autowired
    private ActTargetConfigProDao actTargetConfigProDao;

    @Override
    public void deployProcess(String processId) {
        TaProcessEntity process = (TaProcessEntity)this.taProcessDao.selectByPrimaryKey(processId);
        if (process == null) {
            throw new BusinessException("\u672a\u627e\u5230\u6d41\u7a0b\u8bbe\u8ba1ID");
        }
        Deployment deployment = this.deploy(process);
        this.saveTaRRoleProcDef(deployment);
        process.setProcessState(WorkFlowGlobals.PROCESS_DEPLOY_YES);
        this.taProcessDao.updateByPrimaryKeySelective(process);
    }

    private Deployment deploy(TaProcessEntity process) {
        Deployment deployment = null;
        try {
            DeploymentBuilder builder = this.repositoryService.createDeployment();
            builder.addInputStream(process.getProcessKey() + ".bpmn", StreamUtils.byteTOInputStream((byte[])process.getProcessXml())).name(process.getProcessKey());
            deployment = builder.deploy();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new BusinessException("\u53d1\u5e03\u5931\u8d25");
        }
        return deployment;
    }

    private void saveTaRRoleProcDef(Deployment deployment) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinition.getId());
        Map taskDefinitionMap = processDefinitionEntity.getTaskDefinitions();
        Set taskKeySet = taskDefinitionMap.keySet();
        for (String key : taskKeySet) {
            TaskDefinition td = (TaskDefinition)taskDefinitionMap.get(key);
            Set candidateGroupIdSet = td.getCandidateGroupIdExpressions();
            for (Expression expression : candidateGroupIdSet) {
                String value = expression.getExpressionText();
                TaRRoleProcDefEntity taRRoleProcDefEntity = this.getTaRRoleProcDefEntity(deployment.getId(), value);
                if (taRRoleProcDefEntity != null) continue;
                taRRoleProcDefEntity = new TaRRoleProcDefEntity();
                taRRoleProcDefEntity.setDeploymentId(deployment.getId());
                taRRoleProcDefEntity.setRoleCode(value);
                this.taRRoleProcDefDao.insertSelective(taRRoleProcDefEntity);
            }
        }
        String procDefId = processDefinition.getId();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("procDefId", procDefId);
        map.put("processKey", processDefinition.getKey());
        Example exampleProcess = new Example(TaProcessEntity.class);
        Example.Criteria criteriaProcess = exampleProcess.createCriteria();
        criteriaProcess.andEqualTo("processKey", (Object)processDefinition.getKey());
        List taProcessEntities = this.taProcessDao.selectByExample(exampleProcess);
        TaProcessEntity taProcessEntity = null;
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)taProcessEntities)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        taProcessEntity = (TaProcessEntity)taProcessEntities.get(0);
        String processId = taProcessEntity.getId();
        Example exampleProcess1 = new Example(TaProcessEntity.class);
        Example.Criteria criteriaProcess1 = exampleProcess1.createCriteria();
        criteriaProcess1.andEqualTo("id", (Object)processId);
        List taProcessEntities1 = this.taProcessDao.selectByExample(exampleProcess1);
        List ids1 = taProcessEntities1.stream().map(TaProcessEntity::getId).collect(Collectors.toList());
        Example exampleTaProcessPro = new Example(TaProcessProEntity.class);
        Example.Criteria criteriaTaProcessPro = exampleTaProcessPro.createCriteria();
        criteriaTaProcessPro.andIn("id", ids1);
        criteriaTaProcessPro.andEqualTo("procDefId", (Object)processDefinition.getId());
        List taProcessProEntities = this.taProcessProDao.selectByExample(exampleTaProcessPro);
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)taProcessProEntities)) {
            TaProcessProEntity entity = new TaProcessProEntity();
            BeanUtils.copyProperties((Object)taProcessEntity, (Object)entity);
            entity.setProcDefId(procDefId);
            this.taProcessProDao.insertSelective(entity);
        }
        Example exampleProcessNode = new Example(TaProcessNodeEntity.class);
        Example.Criteria criteriaProcessNode = exampleProcessNode.createCriteria();
        criteriaProcessNode.andEqualTo("processId", (Object)processId);
        List taProcessNodeEntities = this.taProcessNodeDao.selectByExample(exampleProcessNode);
        boolean insterFalg = false;
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)taProcessNodeEntities)) {
            insterFalg = false;
        } else {
            List ids = taProcessNodeEntities.stream().map(IdEntity::getId).collect(Collectors.toList());
            Example exampleProcessNodePro = new Example(TaProcessNodeProEntity.class);
            Example.Criteria criteriaProcessNodePro = exampleProcessNodePro.createCriteria();
            criteriaProcessNodePro.andIn("id", ids);
            criteriaProcessNodePro.andEqualTo("procDefId", (Object)processDefinition.getId());
            List taProcessNodeProEntities = this.taProcessNodeProDao.selectByExample(exampleProcessNodePro);
            if (!CollectionUtil.listNotEmptyNotSizeZero((List)taProcessNodeProEntities)) {
                insterFalg = true;
            }
        }
        if (insterFalg) {
            taProcessNodeEntities.forEach(item -> {
                TaProcessNodeProEntity taProcessNodeProEntity = new TaProcessNodeProEntity();
                BeanUtils.copyProperties((Object)item, (Object)taProcessNodeProEntity);
                taProcessNodeProEntity.setProcDefId(procDefId);
                this.taProcessNodeProDao.insertSelective(taProcessNodeProEntity);
            });
        }
        Example exampleProcessVariable = new Example(TaProcessVariableEntity.class);
        Example.Criteria criteriaProcessVariable = exampleProcessVariable.createCriteria();
        criteriaProcessVariable.andEqualTo("processId", (Object)processId);
        List taProcessVariableEntities = this.taprocessvariableDao.selectByExample(exampleProcessVariable);
        boolean insterProcessVariable = false;
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)taProcessVariableEntities)) {
            insterProcessVariable = false;
        } else {
            List ids = taProcessVariableEntities.stream().map(IdEntity::getId).collect(Collectors.toList());
            Example exampleProcessVariablePro = new Example(TaProcessVariableProEntity.class);
            Example.Criteria criteriaProcessVariablePro = exampleProcessVariablePro.createCriteria();
            criteriaProcessVariablePro.andIn("id", ids);
            criteriaProcessVariablePro.andEqualTo("procDefId", (Object)processDefinition.getId());
            List taProcessVariableProEntities = this.taProcessVariableProDao.selectByExample(exampleProcessVariablePro);
            if (!CollectionUtil.listNotEmptyNotSizeZero((List)taProcessVariableProEntities)) {
                insterProcessVariable = true;
            }
        }
        if (insterProcessVariable) {
            taProcessVariableEntities.forEach(item -> {
                TaProcessVariableProEntity taProcessVariableProEntity = new TaProcessVariableProEntity();
                BeanUtils.copyProperties((Object)item, (Object)taProcessVariableProEntity);
                taProcessVariableProEntity.setProcDefId(procDefId);
                this.taProcessVariableProDao.insertSelective(taProcessVariableProEntity);
            });
        }
        Example exampleProcessNodeAuth = new Example(TaProcessNodeAuthEntity.class);
        Example.Criteria criteriaProcessNodeAuth = exampleProcessNodeAuth.createCriteria();
        criteriaProcessNodeAuth.andEqualTo("processId", (Object)processId);
        List taProcessNodeAuthEntities = this.taProcessNodeAuthDao.selectByExample(exampleProcessNodeAuth);
        boolean insterProcessNodeAuth = false;
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)taProcessNodeAuthEntities)) {
            insterProcessNodeAuth = false;
        } else {
            List ids = taProcessNodeAuthEntities.stream().map(IdEntity::getId).collect(Collectors.toList());
            Example exampleNodeAuthPro = new Example(TaProcessNodeAuthProEntity.class);
            Example.Criteria criteriaNodeAuthPro = exampleNodeAuthPro.createCriteria();
            criteriaNodeAuthPro.andIn("id", ids);
            criteriaNodeAuthPro.andEqualTo("procDefId", (Object)processDefinition.getId());
            List taProcessNodeAuthProEntities = this.taProcessNodeAuthProDao.selectByExample(exampleNodeAuthPro);
            if (!CollectionUtil.listNotEmptyNotSizeZero((List)taProcessNodeAuthProEntities)) {
                insterProcessNodeAuth = true;
            }
        }
        if (insterProcessNodeAuth) {
            taProcessNodeAuthEntities.forEach(item -> {
                TaProcessNodeAuthProEntity entity = new TaProcessNodeAuthProEntity();
                BeanUtils.copyProperties((Object)item, (Object)entity);
                entity.setProcDefId(procDefId);
                this.taProcessNodeAuthProDao.insertSelective(entity);
            });
        }
        Example exampleTargetConfig = new Example(ActTargetConfigEntity.class);
        Example.Criteria criteriaTargetConfig = exampleTargetConfig.createCriteria();
        criteriaTargetConfig.andEqualTo("processId", (Object)processId);
        List actTargetConfigEntities = this.actTargetConfigDao.selectByExample(exampleTargetConfig);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)actTargetConfigEntities)) {
            Example exampleTargetConfigPro = new Example(ActTargetConfigProEntity.class);
            Example.Criteria criteriaTargetConfigPro = exampleTargetConfigPro.createCriteria();
            criteriaTargetConfigPro.andEqualTo("processId", (Object)processId);
            criteriaTargetConfigPro.andEqualTo("procDefId", (Object)procDefId);
            this.actTargetConfigProDao.deleteByExample(exampleTargetConfigPro);
            actTargetConfigEntities.forEach(item -> {
                ActTargetConfigProEntity actTargetConfigProEntity = new ActTargetConfigProEntity();
                BeanUtils.copyProperties((Object)item, (Object)actTargetConfigProEntity);
                actTargetConfigProEntity.setProcDefId(procDefId);
                this.actTargetConfigProDao.insertSelective(actTargetConfigProEntity);
            });
        }
    }

    private TaRRoleProcDefEntity getTaRRoleProcDefEntity(String deploymentId, String roleCode) {
        TaRRoleProcDefEntity record = new TaRRoleProcDefEntity();
        record.setDeploymentId(deploymentId);
        record.setRoleCode(roleCode);
        return (TaRRoleProcDefEntity)this.taRRoleProcDefDao.selectOne(record);
    }

    @Override
    public PageInfo<TaProcessVo> findTaProcessVoList(TaProcessVo taProcessVo, String roleCode, Page page) {
        PageInfo infoList = PageAutoHelperUtil.generatePage(() -> this.taDeploymentDao.findTaProcessVoList(taProcessVo, roleCode), (Page)page);
        return infoList;
    }
}

