/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.enums.InOrOutType;
import com.biz.eisp.activiti.runtime.dao.TaCarbonCopyDao;
import com.biz.eisp.activiti.runtime.dao.TaCirculationContentDao;
import com.biz.eisp.activiti.runtime.dao.TaCopyDao;
import com.biz.eisp.activiti.runtime.dao.TaTaskDao;
import com.biz.eisp.activiti.runtime.entity.TaCirculationContentEntity;
import com.biz.eisp.activiti.runtime.entity.TaCopyEntity;
import com.biz.eisp.activiti.runtime.service.TaHandCopyAndCirculationService;
import com.biz.eisp.activiti.runtime.vo.BusinessFormVo;
import com.biz.eisp.activiti.runtime.vo.TaCopyCirculationVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.util.ResourceService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taHandCopyAndCirculationService")
@Transactional
public class TaHandCopyAndCirculationServiceImpl
implements TaHandCopyAndCirculationService {
    @Autowired
    private TaTaskDao taTaskDao;
    @Autowired
    private TaCarbonCopyDao taCarbonCopyDao;
    @Autowired
    private TaCopyDao taCopyDao;
    @Autowired
    private ResourceService resource;
    @Autowired
    private TaCirculationContentDao taCirculationContentDao;

    @Override
    public String getCopyAndCirculationBusinessForm(String piId, String businessKey) {
        BusinessFormVo vo = this.taTaskDao.getBusinessFormByProcessInstanceId(piId);
        try {
            String view = vo.getModelandview();
            String objId = vo.getBusinessObjId();
            String modelandview = view + "&businessObjId=" + objId;
            return modelandview;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void updateCarbonOrCirculationState(TaCopyCirculationVo vo) {
        Object sql = null;
        if ("0".equals(vo.getType())) {
            TaCopyEntity record = new TaCopyEntity();
            record.setId(vo.getContentId());
            record.setViewStatus("1");
            this.taCopyDao.updateByPrimaryKeySelective(record);
        } else if ("1".equals(vo.getType())) {
            String positionCode = this.resource.getCurrPosition().getPositionCode();
            TaCirculationContentEntity record = new TaCirculationContentEntity();
            record.setId(vo.getContentId());
            if (InOrOutType.OUT.getValue().equals(vo.getInOutType())) {
                record.setReadStatus("0");
                this.taCirculationContentDao.updateByPrimaryKeySelective(record);
            } else if (InOrOutType.IN.getValue().equals(vo.getInOutType())) {
                record.setViewStatus("1");
                record.setCirculationCode(positionCode);
                this.taCirculationContentDao.updateByPrimaryKeySelective(record);
            }
        } else {
            throw new BusinessException("\u5bf9\u4e0d\u8d77\uff0c\u4f60\u67e5\u9605\u7684\u6570\u636e\u6709\u8bef");
        }
    }

    @Override
    public AjaxJson saveCirculationContent(String id, String content) {
        List list;
        AjaxJson ajaxJson = new AjaxJson();
        TaCirculationContentEntity record = new TaCirculationContentEntity();
        record.setTaCirculationId(id);
        UserRedis userRedis = UserUtils.getUser();
        record.setCirculationCode(userRedis.getPosCode());
        if (StringUtil.isEmpty((String)content)) {
            content = "";
        }
        if (CollectionUtil.listEmpty((List)(list = this.taCirculationContentDao.select(record)))) {
            ajaxJson.setErrMsg("\u8bf7\u5237\u65b0\u754c\u9762\u91cd\u8bd5");
            return ajaxJson;
        }
        for (TaCirculationContentEntity entity : list) {
            entity.setReciveContent(content);
            entity.setReadStatus("1");
            entity.setIsReply("1");
            entity.setViewStatus("1");
            this.taCirculationContentDao.updateByPrimaryKeySelective(entity);
        }
        return ajaxJson;
    }

    @Override
    public List<TaCopyCirculationVo> findCirculationMessage(TaCopyCirculationVo query) {
        List<TaCopyCirculationVo> result = this.taCarbonCopyDao.findCirculationById(query);
        return result;
    }
}

