/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.businessconf.dao.TaProcessBusinessObjConfigDao;
import com.biz.eisp.activiti.designer.businessconf.entity.TaProcessBusinessObjConfigEntity;
import com.biz.eisp.activiti.designer.businessconf.vo.TaProcessBusinessObjConfigVo;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessDao;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.model.diagram.HistoryProcessInstanceDiagramCmd;
import com.biz.eisp.activiti.model.diagram.HistoryProcessInstanceDiagramPositionCmd;
import com.biz.eisp.activiti.runtime.dao.TaBaseBusinessObjDao;
import com.biz.eisp.activiti.runtime.dao.TaProcessApprovalLogDao;
import com.biz.eisp.activiti.runtime.dao.TaProcessInstanceDao;
import com.biz.eisp.activiti.runtime.dao.TaRejectRecordDao;
import com.biz.eisp.activiti.runtime.dao.TaRuntimeStatusDao;
import com.biz.eisp.activiti.runtime.dao.TaTaskDao;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjEntity;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjExtend;
import com.biz.eisp.activiti.runtime.entity.TaProcessApprovalLogEntity;
import com.biz.eisp.activiti.runtime.entity.TaRejectRecordEntity;
import com.biz.eisp.activiti.runtime.entity.TaRuntimeStatusEntity;
import com.biz.eisp.activiti.runtime.service.TaBaseBusinessObjExtendService;
import com.biz.eisp.activiti.runtime.service.TaBaseBusinessObjService;
import com.biz.eisp.activiti.runtime.service.TaProcessInstanceService;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.transformer.HistoricTaskInstanceToHistoryTaskVo;
import com.biz.eisp.activiti.runtime.vo.BusinessFormVo;
import com.biz.eisp.activiti.runtime.vo.HistoryTaskVo;
import com.biz.eisp.activiti.runtime.vo.MyInstanceVo;
import com.biz.eisp.activiti.runtime.vo.ProcessInstanceVo;
import com.biz.eisp.activiti.runtime.vo.RejectAndRecoverHistoryDataVo;
import com.biz.eisp.activiti.runtime.vo.TaProcessApprovalLogVo;
import com.biz.eisp.activiti.util.CommentUtil;
import com.biz.eisp.api.feign.TmPositionFeign;
import com.biz.eisp.api.feign.TmUserFeign;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.user.TmUserVo;
import com.biz.eisp.util.ResourceService;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ManagementService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="taProcessInstanceService")
@Transactional
public class TaProcessInstanceServiceImpl
implements TaProcessInstanceService {
    @Autowired
    private IdentityService identityService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ManagementService managementService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private TaTaskService taTaskService;
    @Autowired
    private TaProcessInstanceDao taProcessInstanceDao;
    @Autowired
    private TaProcessApprovalLogDao taProcessApprovalLogDao;
    @Autowired
    private TaBaseBusinessObjDao taBaseBusinessObjDao;
    @Autowired
    private TaRuntimeStatusDao taRuntimeStatusDao;
    @Autowired
    private TaProcessBusinessObjConfigDao taProcessBusinessObjConfigDao;
    @Autowired
    private TaProcessDao taProcessDao;
    @Autowired
    private TmUserFeign tmUserFeign;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private TaRejectRecordDao taRejectRecordDao;
    @Autowired
    private TaTaskDao taTaskDao;
    @Autowired
    private TmPositionFeign tmPositionFeign;
    @Autowired
    private TaBaseBusinessObjExtendService taBaseBusinessObjExtendService;
    @Autowired
    private TaBaseBusinessObjService taBaseBusinessObjService;

    private TmUserVo findUserInfo(String posId) {
        return (TmUserVo)this.tmUserFeign.findPositionUser(posId).getObj();
    }

    @Override
    public void saveStartWorkflow(String processKey, String positionCode, String businessKey, Map<String, Object> variables) {
        this.identityService.setAuthenticatedUserId(positionCode);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(processKey, businessKey, variables);
        this.taskService.addComment(null, processInstance.getId(), CommentUtil.buildApplyComment(this.resourceService.getCreateName()));
        TmUserVo user = this.resourceService.getUserVo();
        TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
        log.setCreateDate(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        log.setAccount(user.getUsername());
        log.setContent("\u53d1\u8d77\u6d41\u7a0b");
        log.setName(user.getFullname());
        log.setProcessInstId(processInstance.getId());
        log.setPositionCode(this.resourceService.getCurrPosition().getPositionCode());
        log.setPositionName(this.resourceService.getCurrPosition().getPositionName());
        log.setTaskDefKey(null);
        UserRedis userRedis = UserUtils.getUser();
        if (null != userRedis) {
            log.setOperationSource(userRedis.getLoginSource());
        }
        log.setType(Integer.valueOf(1));
        this.taProcessApprovalLogDao.insertSelective(log);
        this.taBaseBusinessObjService.updateBaseBusinessObjRuntimeStatusByProcessInstanceId(processInstance.getId(), WorkFlowGlobals.RUNTIME_STATUS_DOING);
    }

    @Override
    public void saveStartWorkflow(TaProcessBusinessObjConfigVo configVo, TaBaseBusinessObjEntity baseEntity) {
        TaProcessBusinessObjConfigEntity taProcessBusinessObjConfigEntity = (TaProcessBusinessObjConfigEntity)this.taProcessBusinessObjConfigDao.selectByPrimaryKey(configVo.getId());
        if (taProcessBusinessObjConfigEntity != null) {
            TaRuntimeStatusEntity businessObjRuntimeStatus = baseEntity.getTaRuntimeStatusEntity();
            if (WorkFlowGlobals.RUNTIME_STATUS_REJECT.equals(businessObjRuntimeStatus.getCode()) || WorkFlowGlobals.RUNTIME_STATUS_NEW.equals(businessObjRuntimeStatus.getCode())) {
                Map variables = configVo.getVariables();
                ProcessInstance processInstance = this.saveStartWorkflow(baseEntity, variables, taProcessBusinessObjConfigEntity);
                this.taBaseBusinessObjService.updateBaseBusinessObjRuntimeStatusByProcessInstanceId(processInstance.getId(), WorkFlowGlobals.RUNTIME_STATUS_DOING);
            } else {
                throw new BusinessException("\u5df2\u7ecf\u5728\u6d41\u7a0b\u529e\u7406\u4e2d");
            }
        }
    }

    @Override
    public ProcessInstance saveStartWorkflow(TaBaseBusinessObjEntity baseEntity, Map<String, Object> variables, TaProcessBusinessObjConfigEntity configEntity) {
        String positionCode = baseEntity.getPositionCode();
        this.identityService.setAuthenticatedUserId(positionCode);
        String processKey = configEntity.getTaProcessEntity().getProcessKey();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(processKey, baseEntity.getId(), variables);
        UserRedis user = UserUtils.getUser();
        TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
        log.setCreateDate(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        log.setAccount(user.getUsername());
        log.setContent("\u53d1\u8d77\u6d41\u7a0b");
        log.setName(user.getRealname());
        log.setProcessInstId(processInstance.getId());
        log.setPositionCode(this.resourceService.getCurrPosition().getPositionCode());
        log.setPositionName(this.resourceService.getCurrPosition().getPositionName());
        log.setTaskDefKey(null);
        log.setOperationSource(user.getLoginSource());
        log.setType(Integer.valueOf(1));
        this.taProcessApprovalLogDao.insertSelective(log);
        return processInstance;
    }

    @Override
    public ProcessInstance saveStartWorkflow(TaBaseBusinessObjEntity taBaseBusinessObjEntity, String businessObjId, Map<String, Object> variables, TaProcessBusinessObjConfigEntity taProcessBusinessObjConfigEntity) {
        String positionCode = taBaseBusinessObjEntity.getPositionCode();
        this.identityService.setAuthenticatedUserId(positionCode);
        TaProcessEntity processEntity = (TaProcessEntity)this.taProcessDao.selectByPrimaryKey(taProcessBusinessObjConfigEntity.getProcessId());
        String processKey = processEntity.getProcessKey();
        ProcessInstance processInstance = null;
        try {
            processInstance = this.runtimeService.startProcessInstanceByKey(processKey, businessObjId, variables);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException((Throwable)e);
        }
        this.taskService.addComment(null, processInstance.getId(), CommentUtil.buildApplyComment(this.resourceService.getCreateName()));
        TmUserVo user = this.resourceService.getUserVo();
        TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
        log.setCreateDate(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        log.setAccount(user.getUsername());
        log.setContent("\u53d1\u8d77\u6d41\u7a0b");
        log.setName(user.getFullname());
        log.setProcessInstId(processInstance.getId());
        log.setPositionCode(this.resourceService.getCurrPosition().getPositionCode());
        log.setPositionName(this.resourceService.getCurrPosition().getPositionName());
        log.setTaskDefKey(null);
        UserRedis userRedis = UserUtils.getUser();
        if (null != userRedis) {
            log.setOperationSource(userRedis.getLoginSource());
        }
        log.setType(Integer.valueOf(1));
        this.taProcessApprovalLogDao.insertSelective(log);
        return processInstance;
    }

    @Override
    public String saveStartWorkflow(TaProcessBusinessObjConfigVo taProcessBusinessObjConfigVo) {
        TaProcessBusinessObjConfigEntity taProcessBusinessObjConfigEntity = (TaProcessBusinessObjConfigEntity)this.taProcessBusinessObjConfigDao.selectByPrimaryKey(taProcessBusinessObjConfigVo.getId());
        if (taProcessBusinessObjConfigEntity != null) {
            TaBaseBusinessObjEntity taBaseBusinessObjEntity = (TaBaseBusinessObjEntity)this.taBaseBusinessObjDao.selectByPrimaryKey(taProcessBusinessObjConfigVo.getBusinessObjId());
            TaRuntimeStatusEntity doingStatusEntity = this.taRuntimeStatusDao.getOneByCode(WorkFlowGlobals.RUNTIME_STATUS_DOING);
            TaRuntimeStatusEntity businessObjRuntimeStatus = (TaRuntimeStatusEntity)this.taRuntimeStatusDao.selectByPrimaryKey(taBaseBusinessObjEntity.getRuntimeStatusId());
            if (businessObjRuntimeStatus.getCode().equals(WorkFlowGlobals.RUNTIME_STATUS_REJECT) || businessObjRuntimeStatus.getCode().equals(WorkFlowGlobals.RUNTIME_STATUS_RECOVER)) {
                Map variables = taProcessBusinessObjConfigVo.getVariables();
                ProcessInstance instance = this.saveStartWorkflow(taBaseBusinessObjEntity, taProcessBusinessObjConfigVo.getBusinessObjId(), variables, taProcessBusinessObjConfigEntity);
                taBaseBusinessObjEntity.setRuntimeStatusId(doingStatusEntity.getId());
                this.taBaseBusinessObjDao.updateByPrimaryKeySelective(taBaseBusinessObjEntity);
                return instance.getId();
            }
            if (businessObjRuntimeStatus.getCode().equals(WorkFlowGlobals.RUNTIME_STATUS_NEW)) {
                Map variables = taProcessBusinessObjConfigVo.getVariables();
                ProcessInstance instance = this.saveStartWorkflow(taBaseBusinessObjEntity, taProcessBusinessObjConfigVo.getBusinessObjId(), variables, taProcessBusinessObjConfigEntity);
                TaRuntimeStatusEntity runtimeStatusEntity1 = this.taRuntimeStatusDao.getOneByCode(WorkFlowGlobals.RUNTIME_STATUS_DOING);
                taBaseBusinessObjEntity.setRuntimeStatusId(runtimeStatusEntity1.getId());
                this.taBaseBusinessObjDao.updateByPrimaryKeySelective(taBaseBusinessObjEntity);
                return instance.getId();
            }
            throw new BusinessException("\u5df2\u7ecf\u5728\u6d41\u7a0b\u529e\u7406\u4e2d");
        }
        return null;
    }

    @Override
    public PageInfo<MyInstanceVo> findMyStartedProcessList(MyInstanceVo myInstanceVo, Page page) {
        PageInfo infoList = PageAutoHelperUtil.generatePage(() -> this.taProcessInstanceDao.findMyStartedProcessList(myInstanceVo), (Page)page);
        this.calSpendTimes(infoList.getList());
        return infoList;
    }

    @Override
    public List<RejectAndRecoverHistoryDataVo> getRejectAndRecoverHistoryByBusinessObjId(String businessObjId) {
        if (StringUtils.isBlank((CharSequence)businessObjId)) {
            Lists.newArrayList();
        }
        return this.taProcessInstanceDao.getRejectAndRecoverHistoryByBusinessObjId(businessObjId);
    }

    private void bulidCureentActivityUser(List<ProcessInstanceVo> list) {
        for (ProcessInstanceVo vo : list) {
            if ("finished".equals(vo.getIsSuspended())) continue;
            List<TaProcessApprovalLogVo> voList = this.taTaskDao.findRuntimeApprovalList(vo.getId());
            Map<Object, Object> posCodesMap = new HashMap();
            String taskDefKey = "";
            if (CollectionUtil.listNotEmptyNotSizeZero(voList)) {
                for (TaProcessApprovalLogVo item2 : voList) {
                    posCodesMap.put(item2.getAssignees(), item2.getAssignees());
                }
                taskDefKey = voList.get(0).getTaskDefKey();
            } else {
                posCodesMap = this.taTaskService.getNowPosMap(vo.getId());
                taskDefKey = (String)posCodesMap.get("taskDefinitionKey");
            }
            voList = new ArrayList<TaProcessApprovalLogVo>();
            StringBuffer stringBuffer = new StringBuffer();
            posCodesMap.forEach((k, v) -> {
                if (stringBuffer.length() == 0) {
                    stringBuffer.append((String)k);
                } else {
                    stringBuffer.append(",").append((String)k);
                }
            });
            if (stringBuffer.length() <= 0) continue;
            List positionVos = this.tmPositionFeign.getUserAndPositionInfoByPosCodesList(stringBuffer.toString()).getObjList();
            TaProcessApprovalLogVo taProcessApprovalLogVo = new TaProcessApprovalLogVo();
            StringBuffer realname_ = new StringBuffer();
            positionVos.forEach(item -> {
                if (realname_.length() == 0) {
                    realname_.append(item.getFullname());
                } else {
                    realname_.append(",").append(item.getFullname());
                }
            });
            vo.setActivityUser(realname_.toString());
        }
    }

    private void calSpendTimes(List<MyInstanceVo> myInstanceVoList) {
        if (myInstanceVoList != null) {
            for (MyInstanceVo vo : myInstanceVoList) {
                vo.setSpendTimes(DateUtils.calSpendTimes((String)vo.getStartTime(), (String)vo.getEndTime()));
            }
        }
    }

    @Override
    public PageInfo<ProcessInstanceVo> findProcessInstanceList(ProcessInstanceVo processInstanceVo, Page page) {
        PageInfo infoList = PageAutoHelperUtil.generatePage(() -> this.taProcessInstanceDao.findProcessInstanceList(processInstanceVo), (Page)page);
        this.calProcessInstanceSpendTimes(infoList.getList());
        this.bulidCureentActivityUser(infoList.getList());
        return infoList;
    }

    private void calProcessInstanceSpendTimes(List<ProcessInstanceVo> processInstanceVoList) {
        if (processInstanceVoList != null) {
            for (ProcessInstanceVo vo : processInstanceVoList) {
                vo.setSpendTimes(DateUtils.calSpendTimes((String)vo.getStartTime(), (String)vo.getEndTime()));
            }
        }
    }

    @Override
    public InputStream getProcessInstancePicInfo(String processInstanceId) {
        HistoryProcessInstanceDiagramCmd cmd = new HistoryProcessInstanceDiagramCmd(processInstanceId);
        ProcessEngine processEngine = ProcessEngines.getDefaultProcessEngine();
        InputStream is = (InputStream)processEngine.getManagementService().executeCommand((Command)cmd);
        return is;
    }

    @Override
    public String getProcessInstanceIdByTaskId(String taskId) {
        Task task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        return task.getProcessInstanceId();
    }

    public List<String> highLight(String processInstanceId) {
        ArrayList<String> highLight = new ArrayList<String>();
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).list();
        for (Execution execution : executions) {
            ExecutionEntity entity = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(execution.getId()).singleResult();
            highLight.add(entity.getActivityId());
        }
        return highLight;
    }

    @Override
    public List<HistoryTaskVo> findProcessInstanceHistoryTaskList(HistoryTaskVo historyTaskVo) {
        String processInstanceId = historyTaskVo.getProcessInstanceId();
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            throw new BusinessException("\u6d41\u7a0b\u5b9e\u4f8bID\uff08processInstanceId\uff09\u4e3a\u7a7a");
        }
        List historicTaskInstanceList = this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId).list();
        return Lists.transform((List)historicTaskInstanceList, (Function)new HistoricTaskInstanceToHistoryTaskVo());
    }

    @Override
    public List<ActivityImpl> findDiagramPositionList(String processInstanceId) {
        HistoryProcessInstanceDiagramPositionCmd cmd = new HistoryProcessInstanceDiagramPositionCmd(processInstanceId);
        List list = (List)this.managementService.executeCommand((Command)cmd);
        return list;
    }

    @Override
    public void deleteProcessInstance(MyInstanceVo myInstanceVo) {
        String createName = this.resourceService.getCreateName();
        this.runtimeService.deleteProcessInstance(myInstanceVo.getProcessInstanceId(), "\u53d1\u8d77\u4eba" + createName + "\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b");
    }

    @Override
    public void suspendProcessInstance(MyInstanceVo myInstanceVo) {
        this.runtimeService.suspendProcessInstanceById(myInstanceVo.getProcessInstanceId());
    }

    @Override
    public void activateProcessInstance(MyInstanceVo myInstanceVo) {
        this.runtimeService.activateProcessInstanceById(myInstanceVo.getProcessInstanceId());
    }

    @Override
    public void callBackProcess(MyInstanceVo myInstanceVo) {
        String createName = this.resourceService.getCreateName();
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(myInstanceVo.getProcessInstanceId()).singleResult();
        List executionList = this.runtimeService.createExecutionQuery().processInstanceId(myInstanceVo.getProcessInstanceId()).list();
        if (pi == null) {
            throw new BusinessException("\u6d41\u7a0b\u5df2\u5b8c\u6210\u4e0d\u80fd\u8ffd\u56de");
        }
        String businessObjId = pi.getBusinessKey();
        TaBaseBusinessObjEntity entity = (TaBaseBusinessObjEntity)this.taBaseBusinessObjDao.selectByPrimaryKey(businessObjId);
        String runtimeStatus = ((TaRuntimeStatusEntity)this.taRuntimeStatusDao.selectByPrimaryKey(entity.getRuntimeStatusId())).getCode();
        if (runtimeStatus.equals(WorkFlowGlobals.RUNTIME_STATUS_COMPLETED)) {
            throw new BusinessException("\u6d41\u7a0b\u5df2\u5b8c\u6210\u4e0d\u80fd\u8ffd\u56de");
        }
        if (runtimeStatus.equals(WorkFlowGlobals.RUNTIME_STATUS_REJECT)) {
            throw new BusinessException("\u6d41\u7a0b\u5df2\u9a73\u56de\u4e0d\u80fd\u8ffd\u56de");
        }
        this.taskService.addComment(null, pi.getProcessInstanceId(), CommentUtil.buildRecoverComment(createName, "\u8ffd\u56de\u6d41\u7a0b"));
        this.taBaseBusinessObjService.updateBaseBusinessObjRuntimeStatusByProcessInstanceId(myInstanceVo.getProcessInstanceId(), WorkFlowGlobals.RUNTIME_STATUS_RECOVER);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)executionList)) {
            for (Execution execution : executionList) {
                this.runtimeService.setVariable(execution.getId(), "approveOpt", (Object)"RECOVER");
            }
        }
        this.runtimeService.deleteProcessInstance(myInstanceVo.getProcessInstanceId(), WorkFlowGlobals.RUNTIME_STATUS_RECOVER);
        UserRedis userRedis = UserUtils.getUser();
        TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
        log.setCreateDate(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        log.setAccount(userRedis.getUsername());
        log.setContent("\u6d41\u7a0b\u8ffd\u56de");
        log.setName(userRedis.getRealname());
        log.setProcessInstId(myInstanceVo.getProcessInstanceId());
        log.setPositionCode(userRedis.getPosCode());
        log.setPositionName(userRedis.getPosName());
        log.setOperationSource(userRedis.getLoginSource());
        log.setType(Integer.valueOf(2));
        this.taProcessApprovalLogDao.insertSelective(log);
    }

    @Override
    public void closeProcessInstance(MyInstanceVo myInstanceVo) {
        String createName = this.resourceService.getCreateName();
        this.taskService.addComment(null, myInstanceVo.getProcessInstanceId(), CommentUtil.buildCloseComment(createName, "\u5173\u95ed\u6d41\u7a0b"));
        List executionList = this.runtimeService.createExecutionQuery().processInstanceId(myInstanceVo.getProcessInstanceId()).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)executionList)) {
            for (Execution execution : executionList) {
                this.runtimeService.setVariable(execution.getId(), "approveOpt", (Object)"CLOSE");
            }
        }
        this.runtimeService.deleteProcessInstance(myInstanceVo.getProcessInstanceId(), createName + "\u5173\u95ed\u6d41\u7a0b\u5b9e\u4f8b");
    }

    @Override
    public BusinessFormVo getProcessInstanceBusinessForm(String processInstanceId) {
        BusinessFormVo businessFormVo = this.taProcessInstanceDao.getBusinessFormByProcessInstanceId(processInstanceId);
        String modelandview = null;
        if (businessFormVo != null) {
            String url;
            modelandview = businessFormVo.getModelandview();
            Example example = new Example(TaBaseBusinessObjExtend.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("processInstanceId", (Object)processInstanceId);
            List objExtends = this.taBaseBusinessObjExtendService.selectExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)objExtends) && StringUtil.isNotBlank((CharSequence)(url = ((TaBaseBusinessObjExtend)objExtends.get(0)).getBusinessUrl()))) {
                modelandview = url;
            }
            businessFormVo.setModelandview(modelandview);
        }
        return businessFormVo;
    }

    @Override
    public List<TaRuntimeStatusEntity> findTaRuntimeStatusAll() {
        return this.taRuntimeStatusDao.selectAll();
    }

    @Override
    public void updateViewStatus(MyInstanceVo myInstanceVo) {
        if (myInstanceVo == null || StringUtils.isBlank((CharSequence)myInstanceVo.getId())) {
            return;
        }
        TaRejectRecordEntity entity = new TaRejectRecordEntity();
        entity.setViewStatus(Integer.valueOf(1));
        entity.setId(myInstanceVo.getId());
        this.taRejectRecordDao.updateByPrimaryKeySelective(entity);
    }
}

