/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.dingtalk.service.impl;

import com.biz.eisp.activiti.runtime.dao.TaTaskDao;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.vo.CommunicateTaskVo;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.activiti.runtime.vo.TaProcessApprovalLogVo;
import com.biz.eisp.activiti.vo.DingtalkTodoAddReqVo;
import com.biz.eisp.api.feign.TmUserFeign;
import com.biz.eisp.base.TransactionWrapper;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.dingtalk.service.DingActivitiService;
import com.biz.eisp.dingtalk.service.DingtalkTodoService;
import com.biz.eisp.dingtalk.utils.DingtalkConstant;
import com.biz.eisp.user.TmUserDataVo;
import com.biz.eisp.user.entity.TmUserEntity;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.REQUIRES_NEW)
public class DingActivitiServiceImpl
implements DingActivitiService {
    private static final Logger log = LoggerFactory.getLogger(DingActivitiServiceImpl.class);
    @Autowired
    private TaTaskService taTaskService;
    @Autowired
    private TaTaskDao taTaskDao;
    @Autowired
    private DingtalkTodoService dingtalkTodoService;
    @Autowired
    private TmUserFeign tmUserFeign;
    @Autowired
    private TransactionWrapper transactionWrapper;

    @Override
    public void commit(String processInstanceId) {
        this.transactionWrapper.executeOnNew(() -> {
            try {
                this.addDingTodo(processInstanceId);
            }
            catch (Exception e) {
                log.error("DingActivitiServiceImpl.addDingTodo >>>> \u672a\u77e5\u9519\u8bef\uff0c\u5ffd\u7565\u672c\u6b21\u63a8\u9001\u8bf7\u6c42\uff01 processInstanceId={}", (Object)processInstanceId, (Object)e);
            }
            return null;
        });
    }

    private void addDingTodo(String processInstanceId) {
        try {
            if (StringUtils.isBlank((CharSequence)processInstanceId) || !DingtalkConstant.checkOffOrOn()) {
                return;
            }
            this.addTaskNodesTodo(processInstanceId);
            this.addCommunicateTaskTodo(processInstanceId);
        }
        catch (Exception e) {
            log.error("DingActivitiServiceImpl.addDingTodo >>>> \u672a\u77e5\u9519\u8bef\uff0c\u5ffd\u7565\u672c\u6b21\u63a8\u9001\u8bf7\u6c42\uff01 processInstanceId={}", (Object)processInstanceId, (Object)e);
        }
    }

    private void addCommunicateTaskTodo(String processInstanceId) {
        List<CommunicateTaskVo> communicateTaskList = this.taTaskDao.findCommunicateTaskList(processInstanceId);
        if (communicateTaskList.size() == 0) {
            return;
        }
        HashSet positions = Sets.newHashSet();
        for (CommunicateTaskVo communicateTaskVo2 : communicateTaskList) {
            if (StringUtils.isNotBlank((CharSequence)communicateTaskVo2.getLaunchCode())) {
                positions.add(communicateTaskVo2.getLaunchCode());
            }
            if (!StringUtils.isNotBlank((CharSequence)communicateTaskVo2.getCirculationCode())) continue;
            positions.add(communicateTaskVo2.getCirculationCode());
        }
        if (positions.size() == 0) {
            return;
        }
        Map<String, TmUserDataVo> positonMapUser = this.tmUserFeign.findPositionUserByCodes((List)Lists.newArrayList((Iterable)positions)).getObjList().stream().collect(Collectors.toMap(TmUserDataVo::getPositionCode, v -> v, (t, t2) -> t2));
        communicateTaskList.forEach(communicateTaskVo -> {
            TmUserDataVo circulationUser = (TmUserDataVo)positonMapUser.get(communicateTaskVo.getCirculationCode());
            TmUserDataVo launchUser = (TmUserDataVo)positonMapUser.get(communicateTaskVo.getLaunchCode());
            if (null == circulationUser) {
                log.error("DingActivitiServiceImpl.addDingTodo >>>> \u672a\u52a0\u8f7d\u5230\u6c9f\u901a\u63a5\u53d7\u4eba\u7528\u6237\u4fe1\u606f\uff0c\u5ffd\u7565\u672c\u6b21\u8bf7\u6c42\uff01 processInstanceId={}, circulationPositionCode={}", (Object)processInstanceId, (Object)communicateTaskVo.getCirculationCode());
                return;
            }
            DingtalkTodoAddReqVo dingtalkTodoAddReqVo = new DingtalkTodoAddReqVo(communicateTaskVo.getProcessTitle(), processInstanceId, this.buildCommunicateContent((CommunicateTaskVo)communicateTaskVo, launchUser), circulationUser.getUsername(), communicateTaskVo.getCirculationCode(), processInstanceId, communicateTaskVo.getTaskId());
            dingtalkTodoAddReqVo.setId(communicateTaskVo.getId());
            this.dingtalkTodoService.addDingtalkTodo(dingtalkTodoAddReqVo);
        });
    }

    private String buildCommunicateContent(CommunicateTaskVo communicateTaskVo, TmUserDataVo launchUser) {
        String content = "";
        if (null == launchUser) {
            content = content + "\u6c9f\u901a\u6d88\u606f\u3010" + communicateTaskVo.getContent() + "\u3011";
        } else {
            String LaunchName = "";
            if (StringUtils.isNotBlank((CharSequence)communicateTaskVo.getLaunchName())) {
                LaunchName = LaunchName + "(" + communicateTaskVo.getLaunchName() + ")";
            }
            content = content + launchUser.getFullname() + LaunchName + "\u53d1\u8d77\u6c9f\u901a\u3010" + communicateTaskVo.getContent() + "\u3011";
        }
        return content;
    }

    private void addTaskNodesTodo(String processInstanceId) {
        List<TaProcessApprovalLogVo> voList = this.taTaskDao.findRuntimeApprovalList(processInstanceId);
        Map<String, List<String>> map = CollectionUtil.listNotEmptyNotSizeZero(voList) ? voList.stream().collect(Collectors.groupingBy(TaProcessApprovalLogVo::getId, Collectors.mapping(TaProcessApprovalLogVo::getAssignees, Collectors.toList()))) : this.taTaskService.getNowPostMapForDingDing(processInstanceId);
        if (map == null || map.isEmpty()) {
            return;
        }
        MyTaskVo myTaskVo = this.taTaskService.findProcessBasicInfoByProcinstId(processInstanceId);
        if (null == myTaskVo) {
            log.error("DingActivitiServiceImpl.addDingTodo >>>> \u672a\u52a0\u8f7d\u5230\u4efb\u52a1\u4fe1\u606f\uff0c\u5ffd\u7565\u672c\u6b21\u8bf7\u6c42\uff01 processInstanceId={}", (Object)processInstanceId);
            return;
        }
        map.forEach((k, v) -> v.forEach(item -> {
            if (StringUtils.isNotBlank((CharSequence)item)) {
                TmUserEntity userEntity = (TmUserEntity)ApiResultUtil.objResult((AjaxJson)this.tmUserFeign.findPositionUserByIdOrCode(null, item));
                if (null == userEntity) {
                    log.error("DingActivitiServiceImpl.addDingTodo >>>> \u672a\u52a0\u8f7d\u5230\u7528\u6237\u4fe1\u606f\uff0c\u5ffd\u7565\u672c\u6b21\u8bf7\u6c42\uff01 processInstanceId={}, item={}", (Object)processInstanceId, item);
                    return;
                }
                DingtalkTodoAddReqVo dingtalkTodoAddReqVo = new DingtalkTodoAddReqVo(myTaskVo.getProcessTitle(), processInstanceId, myTaskVo.getCreateUserName(), userEntity.getUsername(), item, processInstanceId, k);
                this.dingtalkTodoService.addDingtalkTodo(dingtalkTodoAddReqVo);
            }
        }));
    }

    @Override
    public void pass(String processInstanceId) {
        this.transactionWrapper.executeOnNew(() -> {
            try {
                if (!DingtalkConstant.checkOffOrOn()) {
                    return null;
                }
                this.dingtalkTodoService.updateTodoByProcessInstanceId(processInstanceId);
                this.addDingTodo(processInstanceId);
            }
            catch (Exception e) {
                log.error("DingActivitiServiceImpl.addDingTodo >>>> \u672a\u77e5\u9519\u8bef\uff01 processInstanceId={}", (Object)processInstanceId, (Object)e);
            }
            return null;
        });
    }

    @Override
    public void reject(String processInstanceId) {
        this.transactionWrapper.executeOnNew(() -> {
            try {
                if (!DingtalkConstant.checkOffOrOn()) {
                    return null;
                }
                this.dingtalkTodoService.updateTodoByProcessInstanceId(processInstanceId);
            }
            catch (Exception e) {
                log.error("DingActivitiServiceImpl.addDingTodo >>>> \u672a\u77e5\u9519\u8bef\uff01 processInstanceId={}", (Object)processInstanceId, (Object)e);
            }
            return null;
        });
    }

    @Override
    public void rejectTarger(String processInstanceId) {
        this.transactionWrapper.executeOnNew(() -> {
            try {
                if (!DingtalkConstant.checkOffOrOn()) {
                    return null;
                }
                this.dingtalkTodoService.updateTodoByProcessInstanceId(processInstanceId);
                this.addDingTodo(processInstanceId);
            }
            catch (Exception e) {
                log.error("DingActivitiServiceImpl.addDingTodo >>>> \u672a\u77e5\u9519\u8bef\uff01 processInstanceId={}", (Object)processInstanceId, (Object)e);
            }
            return null;
        });
    }
}

