/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.controller;

import com.biz.eisp.activiti.designer.processconf.dao.ActTargetConfigDao;
import com.biz.eisp.activiti.designer.processconf.entity.ActTargetConfigEntity;
import com.biz.eisp.activiti.designer.processconf.service.ActTargetConfigService;
import com.biz.eisp.activiti.designer.processconf.service.ActTargetContentService;
import com.biz.eisp.activiti.designer.processconf.vo.ActTargetConfigHead;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@RestController
@RequestMapping(value={"actTargetConfigController"})
public class ActTargetConfigController {
    @Autowired
    private ActTargetConfigService actTargetConfigService;
    @Autowired
    private ActTargetContentService actTargetContentService;
    @Autowired
    private ActTargetConfigDao actTargetConfigDao;

    @RequestMapping(value={"getTargetListPage"})
    @ResponseBody
    public DataGrid getTargetListPage(HttpServletRequest request, ActTargetConfigEntity entity) {
        EuPage page = new EuPage(request);
        PageInfo<ActTargetConfigEntity> pageInfo = this.actTargetConfigService.getMaiList(entity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"saveDate"})
    @ResponseBody
    public AjaxJson saveDate(@RequestBody ActTargetConfigHead head) {
        AjaxJson ajaxJson = this.actTargetConfigService.saveData(head.getItems(), head.getProcessId());
        return ajaxJson;
    }

    @RequestMapping(value={"getTargetConfigJson/{processInstanceId}"})
    @ResponseBody
    public AjaxJson getTargetConfigJson(@PathVariable(value="processInstanceId") String processInstanceId) {
        return this.actTargetContentService.getTargetConfigJson(processInstanceId);
    }

    @PostMapping(value={"getTargetConfigByBpmkey"})
    @ResponseBody
    public AjaxJson<ActTargetConfigEntity> getTargetConfigByBpmkey(@RequestParam(value="bpmKey") String bpmKey) {
        AjaxJson ajaxJson = new AjaxJson();
        Example example = new Example(ActTargetConfigEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andCondition(" process_id in ( select id from ta_process where process_key='" + bpmKey + "')");
        example.orderBy("orderNum").asc();
        List entities = this.actTargetConfigDao.selectByExample(example);
        ajaxJson.setList(entities);
        return ajaxJson;
    }
}

