/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.controller;

import com.biz.eisp.activiti.runtime.entity.TaAgencyApprovalEntity;
import com.biz.eisp.activiti.runtime.entity.TaAgencyApprovalProcessEntity;
import com.biz.eisp.activiti.runtime.service.TaAgencyApprovalProcessService;
import com.biz.eisp.activiti.runtime.service.TaAgencyApprovalService;
import com.biz.eisp.activiti.runtime.service.TaProcessInstanceEndExpand;
import com.biz.eisp.activiti.runtime.service.TaRejectRecordService;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.vo.BusinessFormVo;
import com.biz.eisp.activiti.runtime.vo.CommentVo;
import com.biz.eisp.activiti.runtime.vo.HistoryTaskVo;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.activiti.runtime.vo.OperationVo;
import com.biz.eisp.activiti.runtime.vo.TaAgencyApprovalProcessVo;
import com.biz.eisp.activiti.runtime.vo.TaAgencyApprovalVo;
import com.biz.eisp.activiti.runtime.vo.TaProcessApprovalLogVo;
import com.biz.eisp.activiti.runtime.vo.TaRejectRecordVo;
import com.biz.eisp.activiti.util.ActivitiExceptionConvertUtil;
import com.biz.eisp.activiti.util.ParamUtil;
import com.biz.eisp.api.feign.TmPositionFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.dingtalk.service.DingActivitiService;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.util.ResourceService;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.identity.Group;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/taTaskController"})
public class TaTaskController {
    @Autowired
    private TaTaskService taTaskService;
    @Autowired
    private TaRejectRecordService taRejectRecordService;
    @Autowired
    private TmPositionFeign tmPositionFeign;
    @Autowired
    private ResourceService resource;
    @Autowired
    private TaAgencyApprovalService taAgencyApprovalService;
    @Autowired
    private TaAgencyApprovalProcessService taAgencyApprovalProcessService;
    @Autowired
    private DingActivitiService dingActivitiService;
    @Autowired(required=false)
    private TaProcessInstanceEndExpand taProcessInstanceEndExpand;

    @RequestMapping(value={"findMyTaskList"})
    @ResponseBody
    public DataGrid findMyTaskList(HttpServletRequest request) {
        EuPage page = new EuPage(request);
        PageInfo pageInfo = new PageInfo();
        MyTaskVo myTaskVo = new MyTaskVo();
        ParamUtil.packParams(myTaskVo, (Page)page);
        ArrayList<TmPositionVo> tmPositions = new ArrayList<TmPositionVo>();
        TmPositionVo mainPos = (TmPositionVo)this.tmPositionFeign.getUserMainPositon(null, UserUtils.getUser().getId()).getObj();
        tmPositions.add(mainPos);
        List<String> assigneeList = new ArrayList<String>();
        if (CollectionUtil.listNotEmptyNotSizeZero(tmPositions)) {
            for (TmPositionVo tmPositionVo : tmPositions) {
                assigneeList.add(tmPositionVo.getPositionCode());
            }
        } else {
            String positionCode = UserUtils.getUser().getPosCode();
            assigneeList.add(positionCode);
        }
        if (!CollectionUtil.listNotEmptyNotSizeZero(assigneeList)) {
            return new DataGrid(pageInfo);
        }
        List<TaAgencyApprovalEntity> agencyApprovalEntities = this.taAgencyApprovalService.getAgencyApprovalByPoscodes(assigneeList, DateUtils.dateNow2Str());
        if (CollectionUtil.listNotEmptyNotSizeZero(agencyApprovalEntities)) {
            for (TaAgencyApprovalEntity item : agencyApprovalEntities) {
                assigneeList.add(item.getRepresentedPositionCode());
            }
        }
        assigneeList = assigneeList.stream().distinct().collect(Collectors.toList());
        ProcessEngine processEngine = ProcessEngines.getDefaultProcessEngine();
        IdentityService identityService = processEngine.getIdentityService();
        List<Object> roles = new ArrayList();
        for (String item : assigneeList) {
            List groups = identityService.createGroupQuery().groupMember(item).list();
            for (Group temp : groups) {
                roles.add(temp.getType());
            }
        }
        roles = roles.stream().distinct().collect(Collectors.toList());
        roles.add("1");
        myTaskVo.setAssigneeList(assigneeList);
        myTaskVo.setRoleCodes(roles);
        pageInfo = this.taTaskService.findMyTaskList(myTaskVo, (Page)page).getPageInfo();
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"findMyHistoryTaskList"})
    @ResponseBody
    public DataGrid findMyHistoryTaskList(HttpServletRequest request) {
        EuPage page = new EuPage(request);
        HistoryTaskVo historyTaskVo = new HistoryTaskVo();
        ParamUtil.packParams(historyTaskVo, (Page)page);
        historyTaskVo.setAssignee(UserUtils.getUser().getPosCode());
        PageInfo pageInfo = this.taTaskService.findMyHistoryTaskList(historyTaskVo, (Page)page).getPageInfo();
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"findMyRejectTaskList"})
    @ResponseBody
    public DataGrid findMyRejectTaskList(HttpServletRequest request) {
        EuPage page = new EuPage(request);
        TaRejectRecordVo taRejectRecordVo = new TaRejectRecordVo();
        ParamUtil.packParams(taRejectRecordVo, (Page)page);
        List<TmPositionVo> tmPositions = this.resource.getCurrPositionAll();
        ArrayList<String> assigneeList = new ArrayList<String>();
        if (CollectionUtil.listNotEmptyNotSizeZero(tmPositions)) {
            for (TmPositionVo tmPosition : tmPositions) {
                assigneeList.add(tmPosition.getPositionCode());
            }
        } else {
            String positionCode = this.resource.getCurrPosition().getPositionCode();
            assigneeList.add(positionCode);
        }
        taRejectRecordVo.setAssigneeList(assigneeList);
        PageInfo pageInfo = this.taRejectRecordService.findMyRejectTaskList(taRejectRecordVo, (Page)page).getPageInfo();
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"saveComplete"})
    @ResponseBody
    public AjaxJson saveComplete(OperationVo operationVo) {
        AjaxJson json = new AjaxJson();
        try {
            UserRedis userRedis = UserUtils.getUser();
            this.taTaskService.saveComplete(operationVo, userRedis);
            this.dingActivitiService.pass(operationVo.getProcessInstanceId());
            if (null != this.taProcessInstanceEndExpand) {
                this.taProcessInstanceEndExpand.pass(operationVo.getProcessInstanceId());
            }
        }
        catch (ActivitiException e) {
            json.setErrMsg(ActivitiExceptionConvertUtil.getActivitiExceptionMsg(e));
        }
        return json;
    }

    @RequestMapping(value={"saveReject"})
    @ResponseBody
    public AjaxJson saveReject(OperationVo operationVo) {
        AjaxJson json = new AjaxJson();
        try {
            this.taTaskService.saveReject(operationVo);
            this.dingActivitiService.rejectTarger(operationVo.getProcessInstanceId());
            if (null != this.taProcessInstanceEndExpand) {
                this.taProcessInstanceEndExpand.rejectTarger(operationVo.getProcessInstanceId());
            }
        }
        catch (ActivitiException e) {
            json.setErrMsg(ActivitiExceptionConvertUtil.getActivitiExceptionMsg(e));
        }
        return json;
    }

    @RequestMapping(value={"saveRejectToApply"})
    @ResponseBody
    public AjaxJson saveRejectToApply(OperationVo operationVo) {
        AjaxJson json = new AjaxJson();
        try {
            this.taTaskService.saveRejectToApply(operationVo);
            this.dingActivitiService.reject(operationVo.getProcessInstanceId());
            if (null != this.taProcessInstanceEndExpand) {
                this.taProcessInstanceEndExpand.reject(operationVo.getProcessInstanceId());
            }
        }
        catch (ActivitiException e) {
            json.setErrMsg(ActivitiExceptionConvertUtil.getActivitiExceptionMsg(e));
        }
        return json;
    }

    @RequestMapping(value={"saveReadRejectStatus"})
    @ResponseBody
    public AjaxJson saveReadRejectStatus(String recordId) {
        this.taRejectRecordService.updateTaRejectRecordStatus(recordId);
        return new AjaxJson();
    }

    @RequestMapping(value={"goReassignForm"})
    public ModelAndView goReassignForm(MyTaskVo myTaskVo, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        request.setAttribute("taskId", (Object)taskId);
        return new ModelAndView("com/biz/eisp/activiti/task/reassignForm");
    }

    @RequestMapping(value={"reassign"})
    @ResponseBody
    public AjaxJson reassign(MyTaskVo myTaskVo, String reassignComment, String id, HttpServletRequest request) {
        this.taTaskService.reassign(myTaskVo, reassignComment, id);
        return new AjaxJson();
    }

    @RequestMapping(value={"findAgencyApprovalPage"})
    @ResponseBody
    public DataGrid findAgencyApprovalPage(HttpServletRequest request, TaAgencyApprovalVo taAgencyApprovalVo) {
        EuPage page = new EuPage(request);
        taAgencyApprovalVo.setRepresentedUserName(this.resource.getUserVo().getUsername());
        PageInfo<TaAgencyApprovalEntity> pageInfo = this.taAgencyApprovalService.findTaAgencyApprovalPageList(taAgencyApprovalVo, (Page)page);
        if (pageInfo != null) {
            return new DataGrid(pageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"findAgencyApprovalList"})
    @ResponseBody
    public AjaxJson<TaAgencyApprovalEntity> findAgencyApprovalList(@RequestBody TaAgencyApprovalVo taAgencyApprovalVo) {
        AjaxJson ajaxJson = new AjaxJson();
        taAgencyApprovalVo.setRepresentedUserName(this.resource.getUserVo().getUsername());
        List<TaAgencyApprovalEntity> list = this.taAgencyApprovalService.findTaAgencyApprovalList(taAgencyApprovalVo);
        ajaxJson.setObjList(list);
        return ajaxJson;
    }

    @RequestMapping(value={"addAgencyApproval"})
    @ResponseBody
    public AjaxJson addAgencyApproval(String userIds, String beginTime, String endTime, HttpServletRequest request) {
        AjaxJson j = this.taAgencyApprovalService.addAgencyApproval(userIds, beginTime, endTime);
        return j;
    }

    @RequestMapping(value={"saveAgencyApprovalTime"})
    @ResponseBody
    public AjaxJson saveAgencyApprovalTime(String beginTime, String endTime, HttpServletRequest request) {
        AjaxJson j = this.taAgencyApprovalService.saveAgencyApprovalTime(beginTime, endTime);
        return j;
    }

    @RequestMapping(value={"deleteAgencyApproval"})
    @ResponseBody
    public AjaxJson deleteAgencyApproval(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.taAgencyApprovalService.deleteAgencyApproval(ids);
        return j;
    }

    @RequestMapping(value={"findAgencyApprovalProcessPage"})
    @ResponseBody
    public DataGrid findAgencyApprovalProcessPage(HttpServletRequest request, TaAgencyApprovalProcessVo taAgencyApprovalProcessVo) {
        EuPage page = new EuPage(request);
        taAgencyApprovalProcessVo.setRepresentedUserName(this.resource.getUserVo().getUsername());
        PageInfo<TaAgencyApprovalProcessEntity> pageInfo = this.taAgencyApprovalProcessService.findTaAgencyApprovalProcessPageList(taAgencyApprovalProcessVo, (Page)page);
        if (pageInfo != null) {
            return new DataGrid(pageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"deleteAgencyApprovalProcess"})
    @ResponseBody
    public AjaxJson deleteAgencyApprovalProcess(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.taAgencyApprovalProcessService.delete(ids);
        return j;
    }

    @GetMapping(value={"findProcessBasicInfoByProcinstId"})
    @ResponseBody
    public AjaxJson<MyTaskVo> findProcessBasicInfoByProcinstId(@RequestParam(value="processInstanceId") String processInstanceId) {
        AjaxJson ajaxJson = new AjaxJson();
        MyTaskVo processVo = this.taTaskService.findProcessBasicInfoByProcinstId(processInstanceId);
        ajaxJson.setObj((Object)processVo);
        return ajaxJson;
    }

    @GetMapping(value={"getProcessInstanceBusinessForm"})
    @ResponseBody
    public AjaxJson<String> getProcessInstanceBusinessForm(String processInstanceId) {
        AjaxJson ajaxJson = new AjaxJson();
        String modelAndView = this.taTaskService.getProcessInstanceBusinessForm(processInstanceId);
        ajaxJson.setObj((Object)modelAndView);
        return ajaxJson;
    }

    @GetMapping(value={"getTaskBusinessForm"})
    @ResponseBody
    public AjaxJson<BusinessFormVo> getTaskBusinessForm(@RequestParam(value="taskId") String taskId) {
        AjaxJson ajaxJson = new AjaxJson();
        BusinessFormVo vo = this.taTaskService.getTaskBusinessForm(taskId);
        ajaxJson.setObj((Object)vo);
        return ajaxJson;
    }

    @GetMapping(value={"findActHiCommentEntity"})
    @ResponseBody
    public AjaxJson<CommentVo> findActHiCommentEntity(@RequestParam(value="processInstanceId") String processInstanceId) {
        AjaxJson ajaxJson = new AjaxJson();
        List<CommentVo> list = this.taTaskService.findActHiCommentEntity(processInstanceId);
        ajaxJson.setList(list);
        return ajaxJson;
    }

    @GetMapping(value={"hasRejectNodes"})
    @ResponseBody
    public AjaxJson<Boolean> hasRejectNodes(@RequestParam(value="taskId") String taskId, @RequestParam(value="processInstanceId") String processInstanceId) {
        AjaxJson ajaxJson = new AjaxJson();
        boolean hasRejectNodes = this.taTaskService.hasRejectNodes(taskId, processInstanceId);
        ajaxJson.setObj((Object)hasRejectNodes);
        return ajaxJson;
    }

    @PostMapping(value={"findKeyIndicators"})
    @ResponseBody
    public AjaxJson findKeyIndicators(@RequestBody MyTaskVo myTaskVo) {
        AjaxJson ajaxJson = new AjaxJson();
        AjaxJson indicator = this.taTaskService.findKeyIndicators(myTaskVo);
        if (indicator != null) {
            ajaxJson = indicator;
        }
        return ajaxJson;
    }

    @PostMapping(value={"findApprovalLogs"})
    @ResponseBody
    public AjaxJson<TaProcessApprovalLogVo> findApprovalLogs(@RequestBody MyTaskVo myTaskVo) {
        AjaxJson ajaxJson = new AjaxJson();
        List logVos = this.taTaskService.findApprovalLogs(myTaskVo).getObjList();
        ajaxJson.setList(logVos);
        return ajaxJson;
    }

    @PostMapping(value={"findBaseBusinessObjIdByApprovalLogs"})
    @ResponseBody
    public AjaxJson<TaProcessApprovalLogVo> findBaseBusinessObjIdByApprovalLogs(@RequestParam(value="baseBusinessObjId", required=true) String baseBusinessObjId) {
        AjaxJson ajaxJson = new AjaxJson();
        List logVos = this.taTaskService.findBaseBusinessObjIdByApprovalLogs(baseBusinessObjId).getObjList();
        ajaxJson.setList(logVos);
        return ajaxJson;
    }

    @GetMapping(value={"getNowPosMap"})
    @ResponseBody
    public AjaxJson<Map> getNowPosMap(@RequestParam(value="bpmKeys", required=true) String bpmKeys) {
        AjaxJson json = new AjaxJson();
        Map<String, String> result = this.taTaskService.getNowPosMap(bpmKeys);
        json.setObj(result);
        return json;
    }
}

