/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.businessconf.controller;

import com.biz.eisp.activiti.designer.businessconf.service.TaProcessVariableService;
import com.biz.eisp.activiti.designer.businessconf.vo.TaProcessVariableVo;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"taProcessVariableController"})
public class TaProcessVariableController {
    private static final Logger log = LoggerFactory.getLogger(TaProcessVariableController.class);
    @Autowired
    private TaProcessVariableService taProcessVariableService;
    @Autowired
    private TaProcessNodeService taProcessNodeService;

    @RequestMapping(value={"findVariableList"})
    @ResponseBody
    public DataGrid findTaProcessVariableList(String processId, HttpServletRequest request) {
        List<TaProcessVariableVo> list = this.taProcessVariableService.getVariableByProcessId(processId);
        return new DataGrid(list, null);
    }

    @RequestMapping(value={"saveOrUpdateVariable"})
    @ResponseBody
    public AjaxJson saveOrUpdateVariable(TaProcessVariableVo pvVo) {
        AjaxJson aj = new AjaxJson();
        try {
            if (StringUtil.isEmpty((String)pvVo.getId())) {
                this.taProcessVariableService.saveVariable(pvVo);
            } else {
                this.taProcessVariableService.updateVariable(pvVo);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            aj.setMsg("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            aj.setSuccess(false);
        }
        return aj;
    }

    @RequestMapping(value={"delVariableById"})
    @ResponseBody
    public AjaxJson delVariableById(String id) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taProcessVariableService.deleteVariableById(id);
            aj.setMsg("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            aj.setMsg("\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
            aj.setSuccess(false);
        }
        return aj;
    }

    @GetMapping(value={"/taProcessVariableController/getVariableById"})
    @ResponseBody
    public AjaxJson<TaProcessVariableVo> getVariableById(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TaProcessVariableVo vo = this.taProcessVariableService.getVariableById(id);
        ajaxJson.setObj((Object)vo);
        return ajaxJson;
    }
}

