/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.controller;

import com.biz.eisp.activiti.designer.processconf.entity.TaListenerEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaListenerService;
import com.biz.eisp.activiti.designer.processconf.vo.TaListenerVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"taListenerController"})
public class TaListenerController {
    private static final Logger log = LoggerFactory.getLogger(TaListenerController.class);
    @Autowired
    private TaListenerService taListenerService;

    @RequestMapping(value={"goTaListenerMain"})
    public ModelAndView goTaListenerMain() {
        return new ModelAndView("com/biz/eisp/activiti/designer/processconf/taListenerMain");
    }

    @RequestMapping(value={"goTaListenerForm"})
    public ModelAndView goTaListenerForm(String id, HttpServletRequest request) {
        ModelAndView mv = new ModelAndView("com/biz/eisp/activiti/designer/processconf/taListenerForm");
        if (StringUtils.isNotBlank((CharSequence)id)) {
            TaListenerEntity entity = this.taListenerService.getTaListener(id);
            mv.addObject("vo", (Object)entity);
        }
        return mv;
    }

    @RequestMapping(value={"goListenerListPage"})
    public ModelAndView goListenerListPage(String typeId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/processconf/listenerList");
        view.addObject("typeId", (Object)typeId);
        return view;
    }

    @RequestMapping(value={"findTaListenerGird"})
    @ResponseBody
    public DataGrid findTaListenerGrid(TaListenerVo query) {
        List<TaListenerEntity> list = this.taListenerService.findTaListenerList(query);
        return new DataGrid(list, null);
    }

    @RequestMapping(value={"findSelectedListenerList"})
    @ResponseBody
    public DataGrid findSelectedListenerList(String ids, HttpServletRequest request) {
        PageInfo<TaListenerEntity> pageInfo = this.taListenerService.findTaListenerList(ids, null);
        List voList = pageInfo.getList();
        return new DataGrid(voList, null);
    }

    @RequestMapping(value={"saveTaListener"})
    @ResponseBody
    public AjaxJson saveTaListener(TaListenerEntity entity) {
        AjaxJson json = new AjaxJson();
        try {
            this.taListenerService.saveTaListener(entity);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            json.setMsg(e.getMessage());
            json.setSuccess(false);
        }
        return json;
    }

    @RequestMapping(value={"delListener"})
    @ResponseBody
    public AjaxJson delListener(@RequestParam String ids) {
        AjaxJson j = new AjaxJson();
        try {
            this.taListenerService.deleteListenerById(ids);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"setTaListenerState"})
    @ResponseBody
    public AjaxJson setTaListenerState(String ids, String listenerState) {
        AjaxJson j = new AjaxJson();
        String state = this.taListenerService.toggleListenerState(ids, listenerState);
        j.setMsg(state);
        return j;
    }

    @RequestMapping(value={"validateName"})
    @ResponseBody
    public ValidForm validateName(TaListenerVo taListenerVo, String param) {
        ValidForm validForm = new ValidForm();
        taListenerVo.setListenerName(param);
        try {
            this.taListenerService.checkListenerExist(taListenerVo);
        }
        catch (Exception e) {
            validForm.setStatus("n");
            validForm.setInfo(e.getMessage());
        }
        return validForm;
    }

    @GetMapping(value={"getTaListener"})
    @ResponseBody
    public AjaxJson<TaListenerEntity> getTaListener(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TaListenerEntity entity = this.taListenerService.getTaListener(id);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }
}

