/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.controller;

import com.biz.eisp.activiti.designer.processconf.service.TaProcessFunctionAuthService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessFunctionAuthVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"taProcessFunctionAuthController"})
public class TaProcessFunctionAuthController {
    private static final Logger log = LoggerFactory.getLogger(TaProcessFunctionAuthController.class);
    @Autowired
    private TaProcessFunctionAuthService taProcessFunctionAuthService;

    @RequestMapping(value={"goTaProcessFunctionAuthMain"})
    public ModelAndView goTaProcessFunctionAuthMain() {
        return new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessFunctionAuthMain");
    }

    @RequestMapping(value={"goTaProcessFunctionAuthForm"})
    public ModelAndView goTaProcessFunctionAuthForm(String id) {
        ModelAndView mv = new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessFunctionAuthForm");
        if (StringUtils.isNotBlank((CharSequence)id)) {
            TaProcessFunctionAuthVo vo = this.taProcessFunctionAuthService.getTaProcessFunctionAuthVo(id);
            mv.addObject("vo", (Object)vo);
        }
        return mv;
    }

    @RequestMapping(value={"findTaProcessFunctionAuthVoList"})
    @ResponseBody
    public DataGrid findTaProcessFunctionAuthVoList(HttpServletRequest request, TaProcessFunctionAuthVo taProcessFunctionAuthVo) {
        EuPage page = new EuPage(request);
        PageInfo<TaProcessFunctionAuthVo> pageInfo = this.taProcessFunctionAuthService.findTaProcessFunctionAuthVoList(taProcessFunctionAuthVo, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"saveTaProcessFunctionAuth"})
    @ResponseBody
    public AjaxJson saveTaProcessFunctionAuth(TaProcessFunctionAuthVo taProcessFunctionAuthVo, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taProcessFunctionAuthService.saveTaProcessFunctionAuth(taProcessFunctionAuthVo);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            aj.setSuccess(false);
            aj.setMsg("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
        return aj;
    }

    @RequestMapping(value={"deleteTaProcessFunctionAuth"})
    @ResponseBody
    public AjaxJson deleteTaProcessFunctionAuth(String ids, HttpServletRequest request) {
        AjaxJson aj = new AjaxJson();
        try {
            String[] idsArr;
            for (String id : idsArr = ids.split(",")) {
                this.taProcessFunctionAuthService.deleteTaProcessFunctionAuthVo(id);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            aj.setSuccess(false);
            aj.setMsg("\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
        }
        return aj;
    }

    @ResponseBody
    @GetMapping(value={"getTaProcessFunctionAuthVo"})
    public AjaxJson<TaProcessFunctionAuthVo> getTaProcessFunctionAuthVo(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TaProcessFunctionAuthVo vo = this.taProcessFunctionAuthService.getTaProcessFunctionAuthVo(id);
        ajaxJson.setObj((Object)vo);
        return ajaxJson;
    }

    @GetMapping(value={"findTaProcessListByFunctionId"})
    @ResponseBody
    AjaxJson<TaProcessFunctionAuthVo> findTaProcessListByFunctionId(@RequestParam(value="functionId") String functionId) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TaProcessFunctionAuthVo> processVoList = this.taProcessFunctionAuthService.findTaProcessListByFunctionId(functionId);
        ajaxJson.setList(processVoList);
        return ajaxJson;
    }
}

