/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.controller;

import com.alibaba.fastjson.JSON;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeAuthService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeAuthVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"taProcessNodeAuthController"})
public class TaProcessNodeAuthController {
    private static final Logger log = LoggerFactory.getLogger(TaProcessNodeAuthController.class);
    @Autowired
    private TaProcessNodeAuthService taProcessNodeAuthService;

    @RequestMapping(value={"findProcessNodeAuthList"})
    @ResponseBody
    public DataGrid findProcessNodeAuthList(String taProcessId) {
        List<TaProcessNodeAuthVo> list = this.taProcessNodeAuthService.findProcessNodeAuthList(taProcessId);
        return new DataGrid(list, null);
    }

    @RequestMapping(value={"saveConfig"})
    @ResponseBody
    public AjaxJson saveConfig(String jsonStr) {
        AjaxJson aj = new AjaxJson();
        try {
            List voList = JSON.parseArray((String)jsonStr, TaProcessNodeAuthVo.class);
            this.taProcessNodeAuthService.saveConfig(voList);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            aj.setSuccess(false);
            aj.setMsg("\u4fdd\u5b58\u5931\u8d25:" + e.getMessage());
        }
        return aj;
    }

    @GetMapping(value={"getNodeAuthByTaskId"})
    @ResponseBody
    public AjaxJson<TaProcessNodeAuthVo> getNodeAuthByTaskId(@RequestParam(value="taskId") String taskId) {
        AjaxJson ajaxJson = new AjaxJson();
        TaProcessNodeAuthVo nodeAuthVo = this.taProcessNodeAuthService.getNodeAuthByTaskId(taskId);
        ajaxJson.setObj((Object)nodeAuthVo);
        return ajaxJson;
    }
}

