/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.controller;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.runtime.service.TaCarbonCopyService;
import com.biz.eisp.activiti.runtime.service.TaHandCopyAndCirculationService;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.vo.TaCarbonCopyVo;
import com.biz.eisp.activiti.runtime.vo.TaCopyCirculationVo;
import com.biz.eisp.activiti.runtime.vo.TaCopyPersonInfoVo;
import com.biz.eisp.activiti.service.ActivitiRoleService;
import com.biz.eisp.activiti.util.ParamUtil;
import com.biz.eisp.api.feign.TmPositionFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.role.TmActRoleVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/taCarbonCopyController"})
public class TaCarbonCopyController {
    private static final Logger log = LoggerFactory.getLogger(TaCarbonCopyController.class);
    @Autowired
    private ActivitiRoleService roleService;
    @Autowired
    private TmPositionFeign tmPositionFeign;
    @Autowired
    private TaCarbonCopyService taCarbonCopyService;
    @Autowired
    private TaHandCopyAndCirculationService taHandCopyAndCirculationService;
    @Autowired
    private TaTaskService taTaskService;

    @RequestMapping(value={"getRolesOrPositions"})
    @ResponseBody
    public DataGrid getRolesOrPositions(String sendType, TmPositionVo vo, String roleName, String roleCode, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        if (sendType != null && "0".equals(sendType) || "".equals(sendType)) {
            PageInfo<TmActRoleVo> pageInfo = this.roleService.findRoleByCondition(roleCode, roleName, (Page)page);
            return new DataGrid(pageInfo);
        }
        if (sendType != null && sendType.equals("1")) {
            HashMap<String, String> map = new HashMap<String, String>();
            if (!"-1".equals(vo.getOrgId()) && vo.getOrgId() != null) {
                map.put("orgId", vo.getOrgId());
            }
            map.put("page", page.getPage());
            map.put("rows", page.getRows());
            map.put("orgName", vo.getOrgName());
            map.put("positionName", vo.getPositionName());
            map.put("positionCode", vo.getPositionCode());
            map.put("fullname", vo.getFullname());
            PageInfo pageInfo = this.tmPositionFeign.findPositionByPage(map).getPageInfo();
            return new DataGrid(pageInfo);
        }
        return new DataGrid(new ArrayList());
    }

    @RequestMapping(value={"saveCarbonCopy"})
    @ResponseBody
    public AjaxJson saveCarbonCopy(TaCarbonCopyVo vo) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taCarbonCopyService.saveCarbonCopy(vo);
        }
        catch (Exception e) {
            aj.setErrMsg("\u4fdd\u5b58\u5931\u8d25:" + e.getMessage());
            log.error("", (Throwable)e);
        }
        return aj;
    }

    @RequestMapping(value={"findCarbonCopyByTaProcessId"})
    @ResponseBody
    public DataGrid findCarbonCopyByTaProcessId(HttpServletRequest request, TaCarbonCopyVo taCarbonCopyVo) {
        EuPage page = new EuPage(request);
        PageInfo pageInfo = this.taCarbonCopyService.findTaCarbonCopy(taCarbonCopyVo, (Page)page).getPageInfo();
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"delCarbonCopyById"})
    @ResponseBody
    public AjaxJson delCarbonCopyById(String delIds) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taCarbonCopyService.delCarbonCopyById(delIds);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            aj.setErrMsg("\u6570\u636e\u5e93\u53d1\u751f\u5f02\u5e38");
        }
        return aj;
    }

    @RequestMapping(value={"findHomeCarbonCopyList"})
    @ResponseBody
    public DataGrid findHomeCarbonCopyList(TaCopyCirculationVo vo, String time, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        vo.setCreateDate(time);
        ParamUtil.packParams(vo, (Page)page);
        vo.setCreateDate(time);
        PageInfo pageInfo = this.taCarbonCopyService.findCopyAndCirculation(vo, (Page)page).getPageInfo();
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"findCarbonCopyList"})
    @ResponseBody
    public DataGrid findCarbonCopyList(TaCopyCirculationVo vo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        ParamUtil.packParams(vo, (Page)page);
        PageInfo pageInfo = this.taCarbonCopyService.getCarbonCopyByConditions(vo, (Page)page).getPageInfo();
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"saveCirculation"})
    @ResponseBody
    public AjaxJson saveCirculation(String processInstanceId, String codes, String names, String fullNames, String content) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taCarbonCopyService.saveCirculation(processInstanceId, codes, names, fullNames, content);
        }
        catch (Exception e) {
            aj.setSuccess(false);
            aj.setErrMsg(e.getMessage());
            log.error("", (Throwable)e);
        }
        return aj;
    }

    @RequestMapping(value={"saveCirculationContent"})
    @ResponseBody
    public AjaxJson saveCirculationContent(String id, String content) {
        AjaxJson aj = this.taHandCopyAndCirculationService.saveCirculationContent(id, content);
        return aj;
    }

    @RequestMapping(value={"updateCarbonOrCirculationState"})
    @ResponseBody
    public AjaxJson updateCarbonOrCirculationState(TaCopyCirculationVo vo) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taHandCopyAndCirculationService.updateCarbonOrCirculationState(vo);
        }
        catch (Exception e) {
            aj.setErrMsg(e.getMessage());
            log.error("", (Throwable)e);
        }
        return aj;
    }

    private void setKeyIndicators(String processInstanceId, HttpServletRequest request) {
        String modelAndView = this.taTaskService.getProcessInstanceBusinessForm(processInstanceId);
        if (modelAndView != null) {
            modelAndView = modelAndView + "&isKeyIndicators=true";
        }
        request.setAttribute(WorkFlowGlobals.PROCNODE_START, (Object)modelAndView);
    }

    @RequestMapping(value={"findCopyPersonInfoList"})
    @ResponseBody
    public DataGrid findCopyPersonInfoList(TaCopyPersonInfoVo vo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        PageInfo result = this.taCarbonCopyService.findCopyPersonInfoList(vo, (Page)page).getPageInfo();
        return new DataGrid(result);
    }

    @RequestMapping(value={"findCircularizePersonInfoList"})
    @ResponseBody
    public DataGrid findCircularizePersonInfoList(TaCopyCirculationVo vo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        PageInfo result = this.taCarbonCopyService.findCircularizePersonInfoList(vo, (Page)page).getPageInfo();
        return new DataGrid(result);
    }
}

