/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.runtime.dao.TaBaseBusinessObjQueryDao;
import com.biz.eisp.activiti.runtime.dao.TaCommunicateContentDao;
import com.biz.eisp.activiti.runtime.dao.TaCommunicateDao;
import com.biz.eisp.activiti.runtime.dao.TaProcessApprovalLogDao;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjQueryEntity;
import com.biz.eisp.activiti.runtime.entity.TaCommunicateContentEntity;
import com.biz.eisp.activiti.runtime.entity.TaCommunicateEntity;
import com.biz.eisp.activiti.runtime.entity.TaProcessApprovalLogEntity;
import com.biz.eisp.activiti.runtime.service.TaCommunicateService;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.user.TmUserVo;
import com.biz.eisp.util.ResourceService;
import java.util.Date;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taCommunicateService")
@Transactional
public class TaCommunicateServiceImpl
implements TaCommunicateService {
    private static final Logger log = LoggerFactory.getLogger(TaCommunicateServiceImpl.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private ResourceService resource;
    @Autowired
    private TaBaseBusinessObjQueryDao taBaseBusinessObjQueryDao;
    @Autowired
    private TaCommunicateDao taCommunicateDao;
    @Autowired
    private TaCommunicateContentDao taCommunicateContentDao;
    @Autowired
    private TaProcessApprovalLogDao taProcessApprovalLogDao;

    @Override
    public void saveCommunicate(String taskId, String codes, String names, String fullNames, String content, String forceReplyFlag) {
        boolean flag = this.validateValues(taskId, codes, names, content);
        if (flag) {
            String[] code = codes.split(",");
            String[] name = names.split(",");
            String[] fullName = fullNames.split(",");
            Task task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
            ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(task.getProcessDefinitionId()).singleResult();
            String piId = task.getProcessInstanceId();
            ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(piId).singleResult();
            String businessKey = processInstance.getBusinessKey();
            TaBaseBusinessObjQueryEntity businessObjEntity = (TaBaseBusinessObjQueryEntity)this.taBaseBusinessObjQueryDao.selectByPrimaryKey(businessKey);
            String positionCode = businessObjEntity.getPositionCode();
            String positionName = businessObjEntity.getPositionName();
            TaCommunicateEntity communicateEntity = new TaCommunicateEntity();
            communicateEntity.setBusinessKey(businessKey);
            communicateEntity.setProcessInstanceId(piId);
            communicateEntity.setProcessName(processDefinition.getName());
            communicateEntity.setProcessKey(processDefinition.getKey());
            communicateEntity.setProcessTitle(businessObjEntity.getProcessTitle());
            communicateEntity.setLaunchCode(this.resource.getCurrPosition().getPositionCode());
            communicateEntity.setLaunchName(this.resource.getCreateName());
            communicateEntity.setCreateProcessPositionCode(positionCode);
            communicateEntity.setCreateProcessPositionName(positionName);
            communicateEntity.setProcessNodeKey(task.getTaskDefinitionKey());
            communicateEntity.setTaskId(task.getId());
            communicateEntity.setTaskName(task.getName());
            this.taCommunicateDao.insertSelective(communicateEntity);
            for (int i = 0; i < code.length; ++i) {
                TaCommunicateContentEntity communicateContentEntity = new TaCommunicateContentEntity();
                communicateContentEntity.setTaCommunicateId(communicateEntity.getId());
                communicateContentEntity.setContent(content);
                communicateContentEntity.setCirculationCode(code[i]);
                communicateContentEntity.setCirculationName(fullName[i] + "(" + name[i] + ")");
                communicateContentEntity.setViewStatus("0");
                communicateContentEntity.setReadStatus("0");
                communicateContentEntity.setIsReply("0");
                if ("Y".equals(forceReplyFlag)) {
                    communicateContentEntity.setForceReplyFlag("Y");
                } else {
                    communicateContentEntity.setForceReplyFlag("N");
                }
                this.taCommunicateContentDao.insertSelective(communicateContentEntity);
                this.saveApproveLog(piId, task.getTaskDefinitionKey(), content, name[i], fullName[i]);
            }
        } else {
            throw new BusinessException("\u6c9f\u901a\u6570\u636e\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff0c\u8bf7\u68c0\u67e5");
        }
    }

    @Override
    public void saveSureCommunicate(String communicateId, String content) {
        TaCommunicateContentEntity communicateContentEntity = (TaCommunicateContentEntity)this.taCommunicateContentDao.selectByPrimaryKey(communicateId);
        communicateContentEntity.setIsReply("1");
        communicateContentEntity.setReciveContent(content);
        communicateContentEntity.setForceReplyFlag("N");
        this.taCommunicateContentDao.updateByPrimaryKeySelective(communicateContentEntity);
        TaCommunicateEntity communicateEntity = (TaCommunicateEntity)this.taCommunicateDao.selectByPrimaryKey(communicateContentEntity.getTaCommunicateId());
        this.saveReplyApproveLog(communicateEntity.getProcessInstanceId(), communicateEntity.getProcessNodeKey(), content);
    }

    @Override
    public TaCommunicateContentEntity getCommunicateContentById(String id) {
        return (TaCommunicateContentEntity)this.taCommunicateContentDao.selectByPrimaryKey(id);
    }

    private void saveApproveLog(String processInstanceId, String taskDefinitionKey, String content, String positionName, String fullName) {
        TaProcessApprovalLogEntity log1 = new TaProcessApprovalLogEntity();
        TmUserVo user = this.resource.getUserVo();
        log1.setCreateDate(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        log1.setAccount(user.getUsername());
        log1.setContent("\u3010" + positionName + " " + fullName + "\u3011" + content);
        log1.setName(user.getFullname());
        log1.setProcessInstId(processInstanceId);
        try {
            log1.setTaskDefKey(taskDefinitionKey);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        log1.setType(Integer.valueOf(3));
        this.taProcessApprovalLogDao.insertSelective(log1);
    }

    private void saveReplyApproveLog(String processInstanceId, String taskDefinitionKey, String content) {
        TaProcessApprovalLogEntity log1 = new TaProcessApprovalLogEntity();
        TmUserVo user = this.resource.getUserVo();
        log1.setCreateDate(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        log1.setAccount(user.getUsername());
        log1.setContent(content);
        log1.setName(user.getFullname());
        log1.setProcessInstId(processInstanceId);
        try {
            log1.setTaskDefKey(taskDefinitionKey);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        log1.setType(Integer.valueOf(3));
        this.taProcessApprovalLogDao.insertSelective(log1);
    }

    private boolean validateValues(String ... strs) {
        for (String str : strs) {
            if (!StringUtils.isBlank((CharSequence)str)) continue;
            return false;
        }
        return true;
    }
}

