/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.entity.activiti.ActHiActinstEntity;
import com.biz.eisp.activiti.runtime.cmd.JumpTaskCmd;
import com.biz.eisp.activiti.runtime.dao.ActHiActinstDao;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.service.TaskFlowControlService;
import com.biz.eisp.activiti.runtime.vo.OperationVo;
import com.biz.eisp.activiti.util.CommentUtil;
import com.biz.eisp.util.ResourceService;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.RuntimeServiceImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taskFlowControlService")
@Transactional
public class TaskFlowControlServiceImpl
implements TaskFlowControlService {
    private static final Logger log = LoggerFactory.getLogger(TaskFlowControlServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(TaskFlowControlServiceImpl.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired(required=false)
    private RepositoryServiceImpl repositoryService;
    @Autowired
    private TaTaskService taTaskService;
    @Autowired
    private ResourceService resource;
    @Autowired
    private ActHiActinstDao actHiActinstDao;

    @Override
    public void jump(OperationVo operationVo) {
        try {
            TaskEntity currentTaskEntity = (TaskEntity)this.taskService.createTaskQuery().taskId(operationVo.getTaskId()).singleResult();
            ActivityImpl activity = this.getActivity(currentTaskEntity.getProcessDefinitionId(), operationVo.getTaskDefKey());
            String detailComment = CommentUtil.buildRejectPreComment(currentTaskEntity.getName(), this.resource.getCreateName(), operationVo.getComment());
            this.taskService.addComment(operationVo.getTaskId(), operationVo.getProcessInstanceId(), detailComment);
            CommandExecutor commandExecutor = ((RuntimeServiceImpl)this.runtimeService).getCommandExecutor();
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("taskDefKey", operationVo.getTaskDefKey());
            variables.put("approveOpt", "REJECT_PRE");
            variables.put("processInstanceId", currentTaskEntity.getProcessInstanceId());
            commandExecutor.execute((Command)new JumpTaskCmd(currentTaskEntity, activity, variables));
            this.doAfterJump(operationVo.getTaskId());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public ActivityImpl getActivity(String processDefId, String taskDefKey) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getDeployedProcessDefinition(processDefId);
        List activitiList = processDefinition.getActivities();
        for (ActivityImpl activityImpl : activitiList) {
            if (!activityImpl.getId().equals(taskDefKey)) continue;
            return activityImpl;
        }
        return null;
    }

    private void doAfterJump(String taskId) {
        ActHiActinstEntity actHiActinstEntity = new ActHiActinstEntity();
        actHiActinstEntity.setTaskId(taskId);
        actHiActinstEntity = (ActHiActinstEntity)this.actHiActinstDao.selectOne(actHiActinstEntity);
        if (actHiActinstEntity != null) {
            Timestamp nowTime = new Timestamp(System.currentTimeMillis());
            actHiActinstEntity.setEndTime(nowTime);
            actHiActinstEntity.setDuration(nowTime.getTime() - actHiActinstEntity.getStartTime().getTime());
            this.actHiActinstDao.updateByPrimaryKeySelective(actHiActinstEntity);
        }
    }
}

